/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.appium;

import com.applitools.eyes.EyesBase;
import com.applitools.eyes.EyesException;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MobileDeviceInfo;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.appium.Eyes;
import com.applitools.eyes.appium.EyesAppiumElement;
import com.applitools.eyes.appium.EyesAppiumUtils;
import com.applitools.eyes.config.Feature;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.TraceLevel;
import com.applitools.eyes.selenium.EyesDriverUtils;
import com.applitools.eyes.selenium.positioning.ImageRotation;
import com.applitools.eyes.selenium.wrappers.EyesWebDriver;
import com.applitools.utils.GeneralUtils;
import com.applitools.utils.ImageUtils;
import io.appium.java_client.AppiumDriver;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebElement;

public class EyesAppiumDriver
extends EyesWebDriver {
    private final AppiumDriver driver;
    private Map<String, Object> sessionDetails;
    private final Map<String, WebElement> elementsIds = new HashMap<String, WebElement>();
    private ImageRotation rotation;
    private RectangleSize defaultContentViewportSize = null;
    private Map<String, Integer> systemBarsHeights = null;
    private Integer deviceHeight = null;

    public EyesAppiumDriver(Logger logger, Eyes eyes, AppiumDriver driver) {
        super(logger, (EyesBase)eyes);
        this.driver = driver;
    }

    public AppiumDriver getRemoteWebDriver() {
        return this.driver;
    }

    public ImageRotation getRotation() {
        return this.rotation;
    }

    public void setRotation(ImageRotation rotation) {
        this.rotation = rotation;
    }

    private Map<String, Object> getCachedSessionDetails() {
        if (this.sessionDetails == null) {
            this.sessionDetails = this.getRemoteWebDriver().getSessionDetails();
        }
        return this.sessionDetails;
    }

    public HashMap<String, Integer> getViewportRect() {
        Map rectMap = (Map)this.getCachedSessionDetails().get("viewportRect");
        int width = ((Long)rectMap.get("width")).intValue();
        int height = ((Long)rectMap.get("height")).intValue();
        if (this.getEyesBase().getConfiguration().isFeatureActivated(Feature.USE_PREDEFINED_DEVICE_INFO)) {
            Map mobileDevicesInfo = this.getEyesBase().getMobileDeviceInfo();
            String deviceName = this.getEyesBase().getConfiguration().getDeviceInfo();
            deviceName = deviceName == null ? EyesDriverUtils.getMobileDeviceName((HasCapabilities)this) : deviceName;
            block0: for (MobileDeviceInfo mobileDeviceInfo : mobileDevicesInfo.values()) {
                for (String name : mobileDeviceInfo.getAliases()) {
                    if (!deviceName.equalsIgnoreCase(name)) continue;
                    height = mobileDeviceInfo.getViewportRect().getHeight();
                    width = mobileDeviceInfo.getViewportRect().getWidth();
                    continue block0;
                }
            }
        } else {
            height = this.ensureViewportHeight(height);
        }
        HashMap<String, Integer> intRectMap = new HashMap<String, Integer>();
        intRectMap.put("width", width);
        intRectMap.put("height", height);
        return intRectMap;
    }

    public int getViewportHeight() {
        Map rectMap = (Map)this.getCachedSessionDetails().get("viewportRect");
        return ((Long)rectMap.get("height")).intValue();
    }

    private int ensureViewportHeight(int viewportHeight) {
        if (EyesDriverUtils.isAndroid((WebDriver)this.driver)) {
            try {
                int height = this.getDeviceHeight();
                Map<String, Integer> systemBarsHeights = this.getSystemBarsHeights();
                for (Integer barHeight : systemBarsHeights.values()) {
                    if (barHeight == null || barHeight >= height) continue;
                    height -= barHeight.intValue();
                }
                return height;
            }
            catch (Exception e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.GENERAL, (Throwable)e, (String[])new String[0]);
            }
        }
        return viewportHeight;
    }

    public int getDeviceHeight() {
        if (this.deviceHeight == null) {
            String deviceScreenSize = (String)this.getCachedSessionDetails().get("deviceScreenSize");
            Pattern p = Pattern.compile("x(\\d+)");
            Matcher m = p.matcher(deviceScreenSize);
            m.find();
            this.deviceHeight = Integer.parseInt(m.group(1));
        }
        return this.deviceHeight;
    }

    public Map<String, Integer> getSystemBarsHeights() {
        if (this.systemBarsHeights == null) {
            this.systemBarsHeights = EyesAppiumUtils.getSystemBarsHeights(this);
        }
        return this.systemBarsHeights;
    }

    protected double getDevicePixelRatioInner() {
        Object pixelRatio = this.getCachedSessionDetails().get("pixelRatio");
        if (pixelRatio instanceof Double) {
            return (Double)pixelRatio;
        }
        return ((Long)pixelRatio).doubleValue();
    }

    public int getStatusBarHeight() {
        Object statusBarHeight;
        if (this.getEyesBase().getConfiguration().isFeatureActivated(Feature.USE_PREDEFINED_DEVICE_INFO)) {
            Map mobileDevicesInfo = this.getEyesBase().getMobileDeviceInfo();
            String deviceName = this.getEyesBase().getConfiguration().getDeviceInfo();
            deviceName = deviceName == null ? EyesDriverUtils.getMobileDeviceName((HasCapabilities)this) : deviceName;
            for (MobileDeviceInfo mobileDeviceInfo : mobileDevicesInfo.values()) {
                for (String name : mobileDeviceInfo.getAliases()) {
                    if (!deviceName.equalsIgnoreCase(name)) continue;
                    return mobileDeviceInfo.getViewportRect().getTop();
                }
            }
        }
        if ((statusBarHeight = this.getCachedSessionDetails().get("statBarHeight")) instanceof Double) {
            return ((Double)statusBarHeight).intValue();
        }
        return ((Long)statusBarHeight).intValue();
    }

    public List<WebElement> findElements(By by) {
        List foundWebElementsList = this.driver.findElements(by);
        ArrayList<WebElement> resultElementsList = new ArrayList<WebElement>(foundWebElementsList.size());
        for (WebElement currentElement : foundWebElementsList) {
            if (!(currentElement instanceof RemoteWebElement)) {
                throw new EyesException(String.format("findElements: element is not a RemoteWebElement: %s", by));
            }
            resultElementsList.add((WebElement)new EyesAppiumElement(this, currentElement, 1.0 / this.getDevicePixelRatio()));
            this.elementsIds.put(((RemoteWebElement)currentElement).getId(), currentElement);
        }
        return resultElementsList;
    }

    public EyesAppiumElement findElement(By by) {
        WebElement webElement = this.driver.findElement(by);
        if (!(webElement instanceof RemoteWebElement)) {
            throw new EyesException("findElement: Element is not a RemoteWebElement: " + by);
        }
        EyesAppiumElement appiumElement = new EyesAppiumElement(this, webElement, 1.0 / this.getDevicePixelRatio());
        this.elementsIds.put(((RemoteWebElement)webElement).getId(), webElement);
        return appiumElement;
    }

    public WebElement findElementByClassName(String className) {
        return this.findElement(By.className((String)className));
    }

    public List<WebElement> findElementsByClassName(String className) {
        return this.findElements(By.className((String)className));
    }

    public WebElement findElementByCssSelector(String cssSelector) {
        return this.findElement(By.cssSelector((String)cssSelector));
    }

    public List<WebElement> findElementsByCssSelector(String cssSelector) {
        return this.findElements(By.cssSelector((String)cssSelector));
    }

    public WebElement findElementById(String id) {
        return this.findElement(By.id((String)id));
    }

    public List<WebElement> findElementsById(String id) {
        return this.findElements(By.id((String)id));
    }

    public WebElement findElementByLinkText(String linkText) {
        return this.findElement(By.linkText((String)linkText));
    }

    public List<WebElement> findElementsByLinkText(String linkText) {
        return this.findElements(By.linkText((String)linkText));
    }

    public WebElement findElementByPartialLinkText(String partialLinkText) {
        return this.findElement(By.partialLinkText((String)partialLinkText));
    }

    public List<WebElement> findElementsByPartialLinkText(String partialLinkText) {
        return this.findElements(By.partialLinkText((String)partialLinkText));
    }

    public WebElement findElementByName(String name) {
        return this.findElement(By.name((String)name));
    }

    public List<WebElement> findElementsByName(String name) {
        return this.findElements(By.name((String)name));
    }

    public WebElement findElementByTagName(String tagName) {
        return this.findElement(By.tagName((String)tagName));
    }

    public List<WebElement> findElementsByTagName(String tagName) {
        return this.findElements(By.tagName((String)tagName));
    }

    public WebElement findElementByXPath(String path) {
        return this.findElement(By.xpath((String)path));
    }

    public List<WebElement> findElementsByXPath(String path) {
        return this.findElements(By.xpath((String)path));
    }

    public Capabilities getCapabilities() {
        return this.driver.getCapabilities();
    }

    public RectangleSize getDefaultContentViewportSize(boolean forceQuery) {
        if (this.defaultContentViewportSize != null && !forceQuery) {
            return this.defaultContentViewportSize;
        }
        HashMap<String, Integer> rect = this.getViewportRect();
        double dpr = this.getDevicePixelRatio();
        this.defaultContentViewportSize = new RectangleSize(rect.get("width").intValue(), rect.get("height").intValue()).scale(1.0 / dpr);
        this.logger.log(TraceLevel.Info, null, Stage.GENERAL, new Pair[]{Pair.of((Object)"defaultContentViewportSize", (Object)this.defaultContentViewportSize)});
        return this.defaultContentViewportSize;
    }

    public RectangleSize getDefaultContentViewportSize() {
        return this.getDefaultContentViewportSize(true);
    }

    public <X> X getScreenshotAs(OutputType<X> xOutputType) throws WebDriverException {
        String screenshot64 = (String)this.driver.getScreenshotAs(OutputType.BASE64);
        BufferedImage screenshot = ImageUtils.imageFromBase64((String)screenshot64);
        screenshot = EyesAppiumUtils.normalizeRotation(this.logger, (WebDriver)this.driver, screenshot, this.rotation);
        screenshot64 = ImageUtils.base64FromImage((BufferedImage)screenshot);
        return (X)xOutputType.convertFromBase64Png(screenshot64);
    }

    public String getPageSource() {
        return this.driver.getPageSource();
    }

    public void close() {
        this.driver.close();
    }

    public void quit() {
        this.driver.quit();
    }

    public Set<String> getWindowHandles() {
        return this.driver.getWindowHandles();
    }

    public String getWindowHandle() {
        return this.driver.getWindowHandle();
    }

    public WebDriver.TargetLocator switchTo() {
        return this.driver.switchTo();
    }

    public WebDriver.Navigation navigate() {
        return this.driver.navigate();
    }

    public WebDriver.Options manage() {
        return this.driver.manage();
    }

    public void get(String url) {
        this.driver.get(url);
    }

    public String getCurrentUrl() {
        return this.driver.getCurrentUrl();
    }

    public String getTitle() {
        return this.driver.getTitle();
    }

    public Map<String, WebElement> getElementIds() {
        return this.elementsIds;
    }

    public Object executeScript(String script, Object ... args) {
        return this.driver.executeScript(script, args);
    }

    public Object executeAsyncScript(String script, Object ... args) {
        return this.driver.executeAsyncScript(script, args);
    }
}

