/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.appium;

import com.applitools.ICheckSettings;
import com.applitools.eyes.AbstractProxySettings;
import com.applitools.eyes.AppEnvironment;
import com.applitools.eyes.AppOutput;
import com.applitools.eyes.BatchInfo;
import com.applitools.eyes.CoordinatesType;
import com.applitools.eyes.CutProvider;
import com.applitools.eyes.EyesBase;
import com.applitools.eyes.EyesScreenshot;
import com.applitools.eyes.ImageMatchSettings;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.MatchLevel;
import com.applitools.eyes.MatchResult;
import com.applitools.eyes.MatchWindowData;
import com.applitools.eyes.MatchWindowTask;
import com.applitools.eyes.NullCutProvider;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.ScaleProvider;
import com.applitools.eyes.ScaleProviderFactory;
import com.applitools.eyes.ScaleProviderIdentityFactory;
import com.applitools.eyes.SessionType;
import com.applitools.eyes.TestResults;
import com.applitools.eyes.appium.AppiumCaptureAlgorithmFactory;
import com.applitools.eyes.appium.AppiumCheckSettings;
import com.applitools.eyes.appium.AppiumFullPageCaptureAlgorithm;
import com.applitools.eyes.appium.AppiumScrollPositionProvider;
import com.applitools.eyes.appium.AppiumScrollPositionProviderFactory;
import com.applitools.eyes.appium.EyesAppiumDriver;
import com.applitools.eyes.appium.EyesAppiumElement;
import com.applitools.eyes.appium.EyesAppiumScreenshot;
import com.applitools.eyes.appium.EyesAppiumScreenshotFactory;
import com.applitools.eyes.appium.EyesAppiumUtils;
import com.applitools.eyes.appium.Target;
import com.applitools.eyes.appium.capture.ImageProviderFactory;
import com.applitools.eyes.appium.capture.MobileImageProvider;
import com.applitools.eyes.appium.capture.MobileScreenshotProvider;
import com.applitools.eyes.appium.locators.AndroidVisualLocatorProvider;
import com.applitools.eyes.appium.locators.IOSVisualLocatorProvider;
import com.applitools.eyes.capture.ImageProvider;
import com.applitools.eyes.capture.ScreenshotProvider;
import com.applitools.eyes.config.Configuration;
import com.applitools.eyes.events.ValidationInfo;
import com.applitools.eyes.events.ValidationResult;
import com.applitools.eyes.exceptions.TestFailedException;
import com.applitools.eyes.fluent.GetSimpleRegion;
import com.applitools.eyes.fluent.ICheckSettingsInternal;
import com.applitools.eyes.fluent.SimpleRegionByRectangle;
import com.applitools.eyes.locators.BaseOcrRegion;
import com.applitools.eyes.locators.OcrRegion;
import com.applitools.eyes.locators.VisualLocatorSettings;
import com.applitools.eyes.locators.VisualLocatorsProvider;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.TraceLevel;
import com.applitools.eyes.logging.Type;
import com.applitools.eyes.positioning.PositionProvider;
import com.applitools.eyes.scaling.FixedScaleProviderFactory;
import com.applitools.eyes.scaling.NullScaleProvider;
import com.applitools.eyes.selenium.ClassicRunner;
import com.applitools.eyes.selenium.EyesDriverUtils;
import com.applitools.eyes.selenium.StitchMode;
import com.applitools.eyes.selenium.fluent.SimpleRegionByElement;
import com.applitools.eyes.selenium.positioning.ImageRotation;
import com.applitools.eyes.selenium.positioning.NullRegionPositionCompensation;
import com.applitools.eyes.selenium.positioning.RegionPositionCompensation;
import com.applitools.eyes.selenium.regionVisibility.MoveToRegionVisibilityStrategy;
import com.applitools.eyes.selenium.regionVisibility.NopRegionVisibilityStrategy;
import com.applitools.eyes.selenium.regionVisibility.RegionVisibilityStrategy;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.ClassVersionGetter;
import com.applitools.utils.GeneralUtils;
import com.applitools.utils.ImageUtils;
import com.applitools.utils.PropertyHandler;
import com.applitools.utils.ReadOnlyPropertyHandler;
import com.applitools.utils.SimplePropertyHandler;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.MobileBy;
import java.awt.image.BufferedImage;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;

public class Eyes
extends EyesBase {
    private static final int USE_DEFAULT_MATCH_TIMEOUT = -1;
    private static final int DEFAULT_STITCH_OVERLAP = 50;
    private static final int IOS_STITCH_OVERLAP = 0;
    public static final double UNKNOWN_DEVICE_PIXEL_RATIO = 0.0;
    public static final double DEFAULT_DEVICE_PIXEL_RATIO = 1.0;
    private Configuration configuration = new Configuration();
    private EyesAppiumDriver driver;
    private VisualLocatorsProvider visualLocatorsProvider;
    private WebElement cutElement;
    private ImageProvider imageProvider;
    private double devicePixelRatio = 0.0;
    private boolean stitchContent;
    private RegionPositionCompensation regionPositionCompensation;
    private ImageRotation rotation;
    protected WebElement targetElement = null;
    private PropertyHandler<RegionVisibilityStrategy> regionVisibilityStrategyHandler = new SimplePropertyHandler();
    private WebElement scrollRootElement = null;
    private By scrollRootElementSelector = null;

    public Eyes() {
        super(new ClassicRunner());
        this.regionVisibilityStrategyHandler.set((Object)new MoveToRegionVisibilityStrategy());
        this.configuration.setStitchOverlap(50);
    }

    public WebDriver open(WebDriver driver, Configuration configuration) {
        this.configuration = new Configuration(configuration);
        return this.open(driver);
    }

    public WebDriver open(WebDriver driver, String appName, String testName, RectangleSize viewportSize) {
        this.logger.log(TraceLevel.Info, Collections.singleton(this.getTestId()), Stage.OPEN, Type.CALLED, new Pair[]{Pair.of((Object)"appName", (Object)appName), Pair.of((Object)"testName", (Object)testName), Pair.of((Object)"viewportSize", (Object)(viewportSize == null ? "default" : viewportSize))});
        this.configuration.setAppName(appName);
        this.configuration.setTestName(testName);
        this.configuration.setViewportSize(viewportSize);
        return this.open(driver);
    }

    public WebDriver open(WebDriver driver, String appName, String testName) {
        this.logger.log(TraceLevel.Info, Collections.singleton(this.getTestId()), Stage.OPEN, Type.CALLED, new Pair[]{Pair.of((Object)"appName", (Object)appName), Pair.of((Object)"testName", (Object)testName)});
        this.configuration.setAppName(appName);
        this.configuration.setTestName(testName);
        return this.open(driver);
    }

    protected WebDriver open(WebDriver driver, String appName, String testName, RectangleSize viewportSize, SessionType sessionType) {
        this.logger.log(TraceLevel.Info, Collections.singleton(this.getTestId()), Stage.OPEN, Type.CALLED, new Pair[]{Pair.of((Object)"appName", (Object)appName), Pair.of((Object)"testName", (Object)testName), Pair.of((Object)"viewportSize", (Object)(viewportSize == null ? "default" : viewportSize)), Pair.of((Object)"sessionType", (Object)sessionType)});
        this.configuration.setAppName(appName);
        this.configuration.setTestName(testName);
        this.configuration.setViewportSize(viewportSize);
        this.configuration.setSessionType(sessionType);
        return this.open(driver);
    }

    private WebDriver open(WebDriver webDriver) {
        if (this.getIsDisabled()) {
            return webDriver;
        }
        ArgumentGuard.notNull((Object)webDriver, (String)"driver");
        this.initDriver(webDriver);
        this.tryUpdateDevicePixelRatio();
        this.ensureViewportSize();
        this.openBase();
        this.initImageProvider();
        this.regionPositionCompensation = new NullRegionPositionCompensation();
        this.initDriverBasedPositionProviders();
        this.initVisualLocatorProvider();
        this.driver.setRotation(this.getRotation());
        return this.driver;
    }

    public void checkWindow() {
        this.checkWindow(null);
    }

    public void checkWindow(String tag) {
        this.check(tag, (ICheckSettings)Target.window());
    }

    public void checkWindow(int matchTimeout, String tag) {
        this.check(tag, Target.window().timeout(matchTimeout));
    }

    public void checkWindow(String tag, boolean fully) {
        this.check(tag, (ICheckSettings)Target.window().fully(fully));
    }

    public void check(String name, ICheckSettings checkSettings) {
        if (this.getIsDisabled()) {
            return;
        }
        ArgumentGuard.notNull((Object)checkSettings, (String)"checkSettings");
        checkSettings = checkSettings.withName(name);
        this.check(checkSettings);
    }

    protected void ensureViewportSize() {
        this.configuration.setViewportSize(this.driver.getDefaultContentViewportSize());
    }

    public ImageRotation getRotation() {
        return this.rotation;
    }

    public void setRotation(ImageRotation rotation) {
        this.rotation = rotation;
        if (this.driver != null) {
            this.driver.setRotation(rotation);
        }
    }

    public void setForceFullPageScreenshot(boolean shouldForce) {
        this.configuration.setForceFullPageScreenshot(shouldForce);
    }

    public boolean getForceFullPageScreenshot() {
        Boolean forceFullPageScreenshot = this.configuration.getForceFullPageScreenshot();
        if (forceFullPageScreenshot == null) {
            return false;
        }
        return forceFullPageScreenshot;
    }

    public void setScrollToRegion(boolean shouldScroll) {
        this.regionVisibilityStrategyHandler = shouldScroll ? new ReadOnlyPropertyHandler((Object)new MoveToRegionVisibilityStrategy()) : new ReadOnlyPropertyHandler((Object)new NopRegionVisibilityStrategy(this.logger));
    }

    public boolean getScrollToRegion() {
        return !(this.regionVisibilityStrategyHandler.get() instanceof NopRegionVisibilityStrategy);
    }

    public boolean shouldStitchContent() {
        return this.stitchContent;
    }

    public String getBaseAgentId() {
        return "eyes.appium.java/" + ClassVersionGetter.CURRENT_VERSION;
    }

    protected String tryCaptureDom() {
        return null;
    }

    protected RectangleSize getViewportSize() {
        ArgumentGuard.notNull((Object)((Object)this.driver), (String)"driver");
        return this.driver.getDefaultContentViewportSize();
    }

    protected Configuration setViewportSize(RectangleSize size) {
        return this.configuration;
    }

    protected String getInferredEnvironment() {
        return "";
    }

    private void initDriverBasedPositionProviders() {
        this.setPositionProvider((PositionProvider)new AppiumScrollPositionProviderFactory(this.logger, this.driver).getScrollPositionProvider());
    }

    private void initImageProvider() {
        this.imageProvider = ImageProviderFactory.getImageProvider(this.logger, this.driver, true);
    }

    private void initDriver(WebDriver driver) {
        if (driver instanceof AppiumDriver) {
            this.driver = new EyesAppiumDriver(this.logger, this, (AppiumDriver)driver);
            this.regionVisibilityStrategyHandler.set((Object)new NopRegionVisibilityStrategy(this.logger));
            this.adjustStitchOverlap(driver);
        }
    }

    private void adjustStitchOverlap(WebDriver driver) {
        if (EyesDriverUtils.isIOS((WebDriver)driver) && this.configuration.getStitchOverlap() == 50) {
            this.configuration.setStitchOverlap(0);
        }
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    protected AppEnvironment getAppEnvironment() {
        AppEnvironment appEnv = (AppEnvironment)super.getAppEnvironment();
        AppiumDriver underlyingDriver = this.driver.getRemoteWebDriver();
        if (appEnv.getOs() != null) {
            return appEnv;
        }
        String platformName = null;
        if (EyesDriverUtils.isAndroid((WebDriver)underlyingDriver)) {
            platformName = "Android";
        } else if (EyesDriverUtils.isIOS((WebDriver)underlyingDriver)) {
            platformName = "iOS";
        }
        if (platformName != null) {
            String majorVersion;
            String os = platformName;
            String platformVersion = EyesDriverUtils.getPlatformVersion((HasCapabilities)underlyingDriver);
            if (platformVersion != null && !(majorVersion = platformVersion.split("\\.", 2)[0]).isEmpty()) {
                os = os + " " + majorVersion;
            }
            appEnv.setOs(os);
        }
        if (appEnv.getDeviceInfo() == null) {
            appEnv.setDeviceInfo(EyesDriverUtils.getMobileDeviceName((HasCapabilities)underlyingDriver));
        }
        return appEnv;
    }

    public double getDevicePixelRatio() {
        return this.devicePixelRatio;
    }

    protected void tryUpdateDevicePixelRatio() {
        try {
            this.devicePixelRatio = this.driver.getDevicePixelRatio();
        }
        catch (Exception e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.GENERAL, (Throwable)e, (String[])new String[]{this.getTestId()});
            this.devicePixelRatio = 1.0;
        }
        this.logger.log(this.getTestId(), Stage.GENERAL, new Pair[]{Pair.of((Object)"devicePixelRatio", (Object)this.devicePixelRatio)});
    }

    private void updateCutElement(AppiumCheckSettings checkSettings) {
        try {
            if (checkSettings.getCutElementSelector() == null) {
                return;
            }
            this.cutElement = this.getDriver().findElement(checkSettings.getCutElementSelector());
        }
        catch (NoSuchElementException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.GENERAL, (Throwable)e, (String[])new String[]{this.getTestId()});
        }
    }

    public void check(ICheckSettings ... checkSettings) {
        boolean originalForceFPS;
        if (this.getIsDisabled()) {
            return;
        }
        boolean bl = originalForceFPS = this.getConfigurationInstance().getForceFullPageScreenshot() != null && this.getConfigurationInstance().getForceFullPageScreenshot() != false;
        if (checkSettings.length > 1) {
            this.getConfigurationInstance().setForceFullPageScreenshot(true);
        }
        Hashtable<Integer, GetSimpleRegion> getRegions = new Hashtable<Integer, GetSimpleRegion>();
        Hashtable<Integer, ICheckSettingsInternal> checkSettingsInternalDictionary = new Hashtable<Integer, ICheckSettingsInternal>();
        for (int i = 0; i < checkSettings.length; ++i) {
            WebElement targetElement;
            AppiumCheckSettings appiumCheckTarget;
            ICheckSettings settings = checkSettings[i];
            ICheckSettingsInternal checkSettingsInternal = (ICheckSettingsInternal)settings;
            ((Dictionary)checkSettingsInternalDictionary).put(i, checkSettingsInternal);
            Region targetRegion = checkSettingsInternal.getTargetRegion();
            if (targetRegion != null) {
                ((Dictionary)getRegions).put(i, (GetSimpleRegion)new SimpleRegionByRectangle(targetRegion));
                continue;
            }
            AppiumCheckSettings appiumCheckSettings = appiumCheckTarget = settings instanceof AppiumCheckSettings ? (AppiumCheckSettings)settings : null;
            if (appiumCheckTarget == null || (targetElement = this.getTargetElement(appiumCheckTarget)) == null) continue;
            ((Dictionary)getRegions).put(i, (GetSimpleRegion)new SimpleRegionByElement(targetElement));
        }
        this.matchRegions(getRegions, checkSettingsInternalDictionary, checkSettings);
        this.getConfigurationInstance().setForceFullPageScreenshot(originalForceFPS);
    }

    private void matchRegions(Dictionary<Integer, GetSimpleRegion> getRegions, Dictionary<Integer, ICheckSettingsInternal> checkSettingsInternalDictionary, ICheckSettings[] checkSettings) {
        if (getRegions.size() == 0) {
            return;
        }
        EyesAppiumScreenshot screenshot = this.getFullPageScreenshot();
        for (int i = 0; i < checkSettings.length; ++i) {
            if (!((Hashtable)getRegions).containsKey(i)) continue;
            GetSimpleRegion getRegion = getRegions.get(i);
            ICheckSettingsInternal checkSettingsInternal = checkSettingsInternalDictionary.get(i);
            List<EyesScreenshot> subScreenshots = this.getSubScreenshots(screenshot, getRegion);
            this.matchRegion(checkSettingsInternal, subScreenshots);
        }
    }

    private List<EyesScreenshot> getSubScreenshots(EyesScreenshot screenshot, GetSimpleRegion getRegion) {
        ArrayList<EyesScreenshot> subScreenshots = new ArrayList<EyesScreenshot>();
        for (Region r : getRegion.getRegions(screenshot)) {
            r = this.regionPositionCompensation.compensateRegionPosition(r, this.getDevicePixelRatio());
            EyesScreenshot subScreenshot = screenshot.getSubScreenshot(r, false);
            subScreenshots.add(subScreenshot);
        }
        return subScreenshots;
    }

    private void matchRegion(ICheckSettingsInternal checkSettingsInternal, List<EyesScreenshot> subScreenshots) {
        String name = checkSettingsInternal.getName();
        for (EyesScreenshot subScreenshot : subScreenshots) {
            this.debugScreenshotsProvider.save(subScreenshot.getImage(), String.format("subscreenshot_%s", name));
            ImageMatchSettings ims = MatchWindowTask.createImageMatchSettings((ICheckSettingsInternal)checkSettingsInternal, (EyesScreenshot)subScreenshot, (EyesBase)this);
            Location location = subScreenshot.getLocationInScreenshot(Location.ZERO, CoordinatesType.SCREENSHOT_AS_IS);
            AppOutput appOutput = new AppOutput(name, subScreenshot, null, null, location);
            MatchWindowData data = this.prepareForMatch(checkSettingsInternal, new ArrayList(), appOutput, name, false, ims, null, this.getAppName());
            this.performMatch(data);
        }
    }

    public void check(ICheckSettings checkSettings) {
        AppiumCheckSettings appiumCheckTarget;
        this.logger.log(TraceLevel.Info, Collections.singleton(this.getTestId()), Stage.CHECK, Type.CALLED, new Pair[]{Pair.of((Object)"configuration", (Object)this.getConfiguration()), Pair.of((Object)"checkSettings", (Object)checkSettings)});
        if (checkSettings instanceof AppiumCheckSettings) {
            this.updateCutElement((AppiumCheckSettings)checkSettings);
            this.scrollRootElement = this.getScrollRootElement((AppiumCheckSettings)checkSettings);
        }
        if (this.getIsDisabled()) {
            return;
        }
        ArgumentGuard.notNull((Object)checkSettings, (String)"checkSettings");
        boolean tmpCaptureStatusBar = this.configuration.isCaptureStatusBar();
        ICheckSettingsInternal checkSettingsInternal = (ICheckSettingsInternal)checkSettings;
        AppiumCheckSettings appiumCheckSettings = appiumCheckTarget = checkSettings instanceof AppiumCheckSettings ? (AppiumCheckSettings)checkSettings : null;
        if (appiumCheckTarget != null) {
            appiumCheckTarget.init(this.logger, this.driver);
            if (appiumCheckTarget.getCaptureStatusBar() != null && appiumCheckTarget.isNotRegion()) {
                this.configuration.setCaptureStatusBar(appiumCheckTarget.getCaptureStatusBar().booleanValue());
            }
            if (!appiumCheckTarget.isNotRegion()) {
                this.configuration.setCaptureStatusBar(false);
            }
        }
        String name = checkSettingsInternal.getName();
        ValidationInfo validationInfo = this.fireValidationWillStartEvent(name);
        this.stitchContent = checkSettingsInternal.getStitchContent() == null ? false : checkSettingsInternal.getStitchContent();
        Region targetRegion = checkSettingsInternal.getTargetRegion();
        MatchResult result = null;
        if (targetRegion != null) {
            Region region = new Region(targetRegion.getLocation(), targetRegion.getSize(), CoordinatesType.CONTEXT_RELATIVE);
            result = this.checkWindowBase(region, name, checkSettings);
        } else if (appiumCheckTarget != null) {
            WebElement targetElement = this.getTargetElement(appiumCheckTarget);
            if (targetElement != null) {
                this.targetElement = targetElement;
                result = this.stitchContent ? this.checkElement(targetElement, name, checkSettings) : this.checkRegion(name, checkSettings);
                this.targetElement = null;
            } else {
                result = this.checkWindowBase(null, name, checkSettings);
            }
        }
        if (result == null) {
            result = new MatchResult();
        }
        this.stitchContent = false;
        this.configuration.setCaptureStatusBar(tmpCaptureStatusBar);
        ValidationResult validationResult = new ValidationResult();
        validationResult.setAsExpected(result.getAsExpected());
        ((AppiumScrollPositionProvider)this.getPositionProvider()).cleanupCachedData();
    }

    public TestResults close(boolean throwEx) {
        TestResults results;
        block2: {
            this.logger.log(this.getTestId(), Stage.CLOSE, Type.CALLED, new Pair[]{Pair.of((Object)"throwEx", (Object)throwEx)});
            results = null;
            try {
                results = super.close(throwEx);
            }
            catch (Throwable e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.GENERAL, (Throwable)e, (String[])new String[]{this.getTestId()});
                if (!throwEx) break block2;
                throw e;
            }
        }
        return results;
    }

    protected void getAppOutputForOcr(BaseOcrRegion ocrRegion) {
        OcrRegion appiumOcrRegion = (OcrRegion)ocrRegion;
        AppiumCheckSettings checkSettings = null;
        if (appiumOcrRegion.getRegion() != null) {
            checkSettings = Target.region(appiumOcrRegion.getRegion());
        }
        if (appiumOcrRegion.getElement() != null) {
            checkSettings = Target.region(appiumOcrRegion.getElement()).fully();
        }
        if (appiumOcrRegion.getSelector() != null) {
            checkSettings = Target.region(appiumOcrRegion.getSelector()).fully();
        }
        if (checkSettings == null) {
            throw new IllegalStateException("Got uninitialized ocr region");
        }
        this.check(checkSettings.ocrRegion(ocrRegion));
    }

    protected ScreenshotProvider getScreenshotProvider() {
        return new MobileScreenshotProvider(this.driver, this.getDevicePixelRatio());
    }

    public void setMatchTimeout(int ms) {
        int MIN_MATCH_TIMEOUT = 500;
        if (this.getIsDisabled()) {
            return;
        }
        if (ms != 0 && 500 > ms) {
            throw new IllegalArgumentException("Match timeout must be set in milliseconds, and must be > 500");
        }
        this.configuration.setMatchTimeout(ms);
    }

    public int getMatchTimeout() {
        return this.configuration.getMatchTimeout();
    }

    protected EyesScreenshot getScreenshot(Region targetRegion, ICheckSettingsInternal checkSettingsInternal) {
        if (this.imageProvider instanceof MobileImageProvider) {
            ((MobileImageProvider)this.imageProvider).setCaptureStatusBar(this.configuration.isCaptureStatusBar());
        }
        EyesAppiumScreenshot result = this.getForceFullPageScreenshot() || this.stitchContent ? this.getFullPageScreenshot() : this.getSimpleScreenshot();
        if (targetRegion != null && !targetRegion.isEmpty()) {
            result = this.getSubScreenshot(result, targetRegion);
            this.debugScreenshotsProvider.save(result.getImage(), "SUB_SCREENSHOT");
        }
        return result;
    }

    protected String getTitle() {
        return "";
    }

    protected MatchResult checkElement(WebElement element, String name, ICheckSettings checkSettings) {
        Region region = this.getElementRegion(element, checkSettings);
        return this.checkWindowBase(region, name, checkSettings);
    }

    public void checkElement(WebElement element) {
        this.checkElement(element, null);
    }

    public void checkElement(WebElement element, String tag) {
        this.checkElement(element, -1, tag);
    }

    public void checkElement(WebElement element, int matchTimeout, String tag) {
        this.check(tag, Target.region(element).timeout(matchTimeout).fully());
    }

    public void checkElement(By selector) {
        this.checkElement(selector, -1, null);
    }

    public void checkElement(By selector, String tag) {
        this.checkElement(selector, -1, tag);
    }

    public void checkElement(By selector, int matchTimeout, String tag) {
        this.check(tag, Target.region(selector).timeout(matchTimeout).fully());
    }

    private WebElement getTargetElement(AppiumCheckSettings seleniumCheckTarget) {
        assert (seleniumCheckTarget != null);
        By targetSelector = seleniumCheckTarget.getTargetSelector();
        Object targetElement = seleniumCheckTarget.getTargetElement();
        if (targetElement == null && targetSelector != null) {
            targetElement = this.driver.findElement(targetSelector);
        }
        if (targetElement != null && !(targetElement instanceof EyesAppiumElement)) {
            targetElement = new EyesAppiumElement(this.driver, (WebElement)targetElement, 1.0 / this.devicePixelRatio);
        }
        return targetElement;
    }

    private ScaleProviderFactory updateScalingParams() {
        if (this.scaleProviderHandler.get() instanceof NullScaleProvider) {
            FixedScaleProviderFactory factory = new FixedScaleProviderFactory(this.logger, 1.0 / this.getDevicePixelRatio(), this.scaleProviderHandler);
            return factory;
        }
        SimplePropertyHandler nullProvider = new SimplePropertyHandler();
        return new ScaleProviderIdentityFactory(this.logger, (ScaleProvider)this.scaleProviderHandler.get(), (PropertyHandler)nullProvider);
    }

    public void setSaveNewTests(boolean saveNewTests) {
        this.configuration.setSaveNewTests(saveNewTests);
    }

    public boolean getSaveNewTests() {
        return this.configuration.getSaveNewTests();
    }

    public void setSaveDiffs(Boolean saveDiffs) {
        this.configuration.setSaveDiffs(saveDiffs);
    }

    public Boolean getSaveDiffs() {
        return this.configuration.getSaveDiffs();
    }

    public void setDefaultMatchSettings(ImageMatchSettings defaultMatchSettings) {
        this.configuration.setDefaultMatchSettings(defaultMatchSettings);
    }

    public ImageMatchSettings getDefaultMatchSettings() {
        return this.configuration.getDefaultMatchSettings();
    }

    public int getStitchOverlap() {
        return this.configuration.getStitchOverlap();
    }

    public void setStitchOverlap(int pixels) {
        this.configuration.setStitchOverlap(pixels);
    }

    protected EyesAppiumScreenshot getFullPageScreenshot() {
        EyesAppiumScreenshotFactory screenshotFactory = new EyesAppiumScreenshotFactory(this.logger, this.driver);
        ScaleProviderFactory scaleProviderFactory = this.updateScalingParams();
        AppiumScrollPositionProvider scrollPositionProvider = (AppiumScrollPositionProvider)this.getPositionProvider();
        AppiumCaptureAlgorithmFactory algoFactory = new AppiumCaptureAlgorithmFactory(this.driver, this.logger, this.getTestId(), scrollPositionProvider, this.imageProvider, this.debugScreenshotsProvider, scaleProviderFactory, (CutProvider)this.cutProviderHandler.get(), screenshotFactory, this.getConfigurationInstance().getWaitBeforeScreenshots(), this.cutElement, this.getStitchOverlap(), this.scrollRootElement, this.scrollRootElementSelector, this.configuration.getContentInset(), this.configuration.isCacheScrollableSize());
        AppiumFullPageCaptureAlgorithm algo = algoFactory.getAlgorithm();
        BufferedImage fullPageImage = algo.getStitchedRegion(Region.EMPTY, this.regionPositionCompensation);
        return new EyesAppiumScreenshot(this.logger, this.driver, fullPageImage);
    }

    protected EyesAppiumScreenshot getSimpleScreenshot() {
        CutProvider cutProvider;
        ScaleProviderFactory scaleProviderFactory = this.updateScalingParams();
        BufferedImage screenshotImage = this.imageProvider.getImage();
        this.debugScreenshotsProvider.save(screenshotImage, "original");
        ScaleProvider scaleProvider = scaleProviderFactory.getScaleProvider(screenshotImage.getWidth());
        if (scaleProvider.getScaleRatio() != 1.0) {
            screenshotImage = ImageUtils.scaleImage((BufferedImage)screenshotImage, (double)scaleProvider.getScaleRatio(), (boolean)true);
            this.debugScreenshotsProvider.save(screenshotImage, "scaled");
        }
        if (!((cutProvider = (CutProvider)this.cutProviderHandler.get()) instanceof NullCutProvider)) {
            screenshotImage = cutProvider.cut(screenshotImage);
            this.debugScreenshotsProvider.save(screenshotImage, "cut");
        }
        return new EyesAppiumScreenshot(this.logger, this.driver, screenshotImage);
    }

    protected MatchResult checkRegion(String name, ICheckSettings checkSettings) {
        Point p = this.targetElement.getLocation();
        Dimension d = this.targetElement.getSize();
        Region region = new Region(p.getX(), p.getY(), d.getWidth(), d.getHeight(), CoordinatesType.CONTEXT_RELATIVE);
        return this.checkWindowBase(region, name, checkSettings);
    }

    public void checkRegion(Region region) {
        this.checkRegion(region, -1, null);
    }

    public void checkRegion(Region region, int matchTimeout, String tag) throws TestFailedException {
        if (this.getIsDisabled()) {
            return;
        }
        ArgumentGuard.notNull((Object)region, (String)"region");
        this.check(Target.region(region).timeout(matchTimeout).withName(tag));
    }

    public void checkRegion(WebElement element) {
        this.checkRegion(element, -1, null, true);
    }

    public void checkRegion(WebElement element, String tag, boolean stitchContent) {
        this.checkRegion(element, -1, tag, stitchContent);
    }

    public void checkRegion(WebElement element, int matchTimeout, String tag) {
        this.checkRegion(element, matchTimeout, tag, true);
    }

    public void checkRegion(WebElement element, int matchTimeout, String tag, boolean stitchContent) {
        if (this.getIsDisabled()) {
            return;
        }
        ArgumentGuard.notNull((Object)element, (String)"element");
        this.check(Target.region(element).timeout(matchTimeout).withName(tag).fully(Boolean.valueOf(stitchContent)));
    }

    public void checkRegion(By selector) {
        this.checkRegion(selector, -1, null, false);
    }

    public void checkRegion(By selector, boolean stitchContent) {
        this.checkRegion(selector, -1, null, stitchContent);
    }

    public void checkRegion(By selector, String tag) {
        this.checkRegion(selector, -1, tag, true);
    }

    public void checkRegion(By selector, String tag, boolean stitchContent) {
        this.checkRegion(selector, -1, tag, stitchContent);
    }

    public void checkRegion(By selector, int matchTimeout, String tag) {
        this.checkRegion(selector, matchTimeout, tag, true);
    }

    public void checkRegion(By selector, int matchTimeout, String tag, boolean stitchContent) {
        this.check(tag, Target.region(selector).timeout(matchTimeout).fully(Boolean.valueOf(stitchContent)));
    }

    private EyesScreenshot getSubScreenshot(EyesScreenshot screenshot, Region region) {
        ArgumentGuard.notNull((Object)region, (String)"region");
        if ((EyesDriverUtils.isAndroid((WebDriver)this.driver) || EyesDriverUtils.isIOS((WebDriver)this.driver)) && region.getCoordinatesType() != CoordinatesType.CONTEXT_RELATIVE) {
            BufferedImage image = screenshot.getImage();
            if (image.getWidth() < this.driver.getViewportRect().get("width")) {
                image = ImageUtils.scaleImage((BufferedImage)image, (double)this.driver.getDevicePixelRatio(), (boolean)true);
            }
            BufferedImage subScreenshotImage = ImageUtils.scaleImage((BufferedImage)ImageUtils.getImagePart((BufferedImage)image, (Region)region), (double)(1.0 / this.driver.getDevicePixelRatio()), (boolean)true);
            EyesAppiumScreenshot result = new EyesAppiumScreenshot(this.logger, this.driver, subScreenshotImage);
            return result;
        }
        return screenshot.getSubScreenshot(region, false);
    }

    private void initVisualLocatorProvider() {
        if (EyesDriverUtils.isAndroid((WebDriver)this.driver)) {
            this.visualLocatorsProvider = new AndroidVisualLocatorProvider(this.logger, this.getTestId(), this.driver, this.getServerConnector(), this.getDevicePixelRatio(), this.configuration.getAppName(), this.debugScreenshotsProvider);
        } else if (EyesDriverUtils.isIOS((WebDriver)this.driver)) {
            this.visualLocatorsProvider = new IOSVisualLocatorProvider(this.logger, this.getTestId(), this.driver, this.getServerConnector(), this.getDevicePixelRatio(), this.configuration.getAppName(), this.debugScreenshotsProvider);
        } else {
            throw new Error("Could not find driver type for getting visual locator provider");
        }
    }

    public Map<String, List<Region>> locate(VisualLocatorSettings visualLocatorSettings) {
        ArgumentGuard.notNull((Object)visualLocatorSettings, (String)"visualLocatorSettings");
        return this.visualLocatorsProvider.getLocators(visualLocatorSettings);
    }

    private Region getElementRegion(WebElement element, ICheckSettings checkSettings) {
        Boolean statusBarExists = null;
        if (checkSettings instanceof AppiumCheckSettings) {
            statusBarExists = ((AppiumCheckSettings)checkSettings).getStatusBarExists();
        }
        return ((AppiumScrollPositionProvider)this.getPositionProvider()).getElementRegion(element, this.shouldStitchContent(), statusBarExists);
    }

    public com.applitools.eyes.selenium.Configuration getConfiguration() {
        return new com.applitools.eyes.selenium.Configuration(this.configuration);
    }

    public void setBranchName(String branchName) {
        this.configuration.setBranchName(branchName);
    }

    public String getBranchName() {
        return this.configuration.getBranchName();
    }

    public void setParentBranchName(String branchName) {
        this.configuration.setParentBranchName(branchName);
    }

    public String getParentBranchName() {
        return this.configuration.getParentBranchName();
    }

    public Configuration setBatch(BatchInfo batch) {
        return this.configuration.setBatch(batch);
    }

    protected Configuration getConfigurationInstance() {
        return this.configuration;
    }

    public BatchInfo getBatch() {
        return this.configuration.getBatch();
    }

    public void setAgentId(String agentId) {
        this.configuration.setAgentId(agentId);
    }

    public String getAgentId() {
        return this.configuration.getAgentId();
    }

    public void setHostOS(String hostOS) {
        this.configuration.setHostOS(hostOS);
    }

    public String getHostOS() {
        return this.configuration.getHostOS();
    }

    public void setHostApp(String hostApp) {
        this.configuration.setHostApp(hostApp);
    }

    public String getHostApp() {
        return this.configuration.getHostOS();
    }

    public boolean getIgnoreCaret() {
        return this.configuration.getIgnoreCaret();
    }

    public void setIgnoreCaret(boolean value) {
        this.configuration.setIgnoreCaret(value);
    }

    public void setMatchLevel(MatchLevel matchLevel) {
        this.configuration.getDefaultMatchSettings().setMatchLevel(matchLevel);
    }

    public MatchLevel getMatchLevel() {
        return this.configuration.getDefaultMatchSettings().getMatchLevel();
    }

    public void setEnvName(String envName) {
        this.configuration.setEnvironmentName(envName);
    }

    public String getEnvName() {
        return this.configuration.getEnvironmentName();
    }

    public void setBaselineEnvName(String baselineEnvName) {
        this.configuration.setBaselineEnvName(baselineEnvName);
    }

    public String getBaselineEnvName() {
        return this.configuration.getBaselineEnvName();
    }

    public void setBaselineBranchName(String branchName) {
        this.configuration.setBaselineBranchName(branchName);
    }

    public String getBaselineBranchName() {
        return this.configuration.getBaselineBranchName();
    }

    public void setIgnoreDisplacements(boolean isIgnoreDisplacements) {
        this.configuration.setIgnoreDisplacements(isIgnoreDisplacements);
    }

    public boolean getIgnoreDisplacements() {
        return this.configuration.getIgnoreDisplacements();
    }

    public void setConfiguration(Configuration configuration) {
        AbstractProxySettings proxy;
        URI serverUrl;
        ArgumentGuard.notNull((Object)configuration, (String)"configuration");
        String apiKey = configuration.getApiKey();
        if (apiKey != null) {
            this.setApiKey(apiKey);
        }
        if ((serverUrl = configuration.getServerUrl()) != null) {
            this.setServerUrl(serverUrl.toString());
        }
        if ((proxy = configuration.getProxy()) != null) {
            this.setProxy(proxy);
        }
        this.configuration = new Configuration(configuration);
    }

    public Object getAgentSetup() {
        return new EyesAppiumAgentSetup();
    }

    private WebElement getScrollRootElement(AppiumCheckSettings checkSettings) {
        this.scrollRootElement = checkSettings.getScrollRootElement();
        if (this.scrollRootElement == null) {
            if (checkSettings.getScrollRootElementSelector() != null) {
                this.scrollRootElementSelector = checkSettings.getScrollRootElementSelector();
                this.scrollRootElement = this.driver.findElement(checkSettings.getScrollRootElementSelector());
            }
            if (this.scrollRootElement == null && checkSettings.getScrollRootElementId() != null) {
                this.scrollRootElement = this.driver.findElement(MobileBy.id((String)checkSettings.getScrollRootElementId()));
            }
        }
        return this.scrollRootElement;
    }

    class EyesAppiumAgentSetup {
        private RemoteWebDriver remoteWebDriver;

        public EyesAppiumAgentSetup() {
            this.remoteWebDriver = Eyes.this.driver.getRemoteWebDriver();
        }

        public String getAppiumSessionId() {
            return this.remoteWebDriver.getSessionId().toString();
        }

        public WebDriverInfo getWebDriver() {
            return new WebDriverInfo();
        }

        public double getDevicePixelRatio() {
            return Eyes.this.getDevicePixelRatio();
        }

        public String getCutProvider() {
            return ((CutProvider)Eyes.this.cutProviderHandler.get()).getClass().getName();
        }

        public String getScaleProvider() {
            return ((ScaleProvider)Eyes.this.scaleProviderHandler.get()).getClass().getName();
        }

        public StitchMode getStitchMode() {
            return Eyes.this.getConfigurationInstance().getStitchMode();
        }

        public boolean getHideScrollbars() {
            return Eyes.this.getConfigurationInstance().getHideScrollbars();
        }

        public boolean getForceFullPageScreenshot() {
            Boolean forceFullPageScreenshot = Eyes.this.getConfigurationInstance().getForceFullPageScreenshot();
            if (forceFullPageScreenshot == null) {
                return false;
            }
            return forceFullPageScreenshot;
        }

        public String getHelperLibraryVersion() {
            return EyesAppiumUtils.getHelperLibraryVersion(Eyes.this.driver, Eyes.this.logger);
        }

        class WebDriverInfo {
            WebDriverInfo() {
            }

            public String getName() {
                return EyesAppiumAgentSetup.this.remoteWebDriver.getClass().getName();
            }

            public Capabilities getCapabilities() {
                return EyesAppiumAgentSetup.this.remoteWebDriver.getCapabilities();
            }
        }
    }
}

