/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.appium;

import com.applitools.eyes.Logger;
import com.applitools.eyes.appium.AndroidScrollPositionProvider;
import com.applitools.eyes.appium.AppiumScrollPositionProvider;
import com.applitools.eyes.appium.EyesAppiumDriver;
import com.applitools.eyes.appium.IOSScrollPositionProvider;
import com.applitools.eyes.selenium.EyesDriverUtils;
import org.openqa.selenium.WebDriver;

public class AppiumScrollPositionProviderFactory {
    private final Logger logger;
    private final EyesAppiumDriver driver;

    public AppiumScrollPositionProviderFactory(Logger logger, EyesAppiumDriver driver) {
        this.logger = logger;
        this.driver = driver;
    }

    public AppiumScrollPositionProvider getScrollPositionProvider() {
        if (EyesDriverUtils.isAndroid((WebDriver)this.driver.getRemoteWebDriver())) {
            return new AndroidScrollPositionProvider(this.logger, this.driver);
        }
        if (EyesDriverUtils.isIOS((WebDriver)this.driver.getRemoteWebDriver())) {
            return new IOSScrollPositionProvider(this.logger, this.driver);
        }
        throw new Error("Could not find driver type to get scroll position provider");
    }
}

