/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.appium;

import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.appium.ContentSize;
import com.applitools.eyes.appium.EyesAppiumDriver;
import com.applitools.eyes.appium.EyesAppiumUtils;
import com.applitools.eyes.config.ContentInset;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.TraceLevel;
import com.applitools.eyes.positioning.PositionMemento;
import com.applitools.eyes.selenium.positioning.ScrollPositionMemento;
import com.applitools.eyes.selenium.positioning.ScrollPositionProvider;
import com.applitools.utils.ArgumentGuard;
import com.applitools.utils.GeneralUtils;
import io.appium.java_client.AppiumDriver;
import org.apache.commons.lang3.tuple.Pair;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public abstract class AppiumScrollPositionProvider
implements ScrollPositionProvider {
    protected final Logger logger;
    protected final AppiumDriver driver;
    protected final EyesAppiumDriver eyesDriver;
    protected double distanceRatio;
    protected int verticalScrollGap;
    protected WebElement cutElement = null;
    protected WebElement scrollRootElement = null;
    protected By scrollRootElementSelector = null;
    protected ContentInset contentInset = new ContentInset();
    protected boolean cacheScrollableSize = true;
    protected ContentSize contentSize;
    protected WebElement cachedScrollableView = null;
    protected Location cachedScrollableViewLocation = null;
    protected Region cachedScrollableViewRegion = null;
    private WebElement firstVisibleChild;
    private boolean isVerticalScrollGapSet;

    public AppiumScrollPositionProvider(Logger logger, EyesAppiumDriver driver) {
        ArgumentGuard.notNull((Object)logger, (String)"logger");
        ArgumentGuard.notNull((Object)((Object)driver), (String)"driver");
        this.logger = logger;
        this.driver = driver.getRemoteWebDriver();
        this.eyesDriver = driver;
        this.distanceRatio = 0.0;
        this.verticalScrollGap = 0;
        this.isVerticalScrollGapSet = false;
    }

    public void setCutElement(WebElement cutElement) {
        this.cutElement = cutElement;
    }

    protected WebElement getCachedFirstVisibleChild() {
        WebElement activeScroll = this.getFirstScrollableView();
        if (this.firstVisibleChild == null) {
            this.firstVisibleChild = EyesAppiumUtils.getFirstVisibleChild(activeScroll);
        } else {
            Rectangle firstVisibleChildRect = this.firstVisibleChild.getRect();
            if (firstVisibleChildRect.getWidth() == 0 && firstVisibleChildRect.getHeight() == 0) {
                this.firstVisibleChild = EyesAppiumUtils.getFirstVisibleChild(activeScroll);
            }
        }
        return this.firstVisibleChild;
    }

    protected ContentSize getCachedContentSize() {
        if (this.contentSize != null) {
            return this.contentSize;
        }
        try {
            WebElement activeScroll = this.getFirstScrollableView();
            this.contentSize = EyesAppiumUtils.getContentSize(this.driver, activeScroll);
            this.logger.log(TraceLevel.Debug, this.eyesDriver.getTestId(), Stage.CHECK, new Pair[]{Pair.of((Object)"contentSize", (Object)this.contentSize)});
        }
        catch (NoSuchElementException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Throwable)e, (String[])new String[0]);
        }
        return this.contentSize;
    }

    public Location getScrollableViewLocation() {
        WebElement firstVisChild;
        WebElement activeScroll;
        if (this.cacheScrollableSize && this.cachedScrollableViewLocation != null) {
            return this.cachedScrollableViewLocation;
        }
        try {
            activeScroll = this.getFirstScrollableView();
            firstVisChild = this.getCachedFirstVisibleChild();
        }
        catch (NoSuchElementException e) {
            return new Location(0, 0);
        }
        Point scrollLoc = activeScroll.getLocation();
        Point firstVisChildLoc = firstVisChild.getLocation();
        if (!this.isVerticalScrollGapSet) {
            this.verticalScrollGap = firstVisChildLoc.y - scrollLoc.y;
            this.isVerticalScrollGapSet = true;
        }
        this.cachedScrollableViewLocation = new Location(scrollLoc.x, scrollLoc.y + this.verticalScrollGap);
        this.logger.log(TraceLevel.Debug, this.eyesDriver.getTestId(), Stage.CHECK, new Pair[]{Pair.of((Object)"location", (Object)this.cachedScrollableViewLocation), Pair.of((Object)"verticalScrollGap", (Object)this.verticalScrollGap)});
        return this.cachedScrollableViewLocation;
    }

    public Region getScrollableViewRegion() {
        if (this.cacheScrollableSize && this.cachedScrollableViewRegion != null) {
            return this.cachedScrollableViewRegion;
        }
        try {
            WebElement activeScroll = this.getFirstScrollableView();
            Location scrollLoc = this.getScrollableViewLocation();
            Dimension scrollDim = activeScroll.getSize();
            this.cachedScrollableViewRegion = new Region(scrollLoc.getX(), scrollLoc.getY(), scrollDim.width, scrollDim.height - this.verticalScrollGap);
        }
        catch (NoSuchElementException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Throwable)e, (String[])new String[0]);
            this.cachedScrollableViewRegion = new Region(0, 0, 0, 0);
        }
        this.logger.log(TraceLevel.Debug, this.eyesDriver.getTestId(), Stage.CHECK, new Pair[]{Pair.of((Object)"region", (Object)this.cachedScrollableViewRegion), Pair.of((Object)"verticalScrollGap", (Object)this.verticalScrollGap)});
        return this.cachedScrollableViewRegion;
    }

    public Location getFirstVisibleChildLocation() {
        WebElement childElement;
        try {
            childElement = this.getCachedFirstVisibleChild();
        }
        catch (NoSuchElementException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.GENERAL, (Throwable)e, (String[])new String[0]);
            return new Location(0, 0);
        }
        Point childLoc = childElement.getLocation();
        return new Location(childLoc.getX(), childLoc.getY());
    }

    public Location getCurrentPosition(boolean absolute) {
        Location loc = this.getScrollableViewLocation();
        Location childLoc = this.getFirstVisibleChildLocation();
        Location pos = absolute ? new Location(loc.getX() * 2 - childLoc.getX(), loc.getY() * 2 - childLoc.getY()) : new Location(loc.getX() - childLoc.getX(), loc.getY() - childLoc.getY());
        this.logger.log(TraceLevel.Debug, this.eyesDriver.getTestId(), Stage.CHECK, new Pair[]{Pair.of((Object)"currentPosition", (Object)pos)});
        return pos;
    }

    public Location getCurrentPositionWithoutStatusBar(boolean absolute) {
        Location loc = this.getScrollableViewLocation();
        Location childLoc = this.getFirstVisibleChildLocation();
        Location pos = absolute ? new Location(loc.getX() * 2 - childLoc.getX(), loc.getY() * 2 - this.getStatusBarHeight() - childLoc.getY()) : new Location(loc.getX() - childLoc.getX(), loc.getY() - this.getStatusBarHeight() - childLoc.getY());
        this.logger.log(TraceLevel.Debug, this.eyesDriver.getTestId(), Stage.CHECK, new Pair[]{Pair.of((Object)"currentPosition", (Object)pos)});
        return pos;
    }

    public Location getCurrentPosition() {
        return this.getCurrentPosition(false);
    }

    public RectangleSize getEntireSize() {
        int windowHeight = this.driver.manage().window().getSize().getHeight() - this.getStatusBarHeight();
        ContentSize contentSize = this.getCachedContentSize();
        if (contentSize == null) {
            return this.eyesDriver.getDefaultContentViewportSize();
        }
        int scrollContentHeight = contentSize.getScrollContentHeight();
        int outsideScrollViewHeight = windowHeight - contentSize.height;
        return new RectangleSize(contentSize.width, scrollContentHeight + outsideScrollViewHeight + this.verticalScrollGap + this.contentInset.getBottom() / 2);
    }

    public PositionMemento getState() {
        return new ScrollPositionMemento(this.getCurrentPosition());
    }

    public abstract void restoreState(PositionMemento var1);

    public void scrollToBottomRight() {
        this.setPosition(new Location(9999999, 9999999));
    }

    public abstract void scrollTo(int var1, int var2, int var3, int var4, boolean var5);

    int getStatusBarHeight() {
        return this.eyesDriver.getStatusBarHeight();
    }

    public abstract Region getElementRegion(WebElement var1, boolean var2, Boolean var3);

    protected WebElement getFirstScrollableView() {
        if (!this.cacheScrollableSize && this.scrollRootElementSelector != null) {
            this.cachedScrollableView = this.driver.findElement(this.scrollRootElementSelector);
        }
        if (this.cachedScrollableView == null) {
            this.cachedScrollableView = EyesAppiumUtils.getFirstScrollableView((WebDriver)this.driver);
        }
        return this.cachedScrollableView;
    }

    public void cleanupCachedData() {
        this.contentSize = null;
        this.firstVisibleChild = null;
        this.cachedScrollableView = null;
        this.cachedScrollableViewLocation = null;
        this.cachedScrollableViewRegion = null;
        this.isVerticalScrollGapSet = false;
    }

    public void setScrollRootElement(WebElement scrollRootElement) {
        this.scrollRootElement = scrollRootElement;
    }

    public void setScrollRootElementSelector(By scrollRootElementSelector) {
        this.scrollRootElementSelector = scrollRootElementSelector;
    }

    public void setContentInset(ContentInset contentInset) {
        this.contentInset = contentInset;
    }

    public void setCacheScrollableSize(boolean cacheScrollableSize) {
        this.cacheScrollableSize = cacheScrollableSize;
    }

    public int getCachedFirstVisibleChildHeight() {
        return 0;
    }
}

