/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.appium;

import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.appium.AppiumScrollPositionProvider;
import com.applitools.eyes.appium.ContentSize;
import com.applitools.eyes.appium.EyesAppiumDriver;
import com.applitools.eyes.appium.EyesAppiumElement;
import com.applitools.eyes.appium.EyesAppiumUtils;
import com.applitools.eyes.appium.LastScrollData;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.TraceLevel;
import com.applitools.eyes.positioning.PositionMemento;
import com.applitools.utils.GeneralUtils;
import io.appium.java_client.MobileBy;
import io.appium.java_client.MobileElement;
import io.appium.java_client.PerformsTouchActions;
import io.appium.java_client.TouchAction;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.touch.WaitOptions;
import io.appium.java_client.touch.offset.PointOption;
import java.time.Duration;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.Point;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebElement;

public class AndroidScrollPositionProvider
extends AppiumScrollPositionProvider {
    private Location curScrollPos;
    private Location scrollableViewLoc;
    private RectangleSize entireSize = null;

    public AndroidScrollPositionProvider(Logger logger, EyesAppiumDriver driver) {
        super(logger, driver);
    }

    @Override
    public Location getScrollableViewLocation() {
        if (this.scrollableViewLoc == null) {
            WebElement activeScroll;
            try {
                activeScroll = this.getFirstScrollableView();
            }
            catch (NoSuchElementException e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Throwable)e, (String[])new String[0]);
                return new Location(0, 0);
            }
            Point scrollLoc = activeScroll.getLocation();
            this.scrollableViewLoc = new Location(scrollLoc.x, scrollLoc.y);
        }
        this.logger.log(TraceLevel.Debug, this.eyesDriver.getTestId(), Stage.CHECK, new Pair[]{Pair.of((Object)"location", (Object)this.scrollableViewLoc)});
        return this.scrollableViewLoc;
    }

    @Override
    public Region getScrollableViewRegion() {
        Region reg;
        try {
            WebElement activeScroll = this.getFirstScrollableView();
            Location scrollLoc = this.getScrollableViewLocation();
            Dimension scrollDim = activeScroll.getSize();
            reg = new Region(scrollLoc.getX(), scrollLoc.getY(), scrollDim.width, scrollDim.height - this.verticalScrollGap);
        }
        catch (NoSuchElementException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Throwable)e, (String[])new String[0]);
            reg = new Region(0, 0, 0, 0);
        }
        this.logger.log(TraceLevel.Debug, this.eyesDriver.getTestId(), Stage.CHECK, new Pair[]{Pair.of((Object)"region", (Object)reg), Pair.of((Object)"verticalScrollGap", (Object)this.verticalScrollGap)});
        return reg;
    }

    private void checkCurrentScrollPosition() {
        if (this.curScrollPos == null) {
            ContentSize contentSize = this.getCachedContentSize();
            LastScrollData scrollData = EyesAppiumUtils.getLastScrollData(this.driver);
            this.curScrollPos = this.getScrollPosFromScrollData(contentSize, scrollData, 0, false);
        }
    }

    @Override
    public Location getCurrentPosition(boolean absolute) {
        Location loc = this.getScrollableViewLocation();
        this.checkCurrentScrollPosition();
        Location pos = absolute ? new Location(loc.getX() + this.curScrollPos.getX(), loc.getY() + this.curScrollPos.getY()) : new Location(this.curScrollPos.getX(), this.curScrollPos.getY());
        this.logger.log(TraceLevel.Debug, this.eyesDriver.getTestId(), Stage.CHECK, new Pair[]{Pair.of((Object)"currentPosition", (Object)pos)});
        return pos;
    }

    @Override
    public Location getCurrentPositionWithoutStatusBar(boolean absolute) {
        Location loc = this.getScrollableViewLocation();
        this.checkCurrentScrollPosition();
        Location pos = absolute ? new Location(loc.getX() + this.curScrollPos.getX(), loc.getY() - this.getStatusBarHeight() + this.curScrollPos.getY()) : new Location(this.curScrollPos.getX(), this.curScrollPos.getY() - this.getStatusBarHeight());
        this.logger.log(TraceLevel.Debug, this.eyesDriver.getTestId(), Stage.CHECK, new Pair[]{Pair.of((Object)"currentPosition", (Object)pos)});
        return pos;
    }

    public Location setPosition(Location location) {
        if (location.getY() == this.curScrollPos.getY() && location.getX() == this.curScrollPos.getX()) {
            return this.curScrollPos;
        }
        Location lastScrollPos = this.curScrollPos;
        while (this.curScrollPos.getY() > 0) {
            this.scroll(false);
            if (lastScrollPos.getY() == this.curScrollPos.getY()) break;
            lastScrollPos = this.curScrollPos;
        }
        this.scroll(false);
        this.entireSize = null;
        return lastScrollPos;
    }

    public void setPosition(WebElement element) {
        try {
            WebElement activeScroll = this.getFirstScrollableView();
            EyesAppiumUtils.scrollBackToElement((AndroidDriver)this.driver, (RemoteWebElement)activeScroll, (RemoteWebElement)element);
            LastScrollData lastScrollData = EyesAppiumUtils.getLastScrollData(this.driver);
            this.curScrollPos = new Location(lastScrollData.scrollX, lastScrollData.scrollY);
        }
        catch (NoSuchElementException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Throwable)e, (String[])new String[0]);
        }
    }

    @Override
    public void restoreState(PositionMemento state) {
        this.setPosition(new Location(state.getX(), state.getY()));
    }

    private void scroll(boolean isDown) {
        ContentSize contentSize = this.getCachedContentSize();
        int extraPadding = (int)((double)contentSize.height * 0.1);
        int startX = contentSize.left + contentSize.width / 2;
        int startY = contentSize.top + contentSize.height - contentSize.touchPadding - extraPadding;
        int endX = startX;
        int endY = contentSize.top + contentSize.touchPadding + extraPadding;
        if (!isDown) {
            int temp = endY;
            endY = startY;
            startY = temp;
        }
        int supposedScrollAmt = startY - endY;
        TouchAction scrollAction = new TouchAction((PerformsTouchActions)this.driver);
        scrollAction.press(new PointOption().withCoordinates(startX, startY)).waitAction(new WaitOptions().withDuration(Duration.ofMillis(1500L)));
        scrollAction.moveTo(new PointOption().withCoordinates(endX, endY));
        scrollAction.release();
        this.driver.performTouchAction(scrollAction);
        try {
            Thread.sleep(750L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LastScrollData lastScrollData = EyesAppiumUtils.getLastScrollData(this.driver);
        this.curScrollPos = this.getScrollPosFromScrollData(contentSize, lastScrollData, supposedScrollAmt, isDown);
    }

    public Location scrollDown(boolean returnAbsoluteLocation) {
        this.scroll(true);
        return this.getCurrentPositionWithoutStatusBar(returnAbsoluteLocation);
    }

    @Override
    public void scrollTo(int startX, int startY, int endX, int endY, boolean shouldCancel) {
        this.logger.log(TraceLevel.Debug, this.eyesDriver.getTestId(), Stage.CHECK, new Pair[]{Pair.of((Object)"from", (Object)new Location(startX, startY)), Pair.of((Object)"to", (Object)new Location(startX, startY))});
        TouchAction scrollAction = new TouchAction((PerformsTouchActions)this.driver);
        scrollAction.press(new PointOption().withCoordinates(startX, startY)).waitAction(new WaitOptions().withDuration(Duration.ofMillis(1500L)));
        scrollAction.moveTo(new PointOption().withCoordinates(endX, Math.max(endY - this.contentSize.touchPadding, 0)));
        if (shouldCancel) {
            scrollAction.cancel();
        } else {
            scrollAction.release();
        }
        this.driver.performTouchAction(scrollAction);
        this.curScrollPos = new Location(this.curScrollPos.getX(), this.curScrollPos.getY() + startX);
        try {
            Thread.sleep(750L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean tryScrollWithHelperLibrary(String elementId, int offset, int step, int totalSteps) {
        boolean scrolled;
        block4: {
            scrolled = false;
            try {
                MobileElement hiddenElement = (MobileElement)((AndroidDriver)this.driver).findElement(MobileBy.AndroidUIAutomator((String)"new UiSelector().description(\"EyesAppiumHelperEDT\")"));
                if (hiddenElement == null) break block4;
                hiddenElement.setValue("scroll;" + elementId + ";" + offset + ";" + step + ";" + totalSteps);
                hiddenElement.click();
                scrolled = true;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                hiddenElement.clear();
            }
            catch (NoSuchElementException | StaleElementReferenceException e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Throwable)e, (String[])new String[0]);
            }
        }
        return scrolled;
    }

    public boolean moveToTop(String elementId) {
        boolean scrolled;
        block4: {
            scrolled = false;
            try {
                MobileElement hiddenElement = (MobileElement)((AndroidDriver)this.driver).findElement(MobileBy.AndroidUIAutomator((String)"new UiSelector().description(\"EyesAppiumHelperEDT\")"));
                if (hiddenElement == null) break block4;
                hiddenElement.setValue("moveToTop;" + elementId + ";0;-1");
                hiddenElement.click();
                scrolled = true;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                hiddenElement.clear();
            }
            catch (NoSuchElementException | StaleElementReferenceException e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Throwable)e, (String[])new String[0]);
            }
        }
        return scrolled;
    }

    public int getBehaviorOffsetWithHelperLibrary() {
        int offset = -1;
        if (this.scrollRootElement == null) {
            return offset;
        }
        String elementId = this.scrollRootElement.getAttribute("resourceId").split("/")[1];
        try {
            MobileElement hiddenElement = (MobileElement)((AndroidDriver)this.driver).findElement(MobileBy.AndroidUIAutomator((String)"new UiSelector().description(\"EyesAppiumHelperEDT\")"));
            if (hiddenElement != null) {
                hiddenElement.setValue("behaviorOffset;" + elementId + ";0;0");
                hiddenElement.click();
                offset = Integer.parseInt(hiddenElement.getText());
                hiddenElement.clear();
            }
        }
        catch (NumberFormatException | NoSuchElementException | StaleElementReferenceException e) {
            GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Throwable)e, (String[])new String[0]);
        }
        return offset;
    }

    public boolean tryScrollBehaviorOffsetWithHelperLibrary(String elementId, int offset) {
        boolean scrolled;
        block4: {
            scrolled = false;
            try {
                MobileElement hiddenElement = (MobileElement)((AndroidDriver)this.driver).findElement(MobileBy.AndroidUIAutomator((String)"new UiSelector().description(\"EyesAppiumHelperEDT\")"));
                if (hiddenElement == null) break block4;
                hiddenElement.setValue("behaviorScroll;" + elementId + ";" + offset + ";0");
                hiddenElement.click();
                scrolled = true;
                try {
                    Thread.sleep(1500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                hiddenElement.clear();
            }
            catch (NumberFormatException | NoSuchElementException | StaleElementReferenceException e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Throwable)e, (String[])new String[0]);
            }
        }
        return scrolled;
    }

    public String tryGetClassWithHelperLibrary() {
        String className = null;
        if (this.scrollRootElement != null) {
            String elementId = this.scrollRootElement.getAttribute("resourceId").split("/")[1];
            try {
                MobileElement hiddenElement = (MobileElement)((AndroidDriver)this.driver).findElement(MobileBy.AndroidUIAutomator((String)"new UiSelector().description(\"EyesAppiumHelperEDT\")"));
                if (hiddenElement != null) {
                    hiddenElement.setValue("className;" + elementId + ";0;0");
                    hiddenElement.click();
                    className = hiddenElement.getText();
                    if (className.isEmpty()) {
                        className = null;
                    }
                    hiddenElement.clear();
                }
            }
            catch (Exception e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Throwable)e, (String[])new String[0]);
            }
        }
        return className;
    }

    public void tryDumpVHSWithHelperLibrary() {
        block4: {
            try {
                MobileElement hiddenElement = (MobileElement)((AndroidDriver)this.driver).findElement(MobileBy.AndroidUIAutomator((String)"new UiSelector().description(\"EyesAppiumHelperEDT\")"));
                if (hiddenElement == null) break block4;
                hiddenElement.setValue("dumpVHS;0;0;0");
                hiddenElement.click();
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                hiddenElement.clear();
            }
            catch (NumberFormatException | NoSuchElementException | StaleElementReferenceException e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Throwable)e, (String[])new String[0]);
            }
        }
    }

    @Override
    public Region getElementRegion(WebElement element, boolean shouldStitchContent, Boolean statusBarExists) {
        Region region = new Region(element.getLocation().getX(), element.getLocation().getY(), element.getSize().getWidth(), element.getSize().getHeight());
        if (shouldStitchContent) {
            String className = this.tryGetClassWithHelperLibrary();
            if (className == null) {
                className = element.getAttribute("className");
            }
            this.logger.log(TraceLevel.Debug, this.eyesDriver.getTestId(), Stage.CHECK, new Pair[]{Pair.of((Object)"elementClass", (Object)className)});
            double devicePixelRatio = this.eyesDriver.getDevicePixelRatio();
            ContentSize contentSize = EyesAppiumUtils.getContentSize(this.driver, element);
            region = new Region(contentSize.left, (int)((double)element.getLocation().y * devicePixelRatio), contentSize.width, contentSize.getScrollContentHeight());
            if (className.equals("android.support.v7.widget.RecyclerView") || className.equals("androidx.recyclerview.widget.RecyclerView") || className.equals("androidx.viewpager2.widget.ViewPager2") || className.equals("android.widget.ListView") || className.equals("android.widget.GridView") || this.scrollRootElement != null && className.equals("androidx.core.widget.NestedScrollView")) {
                try {
                    String scrollableContentSize = this.getScrollableContentSize(element.getAttribute("resourceId"));
                    try {
                        int scrollableHeight = Integer.parseInt(scrollableContentSize);
                        region = new Region((int)((double)element.getLocation().getX() * devicePixelRatio), (int)((double)element.getLocation().getY() * devicePixelRatio), (int)((double)element.getSize().getWidth() * devicePixelRatio), scrollableHeight);
                    }
                    catch (NumberFormatException e) {
                        GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Throwable)e, (String[])new String[0]);
                    }
                }
                catch (NoSuchElementException | StaleElementReferenceException e) {
                    GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Throwable)e, (String[])new String[0]);
                }
            }
        }
        return region;
    }

    private Location getScrollPosFromScrollData(ContentSize contentSize, LastScrollData scrollData, int supposedScrollAmt, boolean isDown) {
        this.logger.log(TraceLevel.Debug, this.eyesDriver.getTestId(), Stage.CHECK, new Pair[]{Pair.of((Object)"scrollData", (Object)scrollData), Pair.of((Object)"contentSize", (Object)contentSize)});
        if (scrollData == null) {
            if (isDown) {
                return new Location(this.curScrollPos.getX(), contentSize.scrollableOffset);
            }
            return new Location(this.curScrollPos == null ? 0 : this.curScrollPos.getX(), 0);
        }
        if (scrollData.scrollX != -1 && scrollData.scrollY != -1) {
            return new Location(scrollData.scrollX, scrollData.scrollY);
        }
        if (contentSize == null) {
            contentSize = new ContentSize();
        }
        double avgItemHeight = contentSize.getScrollContentHeight() / scrollData.itemCount;
        int curYPos = this.curScrollPos == null ? 0 : this.curScrollPos.getY();
        int yPosByIndex = (int)avgItemHeight * scrollData.fromIndex;
        int yPosByAssumption = curYPos + supposedScrollAmt;
        int newYPos = (double)Math.abs(yPosByAssumption - yPosByIndex) / (double)contentSize.height > 0.1 ? yPosByIndex : yPosByAssumption;
        return new Location(this.curScrollPos == null ? 0 : this.curScrollPos.getX(), newYPos);
    }

    @Override
    public RectangleSize getEntireSize() {
        int scrollableHeight;
        ContentSize contentSize;
        int windowHeight;
        block10: {
            if (this.curScrollPos != null && this.curScrollPos.getY() != 0 && this.entireSize != null) {
                return this.entireSize;
            }
            windowHeight = this.driver.manage().window().getSize().getHeight() - this.getStatusBarHeight();
            contentSize = this.getCachedContentSize();
            if (contentSize == null) {
                return this.eyesDriver.getDefaultContentViewportSize();
            }
            scrollableHeight = 0;
            try {
                WebElement activeScroll = this.scrollRootElement;
                if (activeScroll == null) {
                    activeScroll = this.getFirstScrollableView();
                }
                this.logger.log(TraceLevel.Debug, this.eyesDriver.getTestId(), Stage.CHECK, new Pair[]{Pair.of((Object)"elementClass", (Object)activeScroll.getAttribute("className"))});
                String className = this.tryGetClassWithHelperLibrary();
                if (className == null) {
                    className = activeScroll.getAttribute("className");
                }
                if (!className.equals("android.support.v7.widget.RecyclerView") && !className.equals("androidx.recyclerview.widget.RecyclerView") && !className.equals("androidx.viewpager2.widget.ViewPager2") && !className.equals("android.widget.ListView") && !className.equals("android.widget.GridView") && (this.scrollRootElement == null || !className.equals("androidx.core.widget.NestedScrollView"))) break block10;
                try {
                    String scrollableContentSize = this.getScrollableContentSize(activeScroll.getAttribute("resourceId"));
                    try {
                        scrollableHeight = Integer.parseInt(scrollableContentSize);
                    }
                    catch (NumberFormatException e) {
                        GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Throwable)e, (String[])new String[0]);
                    }
                }
                catch (NoSuchElementException | StaleElementReferenceException e) {
                    scrollableHeight = contentSize.scrollableOffset > 0 ? contentSize.scrollableOffset : contentSize.height;
                    GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Throwable)e, (String[])new String[0]);
                }
                int position = activeScroll instanceof EyesAppiumElement ? (int)((double)activeScroll.getLocation().getY() * this.eyesDriver.getDevicePixelRatio()) : activeScroll.getLocation().getY();
                this.contentSize.top = position;
                this.contentSize.height = activeScroll.getRect().getHeight();
            }
            catch (NoSuchElementException e) {
                GeneralUtils.logExceptionStackTrace((Logger)this.logger, (Stage)Stage.CHECK, (Throwable)e, (String[])new String[0]);
            }
        }
        this.contentSize.scrollableOffset = scrollableHeight == 0 ? contentSize.scrollableOffset : scrollableHeight - contentSize.height;
        int scrollContentHeight = this.contentSize.getScrollContentHeight();
        int outsideScrollviewHeight = windowHeight - contentSize.height;
        this.entireSize = new RectangleSize(contentSize.width, scrollContentHeight + outsideScrollviewHeight + this.verticalScrollGap);
        this.logger.log(TraceLevel.Debug, this.eyesDriver.getTestId(), Stage.CHECK, new Pair[]{Pair.of((Object)"entireSize", (Object)this.entireSize), Pair.of((Object)"verticalScrollGap", (Object)this.verticalScrollGap), Pair.of((Object)"scrollContentHeight", (Object)scrollContentHeight)});
        return new RectangleSize(this.entireSize.getWidth(), this.entireSize.getHeight());
    }

    @Override
    protected WebElement getFirstScrollableView() {
        if (this.cachedScrollableView == null) {
            WebElement scrollableView;
            if (this.scrollRootElement != null) {
                scrollableView = this.driver.findElement(MobileBy.id((String)this.scrollRootElement.getAttribute("resourceId")));
            } else {
                scrollableView = EyesAppiumUtils.getFirstScrollableView((WebDriver)this.driver);
                if (scrollableView.getAttribute("className").equals("android.widget.HorizontalScrollView")) {
                    List list = this.driver.findElements(By.xpath((String)EyesAppiumUtils.SCROLLVIEW_XPATH));
                    for (WebElement element : list) {
                        if (element.getAttribute("className").equals("android.widget.HorizontalScrollView")) continue;
                        List child = scrollableView.findElements(By.xpath((String)EyesAppiumUtils.SCROLLVIEW_XPATH));
                        scrollableView = child.isEmpty() ? element : (WebElement)child.get(0);
                    }
                }
            }
            if (scrollableView.getAttribute("className").equals("android.widget.HorizontalScrollView")) {
                throw new NoSuchElementException("Only HorizontalScrollView presented on the screen");
            }
            this.cachedScrollableView = scrollableView;
        }
        return this.cachedScrollableView;
    }

    private String getScrollableContentSize(String resourceId) {
        String scrollableContentSize = "";
        if (resourceId == null) {
            return scrollableContentSize;
        }
        String[] version = EyesAppiumUtils.getHelperLibraryVersion(this.eyesDriver, this.logger).split("\\.");
        if (version.length == 3 && Integer.parseInt(version[0]) >= 1 && Integer.parseInt(version[1]) >= 3) {
            MobileElement hiddenElement = (MobileElement)((AndroidDriver)this.driver).findElement(MobileBy.AndroidUIAutomator((String)"new UiSelector().description(\"EyesAppiumHelperEDT\")"));
            if (hiddenElement != null) {
                String elementId = resourceId.split("/")[1];
                hiddenElement.setValue("offset;" + elementId + ";0;0;0");
                hiddenElement.click();
                scrollableContentSize = hiddenElement.getText();
                hiddenElement.clear();
            }
        } else {
            MobileElement hiddenElement = (MobileElement)((AndroidDriver)this.driver).findElement(MobileBy.AndroidUIAutomator((String)"new UiSelector().description(\"EyesAppiumHelper\")"));
            if (hiddenElement != null) {
                hiddenElement.click();
                scrollableContentSize = hiddenElement.getText();
            }
        }
        this.logger.log(TraceLevel.Debug, this.eyesDriver.getTestId(), Stage.CHECK, new Pair[]{Pair.of((Object)"scrollableHeightFromHelper", (Object)scrollableContentSize)});
        return scrollableContentSize;
    }

    @Override
    public void cleanupCachedData() {
        super.cleanupCachedData();
        this.curScrollPos = null;
        this.entireSize = null;
        this.scrollableViewLoc = null;
    }
}

