/*
 * Decompiled with CFR 0.152.
 */
package com.applitools.eyes.appium;

import com.applitools.eyes.CutProvider;
import com.applitools.eyes.Location;
import com.applitools.eyes.Logger;
import com.applitools.eyes.RectangleSize;
import com.applitools.eyes.Region;
import com.applitools.eyes.ScaleProviderFactory;
import com.applitools.eyes.appium.AndroidScrollPositionProvider;
import com.applitools.eyes.appium.AppiumFullPageCaptureAlgorithm;
import com.applitools.eyes.appium.AppiumScrollPositionProvider;
import com.applitools.eyes.appium.ContentSize;
import com.applitools.eyes.capture.EyesScreenshotFactory;
import com.applitools.eyes.capture.ImageProvider;
import com.applitools.eyes.config.ContentInset;
import com.applitools.eyes.debug.DebugScreenshotsProvider;
import com.applitools.eyes.logging.Stage;
import com.applitools.eyes.logging.TraceLevel;
import org.apache.commons.lang3.tuple.Pair;
import org.openqa.selenium.WebElement;

public class AndroidFullPageCaptureAlgorithm
extends AppiumFullPageCaptureAlgorithm {
    private String scrollableElementId = null;

    public AndroidFullPageCaptureAlgorithm(Logger logger, String testId, AppiumScrollPositionProvider scrollProvider, ImageProvider imageProvider, DebugScreenshotsProvider debugScreenshotsProvider, ScaleProviderFactory scaleProviderFactory, CutProvider cutProvider, EyesScreenshotFactory screenshotFactory, int waitBeforeScreenshots, Integer stitchingAdjustment, WebElement scrollRootElement, ContentInset contentInset, boolean cacheScrollableSize) {
        super(logger, testId, scrollProvider, imageProvider, debugScreenshotsProvider, scaleProviderFactory, cutProvider, screenshotFactory, waitBeforeScreenshots, null, stitchingAdjustment, scrollRootElement, null, contentInset, cacheScrollableSize);
        this.coordinatesAreScaled = true;
        if (scrollRootElement != null) {
            this.scrollableElementId = scrollRootElement.getAttribute("resourceId").split("/")[1];
        }
    }

    @Override
    protected void captureAndStitchTailParts(RectangleSize entireSize, RectangleSize initialPartSize) {
        Region regionToCrop;
        this.moveToTopLeft();
        int behaviorOffset = 0;
        int offset = ((AndroidScrollPositionProvider)this.scrollProvider).getBehaviorOffsetWithHelperLibrary();
        if (offset != -1) {
            behaviorOffset = offset;
        }
        int scrollViewYBeforeBehaviorScrolled = this.getScrollableViewY();
        boolean behaviorScrolled = ((AndroidScrollPositionProvider)this.scrollProvider).tryScrollBehaviorOffsetWithHelperLibrary(this.scrollableElementId, behaviorOffset);
        int scrollViewYAfterBehaviorScrolled = this.getScrollableViewY();
        int scrollableViewHeight = this.getScrollableViewHeight();
        RectangleSize lastSuccessfulPartSize = new RectangleSize(initialPartSize.getWidth(), initialPartSize.getHeight());
        ContentSize contentSize = ((AppiumScrollPositionProvider)this.scrollProvider).getCachedContentSize();
        int xPos = this.getScrollableViewX() + 1;
        int oneScrollStep = scrollableViewHeight - this.stitchingAdjustment;
        int maxScrollSteps = contentSize.getScrollContentHeight() / oneScrollStep;
        this.logger.log(TraceLevel.Debug, this.testId, Stage.CHECK, new Pair[]{Pair.of((Object)"entireScrollableHeight", (Object)contentSize.getScrollContentHeight()), Pair.of((Object)"oneScrollStep", (Object)oneScrollStep)});
        for (int step = 1; step <= maxScrollSteps; ++step) {
            regionToCrop = new Region(0, scrollViewYAfterBehaviorScrolled + (step == 1 ? 0 : this.stitchingAdjustment), initialPartSize.getWidth(), oneScrollStep + (step == 1 ? this.stitchingAdjustment : 0));
            if (step == 1) {
                this.currentPosition = new Location(0, scrollViewYBeforeBehaviorScrolled + this.statusBarHeight);
            }
            lastSuccessfulPartSize = this.captureAndStitchCurrentPart(regionToCrop);
            int startY = scrollableViewHeight + scrollViewYAfterBehaviorScrolled - 1 - (step != maxScrollSteps ? this.stitchingAdjustment / 2 : 0);
            int endY = scrollViewYAfterBehaviorScrolled + (step != maxScrollSteps ? this.stitchingAdjustment / 2 : 0);
            boolean isScrolledWithHelperLibrary = false;
            if (this.scrollableElementId != null) {
                this.logger.log(TraceLevel.Debug, this.testId, Stage.CHECK, new Pair[]{Pair.of((Object)"scrollRootElementId", (Object)this.scrollableElementId)});
                isScrolledWithHelperLibrary = ((AndroidScrollPositionProvider)this.scrollProvider).tryScrollWithHelperLibrary(this.scrollableElementId, startY - endY, step, maxScrollSteps);
                if (step == maxScrollSteps && isScrolledWithHelperLibrary) {
                    ((AndroidScrollPositionProvider)this.scrollProvider).tryScrollWithHelperLibrary(this.scrollableElementId, startY - endY, -1, maxScrollSteps);
                }
            }
            if (!isScrolledWithHelperLibrary) {
                ((AppiumScrollPositionProvider)this.scrollProvider).scrollTo(xPos, startY, xPos, endY, step != maxScrollSteps);
            }
            this.currentPosition = new Location(0, this.currentPosition.getY() + lastSuccessfulPartSize.getHeight());
            if (step != maxScrollSteps) continue;
            if (isScrolledWithHelperLibrary) {
                ((AndroidScrollPositionProvider)this.scrollProvider).tryScrollWithHelperLibrary(this.scrollableElementId, startY - endY, -1, maxScrollSteps);
            }
            int cropTo = contentSize.getScrollContentHeight() - oneScrollStep * step - this.stitchingAdjustment;
            int cropFrom = scrollableViewHeight + scrollViewYAfterBehaviorScrolled - cropTo;
            if (cropTo <= 0) continue;
            regionToCrop = new Region(0, cropFrom - this.stitchingAdjustment, initialPartSize.getWidth(), cropTo + this.stitchingAdjustment);
            this.currentPosition = new Location(0, this.currentPosition.getY() - this.stitchingAdjustment);
            lastSuccessfulPartSize = this.captureAndStitchCurrentPart(regionToCrop);
            this.currentPosition = new Location(0, this.currentPosition.getY() + lastSuccessfulPartSize.getHeight());
        }
        int heightUnderScrollableView = initialPartSize.getHeight() - scrollableViewHeight - scrollViewYAfterBehaviorScrolled;
        if (heightUnderScrollableView > 0) {
            regionToCrop = new Region(0, scrollableViewHeight + scrollViewYAfterBehaviorScrolled, initialPartSize.getWidth(), heightUnderScrollableView);
            lastSuccessfulPartSize = this.captureAndStitchCurrentPart(regionToCrop);
        }
        if (behaviorScrolled) {
            ((AndroidScrollPositionProvider)this.scrollProvider).tryScrollBehaviorOffsetWithHelperLibrary(this.scrollableElementId, -behaviorOffset);
        }
        this.cleanupStitch(null, this.currentPosition, lastSuccessfulPartSize, entireSize);
        this.moveToTopLeft();
    }

    @Override
    protected void moveToTopLeft() {
        boolean isScrolledWithHelperLibrary = false;
        if (this.scrollableElementId != null) {
            isScrolledWithHelperLibrary = ((AndroidScrollPositionProvider)this.scrollProvider).moveToTop(this.scrollableElementId);
        }
        if (!isScrolledWithHelperLibrary) {
            super.moveToTopLeft();
        }
    }

    @Override
    protected void moveToTopLeft(int startX, int startY, int endX, int endY) {
        this.moveToTopLeft();
    }

    private int getScrollableViewY() {
        WebElement element = ((AndroidScrollPositionProvider)this.scrollProvider).getFirstScrollableView();
        return element.getLocation().getY() - ((AndroidScrollPositionProvider)this.scrollProvider).getStatusBarHeight();
    }

    private int getScrollableViewX() {
        WebElement element = ((AndroidScrollPositionProvider)this.scrollProvider).getFirstScrollableView();
        return element.getLocation().getX();
    }

    private int getScrollableViewHeight() {
        WebElement element = ((AndroidScrollPositionProvider)this.scrollProvider).getFirstScrollableView();
        return element.getSize().getHeight();
    }
}

