/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.ast;

import com.apollographql.apollo.ast.internal.UnicodeKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0002\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0004\u001a\u00020\u0001*\u00020\u0001\u001a\f\u0010\u0005\u001a\u00020\u0001*\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"decodeAsGraphQLSingleQuoted", "", "decodeAsGraphQLTripleQuoted", "encodeToGraphQLSingleQuoted", "encodeToGraphQLTripleQuoted", "hexString", "", "apollo-ast"})
@SourceDebugExtension(value={"SMAP\ngqlstrings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 gqlstrings.kt\ncom/apollographql/apollo/ast/GqlstringsKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n158#2,6:148\n158#2,6:164\n158#2,6:178\n1179#2,2:189\n1557#3:154\n1628#3,3:155\n756#3,6:158\n762#3,4:170\n739#3,4:174\n743#3,5:184\n*S KotlinDebug\n*F\n+ 1 gqlstrings.kt\ncom/apollographql/apollo/ast/GqlstringsKt\n*L\n69#1:148,6\n88#1:164,6\n92#1:178,6\n109#1:189,2\n76#1:154\n76#1:155,3\n87#1:158,6\n87#1:170,4\n91#1:174,4\n91#1:184,5\n*E\n"})
public final class GqlstringsKt {
    @NotNull
    public static final String decodeAsGraphQLSingleQuoted(@NotNull String $this$decodeAsGraphQLSingleQuoted) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeAsGraphQLSingleQuoted, (String)"<this>");
        StringBuilder writer = new StringBuilder();
        int i = 0;
        block11: while (i < $this$decodeAsGraphQLSingleQuoted.length()) {
            char c = $this$decodeAsGraphQLSingleQuoted.charAt(i);
            ++i;
            if (c != '\\') {
                writer.append(c);
                continue;
            }
            char escaped = $this$decodeAsGraphQLSingleQuoted.charAt(i);
            switch (escaped) {
                case '\"': {
                    writer.append('\"');
                    ++i;
                    continue block11;
                }
                case '/': {
                    writer.append('/');
                    ++i;
                    continue block11;
                }
                case '\\': {
                    writer.append('\\');
                    ++i;
                    continue block11;
                }
                case 'b': {
                    writer.append('\b');
                    ++i;
                    continue block11;
                }
                case 'f': {
                    writer.append('\f');
                    ++i;
                    continue block11;
                }
                case 'n': {
                    writer.append('\n');
                    ++i;
                    continue block11;
                }
                case 'r': {
                    writer.append('\r');
                    ++i;
                    continue block11;
                }
                case 't': {
                    writer.append('\t');
                    ++i;
                    continue block11;
                }
                case 'u': {
                    String string = $this$decodeAsGraphQLSingleQuoted.substring(i + 1, i + 5);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    int codepoint = Integer.parseInt(string, CharsKt.checkRadix((int)16));
                    UnicodeKt.appendCodePointMpp(writer, codepoint);
                    i += 5;
                    continue block11;
                }
            }
            throw new IllegalStateException("Bad escaped character: " + c);
        }
        String string = writer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String decodeAsGraphQLTripleQuoted(@NotNull String $this$decodeAsGraphQLTripleQuoted) {
        List list;
        List lines;
        block16: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)$this$decodeAsGraphQLTripleQuoted, (String)"<this>");
            String value = StringsKt.replace$default((String)$this$decodeAsGraphQLTripleQuoted, (String)"\\\"\"\"", (String)"\"\"\"", (boolean)false, (int)4, null);
            String[] stringArray = new String[]{"\n"};
            lines = StringsKt.split$default((CharSequence)value, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            Integer commonIndent = null;
            for (String line : CollectionsKt.drop((Iterable)lines, (int)1)) {
                int firstNonWhitespace;
                int n;
                block13: {
                    CharSequence $this$indexOfFirst$iv = line;
                    boolean $i$f$indexOfFirst = false;
                    int n2 = $this$indexOfFirst$iv.length();
                    for (int index$iv = 0; index$iv < n2; ++index$iv) {
                        char it = $this$indexOfFirst$iv.charAt(index$iv);
                        boolean bl = false;
                        if (!(it != ' ' && it != '\t')) continue;
                        n = index$iv;
                        break block13;
                    }
                    n = -1;
                }
                if ((firstNonWhitespace = n) == -1 || commonIndent != null && firstNonWhitespace >= ((Number)commonIndent).intValue()) continue;
                commonIndent = firstNonWhitespace;
            }
            Iterable iterable = CollectionsKt.drop((Iterable)lines, (int)1);
            Collection collection = CollectionsKt.listOf((Object)CollectionsKt.first((List)lines));
            boolean $i$f$map = false;
            void firstNonWhitespace = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string;
                String it = (String)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                if (commonIndent == null) {
                    string = it;
                } else if (it.length() > ((Number)commonIndent).intValue()) {
                    String string2 = it.substring(((Number)commonIndent).intValue());
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                } else {
                    string = it;
                }
                collection2.add(string);
            }
            lines = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
            Iterable $this$dropWhile$iv = lines;
            boolean $i$f$dropWhile = false;
            boolean yielding$iv = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$dropWhile$iv) {
                int n;
                block14: {
                    if (yielding$iv) {
                        list$iv.add(item$iv);
                        continue;
                    }
                    String it = (String)item$iv;
                    boolean bl = false;
                    CharSequence $this$indexOfFirst$iv = it;
                    boolean $i$f$indexOfFirst = false;
                    int n3 = $this$indexOfFirst$iv.length();
                    for (int index$iv = 0; index$iv < n3; ++index$iv) {
                        char it2 = $this$indexOfFirst$iv.charAt(index$iv);
                        boolean bl2 = false;
                        if (!(it2 != ' ' && it2 != '\t')) continue;
                        n = index$iv;
                        break block14;
                    }
                    n = -1;
                }
                if (n == -1) continue;
                list$iv.add(item$iv);
                yielding$iv = true;
            }
            List $this$dropLastWhile$iv = lines = (List)list$iv;
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    int n;
                    block15: {
                        String it = (String)iterator$iv.previous();
                        boolean bl = false;
                        CharSequence $this$indexOfFirst$iv = it;
                        boolean $i$f$indexOfFirst = false;
                        int n4 = $this$indexOfFirst$iv.length();
                        for (int index$iv = 0; index$iv < n4; ++index$iv) {
                            char it3 = $this$indexOfFirst$iv.charAt(index$iv);
                            boolean bl3 = false;
                            if (!(it3 != ' ' && it3 != '\t')) continue;
                            n = index$iv;
                            break block15;
                        }
                        n = -1;
                    }
                    if (n == -1) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break block16;
                }
            }
            list = CollectionsKt.emptyList();
        }
        lines = list;
        return CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public static final String encodeToGraphQLSingleQuoted(@NotNull String $this$encodeToGraphQLSingleQuoted) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$encodeToGraphQLSingleQuoted, (String)"<this>");
        StringBuilder $this$encodeToGraphQLSingleQuoted_u24lambda_u247 = stringBuilder = new StringBuilder();
        boolean bl = false;
        CharSequence $this$forEach$iv = $this$encodeToGraphQLSingleQuoted;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            StringBuilder stringBuilder2;
            char element$iv;
            char c = element$iv = $this$forEach$iv.charAt(i);
            boolean bl2 = false;
            char c2 = c;
            if (c2 == '\"') {
                stringBuilder2 = $this$encodeToGraphQLSingleQuoted_u24lambda_u247.append("\\\"");
                continue;
            }
            if (c2 == '\\') {
                stringBuilder2 = $this$encodeToGraphQLSingleQuoted_u24lambda_u247.append("\\\\");
                continue;
            }
            if (c2 == '\b') {
                stringBuilder2 = $this$encodeToGraphQLSingleQuoted_u24lambda_u247.append("\\b");
                continue;
            }
            if (c2 == '\f') {
                stringBuilder2 = $this$encodeToGraphQLSingleQuoted_u24lambda_u247.append("\\f");
                continue;
            }
            if (c2 == '\n') {
                stringBuilder2 = $this$encodeToGraphQLSingleQuoted_u24lambda_u247.append("\\n");
                continue;
            }
            if (c2 == '\r') {
                stringBuilder2 = $this$encodeToGraphQLSingleQuoted_u24lambda_u247.append("\\r");
                continue;
            }
            if (c2 == '\t') {
                stringBuilder2 = $this$encodeToGraphQLSingleQuoted_u24lambda_u247.append("\\t");
                continue;
            }
            boolean bl3 = '\u0000' <= c2 ? c2 < ' ' : false;
            if (bl3) {
                stringBuilder2 = $this$encodeToGraphQLSingleQuoted_u24lambda_u247.append("\\u00" + GqlstringsKt.hexString((byte)c));
                continue;
            }
            stringBuilder2 = ('\u007f' <= c2 ? c2 < '\u00a0' : false) ? $this$encodeToGraphQLSingleQuoted_u24lambda_u247.append("\\u00" + GqlstringsKt.hexString((byte)c)) : $this$encodeToGraphQLSingleQuoted_u24lambda_u247.append(c);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final String encodeToGraphQLTripleQuoted(@NotNull String $this$encodeToGraphQLTripleQuoted) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$encodeToGraphQLTripleQuoted, (String)"<this>");
        String it = StringsKt.replace$default((String)$this$encodeToGraphQLTripleQuoted, (String)"\"\"\"", (String)"\\\"\"\"", (boolean)false, (int)4, null);
        boolean bl = false;
        if (((CharSequence)$this$encodeToGraphQLTripleQuoted).length() == 0) {
            string = it;
        } else {
            String leading = it.charAt(0) != '\n' ? "\n" : "";
            String trailing = it.charAt(it.length() - 1) != '\n' ? "\n" : "";
            string = leading + it + trailing;
        }
        return string;
    }

    private static final String hexString(byte $this$hexString) {
        String hexArray = "0123456789abcdef";
        byte value = $this$hexString;
        return "" + hexArray.charAt(value >>> 4) + hexArray.charAt(value & 0xF);
    }
}

