/*
 * Decompiled with CFR 0.152.
 */
package com.aol.micro.server.couchbase.base;

import com.aol.cyclops.invokedynamic.ExceptionSoftener;
import com.aol.micro.server.couchbase.DistributedMapClient;
import com.aol.micro.server.couchbase.base.Data;
import com.aol.micro.server.couchbase.base.ManifestComparatorKeyNotFoundException;
import com.aol.micro.server.couchbase.base.VersionedKey;
import com.aol.micro.server.rest.jackson.JacksonUtil;
import java.util.Date;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestComparator<T> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String key;
    private volatile T data;
    private volatile String versionedKey;
    private final DistributedMapClient connection;

    public ManifestComparator(DistributedMapClient connection) {
        this.key = "default";
        this.versionedKey = this.newKey(1L).toJson();
        this.connection = connection;
    }

    public ManifestComparator(String key, DistributedMapClient connection) {
        this.key = key;
        this.versionedKey = this.newKey(1L).toJson();
        this.connection = connection;
    }

    public <T> ManifestComparator<T> withKey(String key) {
        return new ManifestComparator<T>(key, this.connection);
    }

    private VersionedKey newKey(Long version) {
        return new VersionedKey(this.key, version);
    }

    private VersionedKey increment() {
        VersionedKey currentVersionedKey = this.loadKeyFromCouchbase();
        return currentVersionedKey.withVersion(currentVersionedKey.getVersion() + 1L);
    }

    private VersionedKey loadKeyFromCouchbase() {
        Optional optionalKey = this.connection.get(this.key);
        return optionalKey.flatMap(val -> Optional.of(JacksonUtil.convertFromJson((String)val, VersionedKey.class))).orElse(this.newKey(0L));
    }

    public boolean isOutOfDate() {
        return !this.versionedKey.equals(this.loadKeyFromCouchbase().toJson());
    }

    public synchronized void load() {
        T oldData = this.data;
        String oldKey = this.versionedKey;
        try {
            if (this.isOutOfDate()) {
                String newVersionedKey = (String)this.connection.get(this.key).get();
                this.data = this.nonAtomicload(newVersionedKey);
                this.versionedKey = newVersionedKey;
            }
        }
        catch (Throwable e) {
            this.data = oldData;
            this.versionedKey = oldKey;
            this.logger.debug(e.getMessage(), e);
            throw ExceptionSoftener.throwSoftenedException((Throwable)e);
        }
    }

    private Object nonAtomicload(String newVersionedKey) throws Throwable {
        Data data = (Data)this.connection.get(newVersionedKey).orElseThrow(() -> new ManifestComparatorKeyNotFoundException("Missing versioned key " + newVersionedKey + " - likely data changed during read"));
        this.logger.info("Loaded new data with date {} for key {}, versionedKey {}, versionedKey from data ", new Object[]{data.getDate(), this.key, newVersionedKey, data.getVersionedKey()});
        return data.getData();
    }

    public void cleanAll() {
        this.clean(-1);
    }

    public void clean(int numberToClean) {
        this.logger.info("Attempting to delete the last {} records for key {}", (Object)numberToClean, (Object)this.key);
        VersionedKey currentVersionedKey = this.loadKeyFromCouchbase();
        long start = 0L;
        if (numberToClean != -1) {
            start = currentVersionedKey.getVersion() - (long)numberToClean;
        }
        for (long i = start; i < currentVersionedKey.getVersion(); ++i) {
            this.delete(currentVersionedKey.withVersion(i).toJson());
        }
        this.logger.info("Finished deleting the last {} records for key {}", (Object)numberToClean, (Object)this.key);
    }

    private void delete(String withVersion) {
        this.connection.delete(withVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAndIncrement(T data) {
        T oldData = this.data;
        VersionedKey newVersionedKey = this.increment();
        this.logger.info("Saving data with key {}, new version is {}", (Object)this.key, (Object)newVersionedKey.toJson());
        this.connection.put(newVersionedKey.toJson(), new Data<T>(data, new Date(), newVersionedKey.toJson()));
        this.connection.put(this.key, newVersionedKey.toJson());
        try {
            this.data = data;
            this.delete(this.versionedKey);
        }
        catch (Throwable t) {
            this.data = oldData;
        }
        finally {
            this.versionedKey = newVersionedKey.toJson();
        }
    }

    private ManifestComparator(String key, T data, String versionedKey, DistributedMapClient connection) {
        this.key = key;
        this.data = data;
        this.versionedKey = versionedKey;
        this.connection = connection;
    }

    public T getData() {
        return this.data;
    }

    public String getVersionedKey() {
        return this.versionedKey;
    }
}

