/*
 * Decompiled with CFR 0.152.
 */
package com.aol.micro.server.couchbase;

import com.aol.cyclops.invokedynamic.ExceptionSoftener;
import com.couchbase.client.CouchbaseClient;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedMapClient<V> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Optional<CouchbaseClient> couchbaseClient;

    public DistributedMapClient(CouchbaseClient couchbaseClient) {
        this.couchbaseClient = Optional.ofNullable(couchbaseClient);
    }

    public boolean put(String key, V value) {
        this.logger.debug("put '{}', value:{}", (Object)key, value);
        return this.couchbaseClient.map(c -> this.putInternal((CouchbaseClient)c, key, value)).orElse(false);
    }

    private boolean putInternal(CouchbaseClient client, String key, V value) {
        try {
            return (Boolean)client.set(key, value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw ExceptionSoftener.throwSoftenedException((Throwable)e);
        }
    }

    public Optional<V> get(String key) {
        return this.couchbaseClient.map(c -> c.get(key));
    }

    public void delete(String key) {
        this.couchbaseClient.map(c -> c.delete(key));
    }
}

