/*
 * Decompiled with CFR 0.152.
 */
package com.aol.micro.server.couchbase;

import com.aol.micro.server.couchbase.DistributedMapClient;
import com.aol.micro.server.couchbase.base.ManifestComparator;
import com.couchbase.client.CouchbaseClient;
import com.couchbase.client.CouchbaseConnectionFactory;
import com.couchbase.client.CouchbaseConnectionFactoryBuilder;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
public class ConfigureCouchbase {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${couchbaseServers:}")
    private String couchbaseServers;
    @Value(value="${couchbaseBucket:couchbase_bucket}")
    private String couchbaseBucket;
    @Value(value="${couchbasePassword:}")
    private String couchbasePassword;
    @Value(value="${couchbaseClientEnabled:true}")
    private boolean couchbaseClientEnabled = true;
    @Value(value="${couchbaseClientOperationTimeout:120000}")
    private long opTimeout;

    @Bean(name={"couchbaseDistributedMap"})
    public DistributedMapClient simpleCouchbaseClient() throws IOException, URISyntaxException {
        if (this.couchbaseClientEnabled) {
            return new DistributedMapClient(this.couchbaseClient());
        }
        return new DistributedMapClient(null);
    }

    @Bean(name={"couchbaseClient"})
    public CouchbaseClient couchbaseClient() throws IOException, URISyntaxException {
        if (this.couchbaseClientEnabled) {
            this.logger.info("Creating CouchbaseClient for servers: {}", (Object)this.couchbaseServers);
            CouchbaseConnectionFactoryBuilder builder = new CouchbaseConnectionFactoryBuilder();
            builder.setOpTimeout(this.opTimeout);
            CouchbaseConnectionFactory cf = builder.buildCouchbaseConnection(this.getServersList(), this.couchbaseBucket, StringUtils.trimAllWhitespace((String)Optional.ofNullable(this.couchbasePassword).orElse("")));
            return new CouchbaseClient(cf);
        }
        return null;
    }

    @Bean
    public ManifestComparator couchbaseManifestComparator() throws IOException, URISyntaxException {
        return new ManifestComparator(this.simpleCouchbaseClient());
    }

    private List<URI> getServersList() throws URISyntaxException {
        ArrayList<URI> uris = new ArrayList<URI>();
        if (this.couchbaseServers.indexOf(44) == -1) {
            uris.add(new URI(this.couchbaseServers));
            return uris;
        }
        for (String serverHost : StringUtils.split((String)this.couchbaseServers, (String)",")) {
            uris.add(new URI(serverHost));
        }
        return uris;
    }

    public void setCouchbaseServers(String couchbaseServers) {
        this.couchbaseServers = couchbaseServers;
    }

    public void setCouchbaseClientEnabled(boolean couchbaseClientEnabled) {
        this.couchbaseClientEnabled = couchbaseClientEnabled;
    }
}

