/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test.report;

import org.gradle.api.tasks.testing.TestResult;
import org.gradle.reporting.DurationFormatter;

public abstract class TestResultModel {
    public static final DurationFormatter DURATION_FORMATTER = new DurationFormatter();

    public abstract TestResult.ResultType getResultType();

    public abstract long getDuration();

    public abstract String getTitle();

    public String getFormattedDuration() {
        return DURATION_FORMATTER.format(this.getDuration());
    }

    public String getStatusClass() {
        switch (this.getResultType()) {
            case SUCCESS: {
                return "success";
            }
            case FAILURE: {
                return "failures";
            }
            case SKIPPED: {
                return "skipped";
            }
        }
        throw new IllegalStateException();
    }

    public String getFormattedResultType() {
        switch (this.getResultType()) {
            case SUCCESS: {
                return "passed";
            }
            case FAILURE: {
                return "failed";
            }
            case SKIPPED: {
                return "ignored";
            }
        }
        throw new IllegalStateException();
    }
}

