/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.annotations.NonNull;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SplitOptions {
    private boolean enable = false;
    private boolean reset = false;
    private Set<String> exclude;
    private Set<String> include;

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public Set<String> getExclude() {
        return this.exclude;
    }

    public Set<String> getInclude() {
        return this.include;
    }

    public void setExclude(@NonNull List<String> list) {
        this.exclude = Sets.newHashSet(list);
    }

    public void exclude(String ... excludes) {
        if (this.exclude == null) {
            this.exclude = Sets.newHashSet((Object[])excludes);
            return;
        }
        this.exclude.addAll(Arrays.asList(excludes));
    }

    public void setInclude(@NonNull List<String> list) {
        this.include = Sets.newHashSet(list);
    }

    public void include(String ... includes) {
        if (this.include == null) {
            this.include = Sets.newHashSet((Object[])includes);
            return;
        }
        this.include.addAll(Arrays.asList(includes));
    }

    public void reset() {
        this.reset = true;
    }

    @NonNull
    public Set<String> getApplicableFilters(@NonNull Set<String> allFilters) {
        HashSet results;
        if (!this.enable) {
            return Collections.singleton(null);
        }
        HashSet hashSet = results = this.reset ? Sets.newHashSetWithExpectedSize((int)(allFilters.size() + 1)) : Sets.newHashSet(allFilters);
        if (this.exclude != null) {
            results.removeAll(this.exclude);
        }
        if (this.include != null) {
            for (String inc : this.include) {
                if (!allFilters.contains(inc)) continue;
                results.add(inc);
            }
        }
        return results;
    }
}

