/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.test.report;

import com.android.build.gradle.internal.test.report.AllTestResults;
import com.android.build.gradle.internal.test.report.ClassTestResults;
import com.android.build.gradle.internal.test.report.PackageTestResults;
import com.android.build.gradle.internal.test.report.PageRenderer;
import com.android.build.gradle.internal.test.report.ReportType;
import java.io.IOException;
import org.gradle.api.Action;
import org.gradle.api.internal.html.SimpleHtmlWriter;
import org.gradle.internal.ErroringAction;

class OverviewPageRenderer
extends PageRenderer<AllTestResults> {
    public OverviewPageRenderer(ReportType reportType) {
        super(reportType);
    }

    @Override
    protected void registerTabs() {
        this.addFailuresTab();
        if (!((AllTestResults)((Object)this.getResults())).getPackages().isEmpty()) {
            this.addTab("Packages", (Action<SimpleHtmlWriter>)new ErroringAction<SimpleHtmlWriter>(){

                protected void doExecute(SimpleHtmlWriter writer) throws IOException {
                    OverviewPageRenderer.this.renderPackages(writer);
                }
            });
        }
        this.addTab("Classes", (Action<SimpleHtmlWriter>)new ErroringAction<SimpleHtmlWriter>(){

            public void doExecute(SimpleHtmlWriter htmlWriter) throws IOException {
                OverviewPageRenderer.this.renderClasses(htmlWriter);
            }
        });
    }

    @Override
    protected void renderBreadcrumbs(SimpleHtmlWriter htmlWriter) {
    }

    private void renderPackages(SimpleHtmlWriter htmlWriter) throws IOException {
        htmlWriter.startElement("table");
        htmlWriter.startElement("thead");
        htmlWriter.startElement("tr");
        htmlWriter.startElement("th").characters((CharSequence)"Package").endElement();
        htmlWriter.startElement("th").characters((CharSequence)"Tests").endElement();
        htmlWriter.startElement("th").characters((CharSequence)"Failures").endElement();
        htmlWriter.startElement("th").characters((CharSequence)"Duration").endElement();
        htmlWriter.startElement("th").characters((CharSequence)"Success rate").endElement();
        htmlWriter.endElement();
        htmlWriter.endElement();
        htmlWriter.startElement("tbody");
        for (PackageTestResults testPackage : ((AllTestResults)((Object)this.getResults())).getPackages()) {
            htmlWriter.startElement("tr");
            htmlWriter.startElement("td").attribute("class", testPackage.getStatusClass());
            htmlWriter.startElement("a").attribute("href", String.format("%s.html", testPackage.getFilename(this.reportType))).characters((CharSequence)testPackage.getName()).endElement();
            htmlWriter.endElement();
            htmlWriter.startElement("td").characters((CharSequence)Integer.toString(testPackage.getTestCount())).endElement();
            htmlWriter.startElement("td").characters((CharSequence)Integer.toString(testPackage.getFailureCount())).endElement();
            htmlWriter.startElement("td").characters((CharSequence)testPackage.getFormattedDuration()).endElement();
            htmlWriter.startElement("td").attribute("class", testPackage.getStatusClass()).characters((CharSequence)testPackage.getFormattedSuccessRate()).endElement();
            htmlWriter.endElement();
        }
        htmlWriter.endElement();
        htmlWriter.endElement();
    }

    private void renderClasses(SimpleHtmlWriter htmlWriter) throws IOException {
        htmlWriter.startElement("table");
        htmlWriter.startElement("thead");
        htmlWriter.startElement("tr");
        htmlWriter.startElement("th").characters((CharSequence)"Class").endElement();
        htmlWriter.startElement("th").characters((CharSequence)"Tests").endElement();
        htmlWriter.startElement("th").characters((CharSequence)"Failures").endElement();
        htmlWriter.startElement("th").characters((CharSequence)"Duration").endElement();
        htmlWriter.startElement("th").characters((CharSequence)"Success rate").endElement();
        htmlWriter.endElement();
        htmlWriter.endElement();
        htmlWriter.startElement("tbody");
        for (PackageTestResults testPackage : ((AllTestResults)((Object)this.getResults())).getPackages()) {
            for (ClassTestResults testClass : testPackage.getClasses()) {
                htmlWriter.startElement("tr");
                htmlWriter.startElement("td").attribute("class", testClass.getStatusClass()).endElement();
                htmlWriter.startElement("a").attribute("href", String.format("%s.html", testClass.getFilename(this.reportType))).characters((CharSequence)testClass.getName()).endElement();
                htmlWriter.startElement("td").characters((CharSequence)Integer.toString(testClass.getTestCount())).endElement();
                htmlWriter.startElement("td").characters((CharSequence)Integer.toString(testClass.getFailureCount())).endElement();
                htmlWriter.startElement("td").characters((CharSequence)testClass.getFormattedDuration()).endElement();
                htmlWriter.startElement("td").attribute("class", testClass.getStatusClass()).characters((CharSequence)testClass.getFormattedSuccessRate()).endElement();
                htmlWriter.endElement();
            }
        }
        htmlWriter.endElement();
        htmlWriter.endElement();
    }
}

