/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.api;

import com.android.annotations.NonNull;
import com.android.build.gradle.api.AndroidSourceDirectorySet;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.internal.file.FileResolver;

public class DefaultAndroidSourceDirectorySet
implements AndroidSourceDirectorySet {
    private final String name;
    private final FileResolver fileResolver;
    private List<Object> source = Lists.newArrayList();

    DefaultAndroidSourceDirectorySet(@NonNull String name, @NonNull FileResolver fileResolver) {
        this.name = name;
        this.fileResolver = fileResolver;
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    @NonNull
    public AndroidSourceDirectorySet srcDir(Object srcDir) {
        this.source.add(srcDir);
        return this;
    }

    @Override
    @NonNull
    public AndroidSourceDirectorySet srcDirs(Object ... srcDirs) {
        Collections.addAll(this.source, srcDirs);
        return this;
    }

    @Override
    @NonNull
    public AndroidSourceDirectorySet setSrcDirs(Iterable<?> srcDirs) {
        this.source.clear();
        for (Object srcDir : srcDirs) {
            this.source.add(srcDir);
        }
        return this;
    }

    @Override
    @NonNull
    public Set<File> getSrcDirs() {
        return this.fileResolver.resolveFiles(this.source.toArray()).getFiles();
    }

    @NonNull
    public String toString() {
        return this.source.toString();
    }
}

