/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.model;

import com.android.annotations.NonNull;
import com.android.build.gradle.internal.model.VariantImpl;
import com.android.builder.model.AaptOptions;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.ProductFlavorContainer;
import com.android.builder.model.SigningConfig;
import com.android.builder.model.Variant;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

class DefaultAndroidProject
implements AndroidProject,
Serializable {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final String modelVersion;
    @NonNull
    private final String name;
    @NonNull
    private final String compileTarget;
    @NonNull
    private final List<String> bootClasspath;
    @NonNull
    private final Map<String, SigningConfig> signingConfigs;
    private final boolean isLibrary;
    private final Map<String, BuildTypeContainer> buildTypes = Maps.newHashMap();
    private final Map<String, ProductFlavorContainer> productFlavors = Maps.newHashMap();
    private final Map<String, Variant> variants = Maps.newHashMap();
    private ProductFlavorContainer defaultConfig;

    DefaultAndroidProject(@NonNull String modelVersion, @NonNull String name, @NonNull String compileTarget, @NonNull List<String> bootClasspath, @NonNull Map<String, SigningConfig> signingConfigs, boolean isLibrary) {
        this.modelVersion = modelVersion;
        this.name = name;
        this.compileTarget = compileTarget;
        this.bootClasspath = bootClasspath;
        this.signingConfigs = signingConfigs;
        this.isLibrary = isLibrary;
    }

    @NonNull
    DefaultAndroidProject setDefaultConfig(@NonNull ProductFlavorContainer defaultConfigContainer) {
        this.defaultConfig = defaultConfigContainer;
        return this;
    }

    @NonNull
    DefaultAndroidProject addBuildType(@NonNull BuildTypeContainer buildTypeContainer) {
        this.buildTypes.put(buildTypeContainer.getBuildType().getName(), buildTypeContainer);
        return this;
    }

    @NonNull
    DefaultAndroidProject addProductFlavors(@NonNull ProductFlavorContainer productFlavorContainer) {
        this.productFlavors.put(productFlavorContainer.getProductFlavor().getName(), productFlavorContainer);
        return this;
    }

    @NonNull
    DefaultAndroidProject addVariant(@NonNull VariantImpl variant) {
        this.variants.put(variant.getName(), variant);
        return this;
    }

    @NonNull
    public String getModelVersion() {
        return this.modelVersion;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public ProductFlavorContainer getDefaultConfig() {
        return this.defaultConfig;
    }

    @NonNull
    public Map<String, BuildTypeContainer> getBuildTypes() {
        return this.buildTypes;
    }

    @NonNull
    public Map<String, ProductFlavorContainer> getProductFlavors() {
        return this.productFlavors;
    }

    @NonNull
    public Map<String, Variant> getVariants() {
        return this.variants;
    }

    public boolean isLibrary() {
        return this.isLibrary;
    }

    @NonNull
    public String getCompileTarget() {
        return this.compileTarget;
    }

    @NonNull
    public List<String> getBootClasspath() {
        return this.bootClasspath;
    }

    @NonNull
    public Map<String, SigningConfig> getSigningConfigs() {
        return this.signingConfigs;
    }

    @NonNull
    public AaptOptions getAaptOptions() {
        return null;
    }
}

