/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.dsl;

import com.android.annotations.NonNull;
import com.android.builder.signing.SigningConfig;
import com.android.prefs.AndroidLocation;
import com.google.common.base.Objects;
import java.io.File;
import java.io.Serializable;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.tooling.BuildException;

public class SigningConfigDsl
extends SigningConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final String name;

    public SigningConfigDsl(@NonNull String name) {
        this.name = name;
        if ("debug".equals(name)) {
            try {
                this.initDebug();
            }
            catch (AndroidLocation.AndroidLocationException e) {
                throw new BuildException("Failed to get default debug keystore location", (Throwable)e);
            }
        }
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public SigningConfigDsl initWith(SigningConfig that) {
        this.setStoreFile(that.getStoreFile());
        this.setStorePassword(that.getStorePassword());
        this.setKeyAlias(that.getKeyAlias());
        this.setKeyPassword(that.getKeyPassword());
        return this;
    }

    @InputFile
    @Optional
    public File getStoreFile() {
        return super.getStoreFile();
    }

    @Input
    public String getStorePassword() {
        return super.getStorePassword();
    }

    @Input
    public String getKeyAlias() {
        return super.getKeyAlias();
    }

    @Input
    public String getKeyPassword() {
        return super.getKeyPassword();
    }

    @Input
    public String getStoreType() {
        return super.getStoreType();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SigningConfigDsl that = (SigningConfigDsl)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("storeFile", (Object)(this.getStoreFile() != null ? this.getStoreFile().getAbsolutePath() : "null")).add("storePassword", (Object)this.getStorePassword()).add("keyAlias", (Object)this.getKeyAlias()).add("keyPassword", (Object)this.getKeyPassword()).add("storeType", (Object)this.getStoreFile()).toString();
    }
}

