/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.spring;

import com.amazonaws.serverless.proxy.spring.AwsSpringWebCustomRuntimeEventLoop;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.web.servlet.context.ServletWebServerApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class AwsSpringWebRuntimeInitializer
implements ApplicationContextInitializer<GenericApplicationContext> {
    private static Log logger = LogFactory.getLog(AwsSpringWebRuntimeInitializer.class);

    public void initialize(GenericApplicationContext context) {
        ConfigurableEnvironment environment = context.getEnvironment();
        if (context instanceof ServletWebServerApplicationContext && this.isCustomRuntime((Environment)environment) && context.getBeanFactory().getBeanNamesForType(AwsSpringWebCustomRuntimeEventLoop.class, false, false).length == 0) {
            context.registerBean(StringUtils.uncapitalize((String)AwsSpringWebCustomRuntimeEventLoop.class.getSimpleName()), SmartLifecycle.class, () -> new AwsSpringWebCustomRuntimeEventLoop((ServletWebServerApplicationContext)context), new BeanDefinitionCustomizer[0]);
        }
    }

    private boolean isCustomRuntime(Environment environment) {
        String handler = environment.getProperty("_HANDLER");
        if (StringUtils.hasText((String)handler)) {
            handler = handler.split(":")[0];
            logger.info((Object)("AWS Handler: " + handler));
            try {
                Thread.currentThread().getContextClassLoader().loadClass(handler);
            }
            catch (Exception e) {
                logger.debug((Object)"Will execute Lambda in Custom Runtime");
                return true;
            }
        }
        return false;
    }
}

