/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.spring;

import com.amazonaws.serverless.proxy.AwsHttpApiV2SecurityContextWriter;
import com.amazonaws.serverless.proxy.AwsProxySecurityContextWriter;
import com.amazonaws.serverless.proxy.SecurityContextWriter;
import com.amazonaws.serverless.proxy.internal.HttpUtils;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletResponse;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletResponseWriter;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.model.AwsProxyResponse;
import com.amazonaws.serverless.proxy.model.HttpApiV2ProxyRequest;
import com.amazonaws.services.lambda.runtime.Context;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.function.serverless.web.ServerlessHttpServletRequest;
import org.springframework.cloud.function.serverless.web.ServerlessMVC;
import org.springframework.util.CollectionUtils;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.MultiValueMapAdapter;
import org.springframework.util.StringUtils;

class AwsSpringHttpProcessingUtils {
    private static Log logger = LogFactory.getLog(AwsSpringHttpProcessingUtils.class);
    private static final int LAMBDA_MAX_REQUEST_DURATION_MINUTES = 15;

    private AwsSpringHttpProcessingUtils() {
    }

    public static AwsProxyResponse processRequest(HttpServletRequest request, ServerlessMVC mvc, AwsProxyHttpServletResponseWriter responseWriter) {
        CountDownLatch latch = new CountDownLatch(1);
        AwsHttpServletResponse response = new AwsHttpServletResponse(request, latch);
        try {
            boolean requestTimedOut;
            mvc.service(request, (HttpServletResponse)response);
            boolean bl = requestTimedOut = !latch.await(15L, TimeUnit.MINUTES);
            if (requestTimedOut) {
                logger.warn((Object)"request timed out after 15 minutes");
            }
            AwsProxyResponse awsResponse = responseWriter.writeResponse(response, null);
            return awsResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }

    public static String extractVersion() {
        try {
            String path = AwsSpringHttpProcessingUtils.class.getProtectionDomain().getCodeSource().getLocation().toString();
            int endIndex = path.lastIndexOf(46);
            if (endIndex < 0) {
                return "UNKNOWN-VERSION";
            }
            int startIndex = path.lastIndexOf("/") + 1;
            return path.substring(startIndex, endIndex).replace("spring-cloud-function-serverless-web-", "");
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Failed to detect version", (Throwable)e);
            }
            return "UNKNOWN-VERSION";
        }
    }

    public static HttpServletRequest generateHttpServletRequest(InputStream jsonRequest, Context lambdaContext, ServletContext servletContext, ObjectMapper mapper) {
        try {
            String text = new String(FileCopyUtils.copyToByteArray((InputStream)jsonRequest), StandardCharsets.UTF_8);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Creating HttpServletRequest from: " + text));
            }
            return AwsSpringHttpProcessingUtils.generateHttpServletRequest(text, lambdaContext, servletContext, mapper);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static HttpServletRequest generateHttpServletRequest(String jsonRequest, Context lambdaContext, ServletContext servletContext, ObjectMapper mapper) {
        Map _request = AwsSpringHttpProcessingUtils.readValue(jsonRequest, Map.class, mapper);
        AwsHttpApiV2SecurityContextWriter securityWriter = "2.0".equals(_request.get("version")) ? new AwsHttpApiV2SecurityContextWriter() : new AwsProxySecurityContextWriter();
        HttpServletRequest httpServletRequest = "2.0".equals(_request.get("version")) ? AwsSpringHttpProcessingUtils.generateRequest2(jsonRequest, lambdaContext, (SecurityContextWriter)securityWriter, mapper, servletContext) : AwsSpringHttpProcessingUtils.generateRequest1(jsonRequest, lambdaContext, (SecurityContextWriter)securityWriter, mapper, servletContext);
        return httpServletRequest;
    }

    private static HttpServletRequest generateRequest1(String request, Context lambdaContext, SecurityContextWriter securityWriter, ObjectMapper mapper, ServletContext servletContext) {
        AwsProxyRequest v1Request = AwsSpringHttpProcessingUtils.readValue(request, AwsProxyRequest.class, mapper);
        ServerlessHttpServletRequest httpRequest = new ServerlessHttpServletRequest(servletContext, v1Request.getHttpMethod(), v1Request.getPath());
        AwsSpringHttpProcessingUtils.populateQueryStringParameters(v1Request.getQueryStringParameters(), httpRequest);
        if (v1Request.getMultiValueQueryStringParameters() != null) {
            MultiValueMapAdapter queryStringParameters = new MultiValueMapAdapter((Map)v1Request.getMultiValueQueryStringParameters());
            queryStringParameters.forEach((k, v) -> httpRequest.setParameter(k, v.toArray(new String[0])));
        }
        if (v1Request.getMultiValueHeaders() != null) {
            MultiValueMapAdapter headers = new MultiValueMapAdapter((Map)v1Request.getMultiValueHeaders());
            httpRequest.setHeaders((MultiValueMap)headers);
        }
        AwsSpringHttpProcessingUtils.populateContentAndContentType(v1Request.getBody(), (String)v1Request.getMultiValueHeaders().getFirst((Object)"Content-Type"), v1Request.isBase64Encoded(), httpRequest);
        if (v1Request.getRequestContext() != null) {
            httpRequest.setAttribute("com.amazonaws.apigateway.request.context", (Object)v1Request.getRequestContext());
            httpRequest.setAttribute("com.amazonaws.alb.request.context", (Object)v1Request.getRequestContext().getElb());
        }
        httpRequest.setAttribute("com.amazonaws.apigateway.stage.variables", (Object)v1Request.getStageVariables());
        httpRequest.setAttribute("com.amazonaws.apigateway.request", (Object)v1Request);
        httpRequest.setAttribute("com.amazonaws.lambda.context", (Object)lambdaContext);
        httpRequest.setAttribute("com.amazonaws.serverless.jaxrs.securityContext", (Object)securityWriter.writeSecurityContext((Object)v1Request, lambdaContext));
        return httpRequest;
    }

    private static HttpServletRequest generateRequest2(String request, Context lambdaContext, SecurityContextWriter securityWriter, ObjectMapper mapper, ServletContext servletContext) {
        HttpApiV2ProxyRequest v2Request = AwsSpringHttpProcessingUtils.readValue(request, HttpApiV2ProxyRequest.class, mapper);
        ServerlessHttpServletRequest httpRequest = new ServerlessHttpServletRequest(servletContext, v2Request.getRequestContext().getHttp().getMethod(), v2Request.getRequestContext().getHttp().getPath());
        AwsSpringHttpProcessingUtils.populateQueryStringParameters(v2Request.getQueryStringParameters(), httpRequest);
        v2Request.getHeaders().forEach((arg_0, arg_1) -> ((ServerlessHttpServletRequest)httpRequest).setHeader(arg_0, arg_1));
        AwsSpringHttpProcessingUtils.populateContentAndContentType(v2Request.getBody(), (String)v2Request.getHeaders().get("Content-Type"), v2Request.isBase64Encoded(), httpRequest);
        httpRequest.setAttribute("com.amazonaws.httpapi.request.context", (Object)v2Request.getRequestContext());
        httpRequest.setAttribute("com.amazonaws.httpapi.stage.variables", (Object)v2Request.getStageVariables());
        httpRequest.setAttribute("com.amazonaws.httpapi.request", (Object)v2Request);
        httpRequest.setAttribute("com.amazonaws.lambda.context", (Object)lambdaContext);
        httpRequest.setAttribute("com.amazonaws.serverless.jaxrs.securityContext", (Object)securityWriter.writeSecurityContext((Object)v2Request, lambdaContext));
        return httpRequest;
    }

    private static void populateQueryStringParameters(Map<String, String> requestParameters, ServerlessHttpServletRequest httpRequest) {
        if (!CollectionUtils.isEmpty(requestParameters)) {
            for (Map.Entry<String, String> entry : requestParameters.entrySet()) {
                httpRequest.setParameter(entry.getKey(), entry.getValue());
            }
        }
    }

    private static <T> T readValue(String json, Class<T> clazz, ObjectMapper mapper) {
        try {
            return (T)mapper.readValue(json, clazz);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static void populateContentAndContentType(String body, String contentType, boolean base64Encoded, ServerlessHttpServletRequest httpRequest) {
        if (StringUtils.hasText((String)body)) {
            httpRequest.setContentType(contentType == null ? "application/json" : contentType);
            if (base64Encoded) {
                httpRequest.setContent(Base64.getMimeDecoder().decode(body));
            } else {
                Charset charseEncoding = HttpUtils.parseCharacterEncoding((String)contentType, (Charset)StandardCharsets.UTF_8);
                httpRequest.setContent(body.getBytes(charseEncoding));
            }
        }
    }
}

