/*
 * Copyright 2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 * with the License. A copy of the License is located at
 *
 * http://aws.amazon.com/apache2.0/
 *
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES
 * OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.serverless.proxy.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown = true)
public class HttpApiV2ProxyRequestContext {
    private String accountId;
    private String apiId;
    private String domainName;
    private String domainPrefix;
    private String requestId;
    private String routeKey;
    private String stage;
    private String time;
    private long timeEpoch;
    private AlbContext elb;

    private HttpApiV2HttpContext http;
    private HttpApiV2AuthorizerMap authorizer;

    public String getAccountId() {
        return accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getApiId() {
        return apiId;
    }

    public void setApiId(String apiId) {
        this.apiId = apiId;
    }

    public String getDomainName() {
        return domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getDomainPrefix() {
        return domainPrefix;
    }

    public void setDomainPrefix(String domainPrefix) {
        this.domainPrefix = domainPrefix;
    }

    public String getRequestId() {
        return requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getRouteKey() {
        return routeKey;
    }

    public void setRouteKey(String routeKey) {
        this.routeKey = routeKey;
    }

    public String getStage() {
        return stage;
    }

    public void setStage(String stage) {
        this.stage = stage;
    }

    public String getTime() {
        return time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public long getTimeEpoch() {
        return timeEpoch;
    }

    public void setTimeEpoch(long timeEpoch) {
        this.timeEpoch = timeEpoch;
    }

    public HttpApiV2HttpContext getHttp() {
        return http;
    }

    public void setHttp(HttpApiV2HttpContext http) {
        this.http = http;
    }

    public HttpApiV2AuthorizerMap getAuthorizer() {
        return authorizer;
    }

    public void setAuthorizer(HttpApiV2AuthorizerMap authorizer) {
        this.authorizer = authorizer;
    }

    public AlbContext getElb() {
        return this.elb;
    }

    public void setElb(AlbContext context) {
        this.elb = context;
    }

    
}
