/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.ws.rs.core.MultivaluedMap;

public class MultiValuedTreeMap<Key, Value>
implements MultivaluedMap<Key, Value>,
Serializable,
Cloneable {
    private static final long serialVersionUID = 42L;
    private final Map<Key, List<Value>> map;

    public MultiValuedTreeMap() {
        this.map = new TreeMap<Key, List<Value>>();
    }

    public MultiValuedTreeMap(Comparator<Key> comparator) {
        this.map = new TreeMap<Key, List<Value>>(comparator);
    }

    public void add(Key key, Value value) {
        List<Value> values = this.findKey(key);
        values.add(value);
    }

    public Value getFirst(Key key) {
        Object values = this.get(key);
        if (values == null || values.size() == 0) {
            return null;
        }
        return (Value)values.get(0);
    }

    public void putSingle(Key key, Value value) {
        List<Value> values = this.findKey(key);
        values.clear();
        values.add(value);
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public Set<Map.Entry<Key, List<Value>>> entrySet() {
        return this.map.entrySet();
    }

    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    public List<Value> get(Object key) {
        return this.map.get(key);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set<Key> keySet() {
        return this.map.keySet();
    }

    public List<Value> put(Key key, List<Value> value) {
        return this.map.put(key, value);
    }

    public void putAll(Map<? extends Key, ? extends List<Value>> t) {
        this.map.putAll(t);
    }

    public List<Value> remove(Object key) {
        return this.map.remove(key);
    }

    public int size() {
        return this.map.size();
    }

    public Collection<List<Value>> values() {
        return this.map.values();
    }

    public void addAll(Key key, Value ... newValues) {
        for (Value value : newValues) {
            this.add(key, value);
        }
    }

    public void addAll(Key key, List<Value> valueList) {
        for (Value value : valueList) {
            this.add(key, value);
        }
    }

    public void addFirst(Key key, Value value) {
        Object values = this.get(key);
        if (values == null) {
            this.add(key, value);
            return;
        }
        values.add(0, value);
    }

    public boolean equalsIgnoreValueOrder(MultivaluedMap<Key, Value> vmap) {
        if (this == vmap) {
            return true;
        }
        if (!this.keySet().equals(vmap.keySet())) {
            return false;
        }
        for (Map.Entry<Key, List<Value>> e : this.entrySet()) {
            List olist = (List)vmap.get(e.getKey());
            if (e.getValue().size() != olist.size()) {
                return false;
            }
            for (Value v : e.getValue()) {
                if (olist.contains(v)) continue;
                return false;
            }
        }
        return true;
    }

    private List<Value> findKey(Key key) {
        ArrayList values = this.get(key);
        if (values == null) {
            values = new ArrayList();
            this.put(key, values);
        }
        return values;
    }

    @SuppressFBWarnings(value={"CN_IDIOM_NO_SUPER_CALL"})
    public MultiValuedTreeMap<Key, Value> clone() {
        MultiValuedTreeMap clone = new MultiValuedTreeMap();
        for (Key key : this.keySet()) {
            Object value = this.get(key);
            ArrayList newValue = new ArrayList(value);
            clone.put(key, newValue);
        }
        return clone;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        String delim = ",";
        for (Key name : this.keySet()) {
            Iterator iterator = this.get(name).iterator();
            while (iterator.hasNext()) {
                Object value = iterator.next();
                result.append(delim);
                if (name == null) {
                    result.append("null");
                } else {
                    result.append(name.toString());
                }
                if (value == null) continue;
                result.append('=');
                result.append(value.toString());
            }
        }
        return "[" + result.toString() + "]";
    }
}

