/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal;

import com.amazonaws.serverless.proxy.internal.LambdaContainerHandler;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SecurityUtils {
    private static Logger log = LoggerFactory.getLogger(SecurityUtils.class);
    private static Set<String> SCHEMES = new HashSet<String>(){
        {
            this.add("http");
            this.add("https");
            this.add("HTTP");
            this.add("HTTPS");
        }
    };
    private static Set<Integer> PORTS = new HashSet<Integer>(){
        {
            this.add(443);
            this.add(80);
            this.add(3000);
        }
    };

    public static boolean isValidPort(String port) {
        if (port == null) {
            return false;
        }
        try {
            int intPort = Integer.parseInt(port);
            return PORTS.contains(intPort);
        }
        catch (NumberFormatException e) {
            log.error("Invalid port parameter: " + SecurityUtils.crlf(port));
            return false;
        }
    }

    public static boolean isValidScheme(String scheme) {
        return SCHEMES.contains(scheme);
    }

    public static boolean isValidHost(String host, String apiId, String region) {
        if (host == null) {
            return false;
        }
        if (host.endsWith(".amazonaws.com")) {
            String defaultHost = apiId + ".execute-api." + region + ".amazonaws.com";
            return host.equals(defaultHost);
        }
        return LambdaContainerHandler.getContainerConfig().getCustomDomainNames().contains(host);
    }

    public static String crlf(String s) {
        return s.replaceAll("[\r\n]", "");
    }

    public static String encode(String s) {
        if (s == null) {
            return null;
        }
        int sz = s.length();
        StringBuffer buffer = new StringBuffer();
        block13: for (int i = 0; i < sz; ++i) {
            char ch = s.charAt(i);
            if (ch > '\u0fff') {
                buffer.append("\\u" + Integer.toHexString(ch).toUpperCase(Locale.ENGLISH));
                continue;
            }
            if (ch > '\u00ff') {
                buffer.append("\\u0" + Integer.toHexString(ch).toUpperCase(Locale.ENGLISH));
                continue;
            }
            if (ch > '\u007f') {
                buffer.append("\\u00" + Integer.toHexString(ch).toUpperCase(Locale.ENGLISH));
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        buffer.append('\\');
                        buffer.append('b');
                        break;
                    }
                    case '\n': {
                        buffer.append('\\');
                        buffer.append('n');
                        break;
                    }
                    case '\t': {
                        buffer.append('\\');
                        buffer.append('t');
                        break;
                    }
                    case '\f': {
                        buffer.append('\\');
                        buffer.append('f');
                        break;
                    }
                    case '\r': {
                        buffer.append('\\');
                        buffer.append('r');
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            buffer.append("\\u00" + Integer.toHexString(ch).toUpperCase(Locale.ENGLISH));
                            break;
                        }
                        buffer.append("\\u000" + Integer.toHexString(ch).toUpperCase(Locale.ENGLISH));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\'': {
                    buffer.append('\'');
                    continue block13;
                }
                case '\"': {
                    buffer.append('\\');
                    buffer.append('\"');
                    continue block13;
                }
                case '\\': {
                    buffer.append('\\');
                    buffer.append('\\');
                    continue block13;
                }
                case '/': {
                    buffer.append('/');
                    continue block13;
                }
                default: {
                    buffer.append(ch);
                }
            }
        }
        return buffer.toString();
    }

    public static String getValidFilePath(String inputPath) {
        return SecurityUtils.getValidFilePath(inputPath, false);
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
    public static String getValidFilePath(String inputPath, boolean isWrite) {
        if (inputPath == null || "".equals(inputPath.trim())) {
            return null;
        }
        String testInputPath = inputPath;
        if (testInputPath.startsWith("file://")) {
            testInputPath = testInputPath.substring(6);
        }
        File f = new File(testInputPath);
        try {
            String canonicalPath = f.getCanonicalPath();
            if (isWrite && canonicalPath.startsWith("/var/task")) {
                throw new IllegalArgumentException("Trying to write to /var/task folder");
            }
            boolean isAllowed = false;
            for (String allowedPath : LambdaContainerHandler.getContainerConfig().getValidFilePaths()) {
                if (!canonicalPath.startsWith(allowedPath)) continue;
                isAllowed = true;
                break;
            }
            if (!isAllowed) {
                throw new IllegalArgumentException("File path not allowed: " + SecurityUtils.encode(canonicalPath));
            }
            return inputPath.startsWith("file://") ? "file://" + canonicalPath : canonicalPath;
        }
        catch (IOException e) {
            log.error("Invalid file path: {}", (Object)SecurityUtils.encode(testInputPath));
            throw new IllegalArgumentException("Invalid file path", e);
        }
    }
}

