/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.xray.model.InsightSummary;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class InsightSummaryMarshaller {
    private static final MarshallingInfo<String> INSIGHTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InsightId").build();
    private static final MarshallingInfo<String> GROUPARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GroupARN").build();
    private static final MarshallingInfo<String> GROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GroupName").build();
    private static final MarshallingInfo<StructuredPojo> ROOTCAUSESERVICEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RootCauseServiceId").build();
    private static final MarshallingInfo<List> CATEGORIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Categories").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> SUMMARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Summary").build();
    private static final MarshallingInfo<StructuredPojo> CLIENTREQUESTIMPACTSTATISTICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClientRequestImpactStatistics").build();
    private static final MarshallingInfo<StructuredPojo> ROOTCAUSESERVICEREQUESTIMPACTSTATISTICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RootCauseServiceRequestImpactStatistics").build();
    private static final MarshallingInfo<List> TOPANOMALOUSSERVICES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TopAnomalousServices").build();
    private static final MarshallingInfo<Date> LASTUPDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastUpdateTime").timestampFormat("unixTimestamp").build();
    private static final InsightSummaryMarshaller instance = new InsightSummaryMarshaller();

    public static InsightSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(InsightSummary insightSummary, ProtocolMarshaller protocolMarshaller) {
        if (insightSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)insightSummary.getInsightId(), INSIGHTID_BINDING);
            protocolMarshaller.marshall((Object)insightSummary.getGroupARN(), GROUPARN_BINDING);
            protocolMarshaller.marshall((Object)insightSummary.getGroupName(), GROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)insightSummary.getRootCauseServiceId(), ROOTCAUSESERVICEID_BINDING);
            protocolMarshaller.marshall(insightSummary.getCategories(), CATEGORIES_BINDING);
            protocolMarshaller.marshall((Object)insightSummary.getState(), STATE_BINDING);
            protocolMarshaller.marshall((Object)insightSummary.getStartTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)insightSummary.getEndTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)insightSummary.getSummary(), SUMMARY_BINDING);
            protocolMarshaller.marshall((Object)insightSummary.getClientRequestImpactStatistics(), CLIENTREQUESTIMPACTSTATISTICS_BINDING);
            protocolMarshaller.marshall((Object)insightSummary.getRootCauseServiceRequestImpactStatistics(), ROOTCAUSESERVICEREQUESTIMPACTSTATISTICS_BINDING);
            protocolMarshaller.marshall(insightSummary.getTopAnomalousServices(), TOPANOMALOUSSERVICES_BINDING);
            protocolMarshaller.marshall((Object)insightSummary.getLastUpdateTime(), LASTUPDATETIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

