/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.workspaces.model.ApplicationResourceAssociation;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeApplicationAssociationsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<ApplicationResourceAssociation> associations;
    private String nextToken;

    public List<ApplicationResourceAssociation> getAssociations() {
        if (this.associations == null) {
            this.associations = new SdkInternalList();
        }
        return this.associations;
    }

    public void setAssociations(Collection<ApplicationResourceAssociation> associations) {
        if (associations == null) {
            this.associations = null;
            return;
        }
        this.associations = new SdkInternalList(associations);
    }

    public DescribeApplicationAssociationsResult withAssociations(ApplicationResourceAssociation ... associations) {
        if (this.associations == null) {
            this.setAssociations((Collection<ApplicationResourceAssociation>)new SdkInternalList(associations.length));
        }
        for (ApplicationResourceAssociation ele : associations) {
            this.associations.add((Object)ele);
        }
        return this;
    }

    public DescribeApplicationAssociationsResult withAssociations(Collection<ApplicationResourceAssociation> associations) {
        this.setAssociations(associations);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public DescribeApplicationAssociationsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAssociations() != null) {
            sb.append("Associations: ").append(this.getAssociations()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationAssociationsResult)) {
            return false;
        }
        DescribeApplicationAssociationsResult other = (DescribeApplicationAssociationsResult)obj;
        if (other.getAssociations() == null ^ this.getAssociations() == null) {
            return false;
        }
        if (other.getAssociations() != null && !other.getAssociations().equals(this.getAssociations())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAssociations() == null ? 0 : this.getAssociations().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public DescribeApplicationAssociationsResult clone() {
        try {
            return (DescribeApplicationAssociationsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

