/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.workmail;

import javax.annotation.Generated;

import com.amazonaws.services.workmail.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonWorkMail}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonWorkMail implements AmazonWorkMail {

    protected AbstractAmazonWorkMail() {
    }

    @Override
    public AssociateDelegateToResourceResult associateDelegateToResource(AssociateDelegateToResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssociateMemberToGroupResult associateMemberToGroup(AssociateMemberToGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AssumeImpersonationRoleResult assumeImpersonationRole(AssumeImpersonationRoleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CancelMailboxExportJobResult cancelMailboxExportJob(CancelMailboxExportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAliasResult createAlias(CreateAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAvailabilityConfigurationResult createAvailabilityConfiguration(CreateAvailabilityConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateGroupResult createGroup(CreateGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateImpersonationRoleResult createImpersonationRole(CreateImpersonationRoleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateMobileDeviceAccessRuleResult createMobileDeviceAccessRule(CreateMobileDeviceAccessRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateOrganizationResult createOrganization(CreateOrganizationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateResourceResult createResource(CreateResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateUserResult createUser(CreateUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAccessControlRuleResult deleteAccessControlRule(DeleteAccessControlRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAliasResult deleteAlias(DeleteAliasRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAvailabilityConfigurationResult deleteAvailabilityConfiguration(DeleteAvailabilityConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteEmailMonitoringConfigurationResult deleteEmailMonitoringConfiguration(DeleteEmailMonitoringConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteGroupResult deleteGroup(DeleteGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteImpersonationRoleResult deleteImpersonationRole(DeleteImpersonationRoleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteMailboxPermissionsResult deleteMailboxPermissions(DeleteMailboxPermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteMobileDeviceAccessOverrideResult deleteMobileDeviceAccessOverride(DeleteMobileDeviceAccessOverrideRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteMobileDeviceAccessRuleResult deleteMobileDeviceAccessRule(DeleteMobileDeviceAccessRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteOrganizationResult deleteOrganization(DeleteOrganizationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteResourceResult deleteResource(DeleteResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRetentionPolicyResult deleteRetentionPolicy(DeleteRetentionPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteUserResult deleteUser(DeleteUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeregisterFromWorkMailResult deregisterFromWorkMail(DeregisterFromWorkMailRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeregisterMailDomainResult deregisterMailDomain(DeregisterMailDomainRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeEmailMonitoringConfigurationResult describeEmailMonitoringConfiguration(DescribeEmailMonitoringConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeGroupResult describeGroup(DescribeGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeInboundDmarcSettingsResult describeInboundDmarcSettings(DescribeInboundDmarcSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeMailboxExportJobResult describeMailboxExportJob(DescribeMailboxExportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeOrganizationResult describeOrganization(DescribeOrganizationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeResourceResult describeResource(DescribeResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeUserResult describeUser(DescribeUserRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateDelegateFromResourceResult disassociateDelegateFromResource(DisassociateDelegateFromResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateMemberFromGroupResult disassociateMemberFromGroup(DisassociateMemberFromGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAccessControlEffectResult getAccessControlEffect(GetAccessControlEffectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetDefaultRetentionPolicyResult getDefaultRetentionPolicy(GetDefaultRetentionPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetImpersonationRoleResult getImpersonationRole(GetImpersonationRoleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetImpersonationRoleEffectResult getImpersonationRoleEffect(GetImpersonationRoleEffectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMailDomainResult getMailDomain(GetMailDomainRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMailboxDetailsResult getMailboxDetails(GetMailboxDetailsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMobileDeviceAccessEffectResult getMobileDeviceAccessEffect(GetMobileDeviceAccessEffectRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMobileDeviceAccessOverrideResult getMobileDeviceAccessOverride(GetMobileDeviceAccessOverrideRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAccessControlRulesResult listAccessControlRules(ListAccessControlRulesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAliasesResult listAliases(ListAliasesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAvailabilityConfigurationsResult listAvailabilityConfigurations(ListAvailabilityConfigurationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListGroupMembersResult listGroupMembers(ListGroupMembersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListGroupsResult listGroups(ListGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListImpersonationRolesResult listImpersonationRoles(ListImpersonationRolesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMailDomainsResult listMailDomains(ListMailDomainsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMailboxExportJobsResult listMailboxExportJobs(ListMailboxExportJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMailboxPermissionsResult listMailboxPermissions(ListMailboxPermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMobileDeviceAccessOverridesResult listMobileDeviceAccessOverrides(ListMobileDeviceAccessOverridesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMobileDeviceAccessRulesResult listMobileDeviceAccessRules(ListMobileDeviceAccessRulesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListOrganizationsResult listOrganizations(ListOrganizationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListResourceDelegatesResult listResourceDelegates(ListResourceDelegatesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListResourcesResult listResources(ListResourcesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListUsersResult listUsers(ListUsersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutAccessControlRuleResult putAccessControlRule(PutAccessControlRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutEmailMonitoringConfigurationResult putEmailMonitoringConfiguration(PutEmailMonitoringConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutInboundDmarcSettingsResult putInboundDmarcSettings(PutInboundDmarcSettingsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutMailboxPermissionsResult putMailboxPermissions(PutMailboxPermissionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutMobileDeviceAccessOverrideResult putMobileDeviceAccessOverride(PutMobileDeviceAccessOverrideRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutRetentionPolicyResult putRetentionPolicy(PutRetentionPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RegisterMailDomainResult registerMailDomain(RegisterMailDomainRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public RegisterToWorkMailResult registerToWorkMail(RegisterToWorkMailRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ResetPasswordResult resetPassword(ResetPasswordRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartMailboxExportJobResult startMailboxExportJob(StartMailboxExportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TestAvailabilityConfigurationResult testAvailabilityConfiguration(TestAvailabilityConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateAvailabilityConfigurationResult updateAvailabilityConfiguration(UpdateAvailabilityConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateDefaultMailDomainResult updateDefaultMailDomain(UpdateDefaultMailDomainRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateImpersonationRoleResult updateImpersonationRole(UpdateImpersonationRoleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateMailboxQuotaResult updateMailboxQuota(UpdateMailboxQuotaRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateMobileDeviceAccessRuleResult updateMobileDeviceAccessRule(UpdateMobileDeviceAccessRuleRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdatePrimaryEmailAddressResult updatePrimaryEmailAddress(UpdatePrimaryEmailAddressRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateResourceResult updateResource(UpdateResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
