/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workmail.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.workmail.model.ImpersonationRoleType;
import com.amazonaws.services.workmail.model.ImpersonationRule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateImpersonationRoleRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String organizationId;
    private String impersonationRoleId;
    private String name;
    private String type;
    private String description;
    private List<ImpersonationRule> rules;

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public UpdateImpersonationRoleRequest withOrganizationId(String organizationId) {
        this.setOrganizationId(organizationId);
        return this;
    }

    public void setImpersonationRoleId(String impersonationRoleId) {
        this.impersonationRoleId = impersonationRoleId;
    }

    public String getImpersonationRoleId() {
        return this.impersonationRoleId;
    }

    public UpdateImpersonationRoleRequest withImpersonationRoleId(String impersonationRoleId) {
        this.setImpersonationRoleId(impersonationRoleId);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public UpdateImpersonationRoleRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public UpdateImpersonationRoleRequest withType(String type) {
        this.setType(type);
        return this;
    }

    public UpdateImpersonationRoleRequest withType(ImpersonationRoleType type) {
        this.type = type.toString();
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public UpdateImpersonationRoleRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<ImpersonationRule> getRules() {
        return this.rules;
    }

    public void setRules(Collection<ImpersonationRule> rules) {
        if (rules == null) {
            this.rules = null;
            return;
        }
        this.rules = new ArrayList<ImpersonationRule>(rules);
    }

    public UpdateImpersonationRoleRequest withRules(ImpersonationRule ... rules) {
        if (this.rules == null) {
            this.setRules(new ArrayList<ImpersonationRule>(rules.length));
        }
        for (ImpersonationRule ele : rules) {
            this.rules.add(ele);
        }
        return this;
    }

    public UpdateImpersonationRoleRequest withRules(Collection<ImpersonationRule> rules) {
        this.setRules(rules);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOrganizationId() != null) {
            sb.append("OrganizationId: ").append(this.getOrganizationId()).append(",");
        }
        if (this.getImpersonationRoleId() != null) {
            sb.append("ImpersonationRoleId: ").append(this.getImpersonationRoleId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getRules() != null) {
            sb.append("Rules: ").append(this.getRules());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateImpersonationRoleRequest)) {
            return false;
        }
        UpdateImpersonationRoleRequest other = (UpdateImpersonationRoleRequest)obj;
        if (other.getOrganizationId() == null ^ this.getOrganizationId() == null) {
            return false;
        }
        if (other.getOrganizationId() != null && !other.getOrganizationId().equals(this.getOrganizationId())) {
            return false;
        }
        if (other.getImpersonationRoleId() == null ^ this.getImpersonationRoleId() == null) {
            return false;
        }
        if (other.getImpersonationRoleId() != null && !other.getImpersonationRoleId().equals(this.getImpersonationRoleId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getRules() == null ^ this.getRules() == null) {
            return false;
        }
        return other.getRules() == null || other.getRules().equals(this.getRules());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOrganizationId() == null ? 0 : this.getOrganizationId().hashCode());
        hashCode = 31 * hashCode + (this.getImpersonationRoleId() == null ? 0 : this.getImpersonationRoleId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getRules() == null ? 0 : this.getRules().hashCode());
        return hashCode;
    }

    public UpdateImpersonationRoleRequest clone() {
        return (UpdateImpersonationRoleRequest)super.clone();
    }
}

