/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.worklink.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/ListWebsiteCertificateAuthorities"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListWebsiteCertificateAuthoritiesResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable,
        Cloneable {

    /**
     * <p>
     * Information about the certificates.
     * </p>
     */
    private java.util.List<WebsiteCaSummary> websiteCertificateAuthorities;
    /**
     * <p>
     * The pagination token used to retrieve the next page of results for this operation. If there are no more pages,
     * this value is null.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * Information about the certificates.
     * </p>
     * 
     * @return Information about the certificates.
     */

    public java.util.List<WebsiteCaSummary> getWebsiteCertificateAuthorities() {
        return websiteCertificateAuthorities;
    }

    /**
     * <p>
     * Information about the certificates.
     * </p>
     * 
     * @param websiteCertificateAuthorities
     *        Information about the certificates.
     */

    public void setWebsiteCertificateAuthorities(java.util.Collection<WebsiteCaSummary> websiteCertificateAuthorities) {
        if (websiteCertificateAuthorities == null) {
            this.websiteCertificateAuthorities = null;
            return;
        }

        this.websiteCertificateAuthorities = new java.util.ArrayList<WebsiteCaSummary>(websiteCertificateAuthorities);
    }

    /**
     * <p>
     * Information about the certificates.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setWebsiteCertificateAuthorities(java.util.Collection)} or
     * {@link #withWebsiteCertificateAuthorities(java.util.Collection)} if you want to override the existing values.
     * </p>
     * 
     * @param websiteCertificateAuthorities
     *        Information about the certificates.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListWebsiteCertificateAuthoritiesResult withWebsiteCertificateAuthorities(WebsiteCaSummary... websiteCertificateAuthorities) {
        if (this.websiteCertificateAuthorities == null) {
            setWebsiteCertificateAuthorities(new java.util.ArrayList<WebsiteCaSummary>(websiteCertificateAuthorities.length));
        }
        for (WebsiteCaSummary ele : websiteCertificateAuthorities) {
            this.websiteCertificateAuthorities.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Information about the certificates.
     * </p>
     * 
     * @param websiteCertificateAuthorities
     *        Information about the certificates.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListWebsiteCertificateAuthoritiesResult withWebsiteCertificateAuthorities(java.util.Collection<WebsiteCaSummary> websiteCertificateAuthorities) {
        setWebsiteCertificateAuthorities(websiteCertificateAuthorities);
        return this;
    }

    /**
     * <p>
     * The pagination token used to retrieve the next page of results for this operation. If there are no more pages,
     * this value is null.
     * </p>
     * 
     * @param nextToken
     *        The pagination token used to retrieve the next page of results for this operation. If there are no more
     *        pages, this value is null.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * The pagination token used to retrieve the next page of results for this operation. If there are no more pages,
     * this value is null.
     * </p>
     * 
     * @return The pagination token used to retrieve the next page of results for this operation. If there are no more
     *         pages, this value is null.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * The pagination token used to retrieve the next page of results for this operation. If there are no more pages,
     * this value is null.
     * </p>
     * 
     * @param nextToken
     *        The pagination token used to retrieve the next page of results for this operation. If there are no more
     *        pages, this value is null.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListWebsiteCertificateAuthoritiesResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getWebsiteCertificateAuthorities() != null)
            sb.append("WebsiteCertificateAuthorities: ").append(getWebsiteCertificateAuthorities()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListWebsiteCertificateAuthoritiesResult == false)
            return false;
        ListWebsiteCertificateAuthoritiesResult other = (ListWebsiteCertificateAuthoritiesResult) obj;
        if (other.getWebsiteCertificateAuthorities() == null ^ this.getWebsiteCertificateAuthorities() == null)
            return false;
        if (other.getWebsiteCertificateAuthorities() != null
                && other.getWebsiteCertificateAuthorities().equals(this.getWebsiteCertificateAuthorities()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getWebsiteCertificateAuthorities() == null) ? 0 : getWebsiteCertificateAuthorities().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListWebsiteCertificateAuthoritiesResult clone() {
        try {
            return (ListWebsiteCertificateAuthoritiesResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
