/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workdocs;

import com.amazonaws.annotation.NotThreadSafe;
import com.amazonaws.services.workdocs.AmazonWorkDocs;
import com.amazonaws.services.workdocs.AmazonWorkDocsClientBuilder;
import com.amazonaws.services.workdocs.ContentManager;

@NotThreadSafe
public class ContentManagerBuilder {
    private AmazonWorkDocs workDocsClient;
    private String authenticationToken;

    public static ContentManagerBuilder standard() {
        return new ContentManagerBuilder();
    }

    public static ContentManager defaultContentManager() {
        return ContentManagerBuilder.standard().build();
    }

    public ContentManagerBuilder withWorkDocsClient(AmazonWorkDocs workDocsClient) {
        this.workDocsClient = workDocsClient;
        return this;
    }

    public final void setWorkDocsClient(AmazonWorkDocs workDocsClient) {
        this.workDocsClient = workDocsClient;
    }

    public final AmazonWorkDocs getWorkDocsClient() {
        return this.workDocsClient;
    }

    public ContentManagerBuilder withAuthenticationToken(String authenticationToken) {
        this.authenticationToken = authenticationToken;
        return this;
    }

    public final void setAuthenticationToken(String authenticationToken) {
        this.authenticationToken = authenticationToken;
    }

    public final String getAuthenticationToken() {
        return this.authenticationToken;
    }

    public ContentManager build() {
        if (this.workDocsClient == null) {
            this.workDocsClient = AmazonWorkDocsClientBuilder.defaultClient();
        }
        return new ContentManager(this);
    }
}

