/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wafv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.wafv2.model.FieldToMatch;
import com.amazonaws.services.wafv2.model.LogScope;
import com.amazonaws.services.wafv2.model.LogType;
import com.amazonaws.services.wafv2.model.LoggingFilter;
import com.amazonaws.services.wafv2.model.transform.LoggingConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LoggingConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String resourceArn;
    private List<String> logDestinationConfigs;
    private List<FieldToMatch> redactedFields;
    private Boolean managedByFirewallManager;
    private LoggingFilter loggingFilter;
    private String logType;
    private String logScope;

    public void setResourceArn(String resourceArn) {
        this.resourceArn = resourceArn;
    }

    public String getResourceArn() {
        return this.resourceArn;
    }

    public LoggingConfiguration withResourceArn(String resourceArn) {
        this.setResourceArn(resourceArn);
        return this;
    }

    public List<String> getLogDestinationConfigs() {
        return this.logDestinationConfigs;
    }

    public void setLogDestinationConfigs(Collection<String> logDestinationConfigs) {
        if (logDestinationConfigs == null) {
            this.logDestinationConfigs = null;
            return;
        }
        this.logDestinationConfigs = new ArrayList<String>(logDestinationConfigs);
    }

    public LoggingConfiguration withLogDestinationConfigs(String ... logDestinationConfigs) {
        if (this.logDestinationConfigs == null) {
            this.setLogDestinationConfigs(new ArrayList<String>(logDestinationConfigs.length));
        }
        for (String ele : logDestinationConfigs) {
            this.logDestinationConfigs.add(ele);
        }
        return this;
    }

    public LoggingConfiguration withLogDestinationConfigs(Collection<String> logDestinationConfigs) {
        this.setLogDestinationConfigs(logDestinationConfigs);
        return this;
    }

    public List<FieldToMatch> getRedactedFields() {
        return this.redactedFields;
    }

    public void setRedactedFields(Collection<FieldToMatch> redactedFields) {
        if (redactedFields == null) {
            this.redactedFields = null;
            return;
        }
        this.redactedFields = new ArrayList<FieldToMatch>(redactedFields);
    }

    public LoggingConfiguration withRedactedFields(FieldToMatch ... redactedFields) {
        if (this.redactedFields == null) {
            this.setRedactedFields(new ArrayList<FieldToMatch>(redactedFields.length));
        }
        for (FieldToMatch ele : redactedFields) {
            this.redactedFields.add(ele);
        }
        return this;
    }

    public LoggingConfiguration withRedactedFields(Collection<FieldToMatch> redactedFields) {
        this.setRedactedFields(redactedFields);
        return this;
    }

    public void setManagedByFirewallManager(Boolean managedByFirewallManager) {
        this.managedByFirewallManager = managedByFirewallManager;
    }

    public Boolean getManagedByFirewallManager() {
        return this.managedByFirewallManager;
    }

    public LoggingConfiguration withManagedByFirewallManager(Boolean managedByFirewallManager) {
        this.setManagedByFirewallManager(managedByFirewallManager);
        return this;
    }

    public Boolean isManagedByFirewallManager() {
        return this.managedByFirewallManager;
    }

    public void setLoggingFilter(LoggingFilter loggingFilter) {
        this.loggingFilter = loggingFilter;
    }

    public LoggingFilter getLoggingFilter() {
        return this.loggingFilter;
    }

    public LoggingConfiguration withLoggingFilter(LoggingFilter loggingFilter) {
        this.setLoggingFilter(loggingFilter);
        return this;
    }

    public void setLogType(String logType) {
        this.logType = logType;
    }

    public String getLogType() {
        return this.logType;
    }

    public LoggingConfiguration withLogType(String logType) {
        this.setLogType(logType);
        return this;
    }

    public LoggingConfiguration withLogType(LogType logType) {
        this.logType = logType.toString();
        return this;
    }

    public void setLogScope(String logScope) {
        this.logScope = logScope;
    }

    public String getLogScope() {
        return this.logScope;
    }

    public LoggingConfiguration withLogScope(String logScope) {
        this.setLogScope(logScope);
        return this;
    }

    public LoggingConfiguration withLogScope(LogScope logScope) {
        this.logScope = logScope.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceArn() != null) {
            sb.append("ResourceArn: ").append(this.getResourceArn()).append(",");
        }
        if (this.getLogDestinationConfigs() != null) {
            sb.append("LogDestinationConfigs: ").append(this.getLogDestinationConfigs()).append(",");
        }
        if (this.getRedactedFields() != null) {
            sb.append("RedactedFields: ").append(this.getRedactedFields()).append(",");
        }
        if (this.getManagedByFirewallManager() != null) {
            sb.append("ManagedByFirewallManager: ").append(this.getManagedByFirewallManager()).append(",");
        }
        if (this.getLoggingFilter() != null) {
            sb.append("LoggingFilter: ").append(this.getLoggingFilter()).append(",");
        }
        if (this.getLogType() != null) {
            sb.append("LogType: ").append(this.getLogType()).append(",");
        }
        if (this.getLogScope() != null) {
            sb.append("LogScope: ").append(this.getLogScope());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingConfiguration)) {
            return false;
        }
        LoggingConfiguration other = (LoggingConfiguration)obj;
        if (other.getResourceArn() == null ^ this.getResourceArn() == null) {
            return false;
        }
        if (other.getResourceArn() != null && !other.getResourceArn().equals(this.getResourceArn())) {
            return false;
        }
        if (other.getLogDestinationConfigs() == null ^ this.getLogDestinationConfigs() == null) {
            return false;
        }
        if (other.getLogDestinationConfigs() != null && !other.getLogDestinationConfigs().equals(this.getLogDestinationConfigs())) {
            return false;
        }
        if (other.getRedactedFields() == null ^ this.getRedactedFields() == null) {
            return false;
        }
        if (other.getRedactedFields() != null && !other.getRedactedFields().equals(this.getRedactedFields())) {
            return false;
        }
        if (other.getManagedByFirewallManager() == null ^ this.getManagedByFirewallManager() == null) {
            return false;
        }
        if (other.getManagedByFirewallManager() != null && !other.getManagedByFirewallManager().equals(this.getManagedByFirewallManager())) {
            return false;
        }
        if (other.getLoggingFilter() == null ^ this.getLoggingFilter() == null) {
            return false;
        }
        if (other.getLoggingFilter() != null && !other.getLoggingFilter().equals(this.getLoggingFilter())) {
            return false;
        }
        if (other.getLogType() == null ^ this.getLogType() == null) {
            return false;
        }
        if (other.getLogType() != null && !other.getLogType().equals(this.getLogType())) {
            return false;
        }
        if (other.getLogScope() == null ^ this.getLogScope() == null) {
            return false;
        }
        return other.getLogScope() == null || other.getLogScope().equals(this.getLogScope());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceArn() == null ? 0 : this.getResourceArn().hashCode());
        hashCode = 31 * hashCode + (this.getLogDestinationConfigs() == null ? 0 : this.getLogDestinationConfigs().hashCode());
        hashCode = 31 * hashCode + (this.getRedactedFields() == null ? 0 : this.getRedactedFields().hashCode());
        hashCode = 31 * hashCode + (this.getManagedByFirewallManager() == null ? 0 : this.getManagedByFirewallManager().hashCode());
        hashCode = 31 * hashCode + (this.getLoggingFilter() == null ? 0 : this.getLoggingFilter().hashCode());
        hashCode = 31 * hashCode + (this.getLogType() == null ? 0 : this.getLogType().hashCode());
        hashCode = 31 * hashCode + (this.getLogScope() == null ? 0 : this.getLogScope().hashCode());
        return hashCode;
    }

    public LoggingConfiguration clone() {
        try {
            return (LoggingConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LoggingConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

