/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wafv2.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.wafv2.model.APIKeySummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListAPIKeysResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextMarker;
    private List<APIKeySummary> aPIKeySummaries;
    private String applicationIntegrationURL;

    public void setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public ListAPIKeysResult withNextMarker(String nextMarker) {
        this.setNextMarker(nextMarker);
        return this;
    }

    public List<APIKeySummary> getAPIKeySummaries() {
        return this.aPIKeySummaries;
    }

    public void setAPIKeySummaries(Collection<APIKeySummary> aPIKeySummaries) {
        if (aPIKeySummaries == null) {
            this.aPIKeySummaries = null;
            return;
        }
        this.aPIKeySummaries = new ArrayList<APIKeySummary>(aPIKeySummaries);
    }

    public ListAPIKeysResult withAPIKeySummaries(APIKeySummary ... aPIKeySummaries) {
        if (this.aPIKeySummaries == null) {
            this.setAPIKeySummaries(new ArrayList<APIKeySummary>(aPIKeySummaries.length));
        }
        for (APIKeySummary ele : aPIKeySummaries) {
            this.aPIKeySummaries.add(ele);
        }
        return this;
    }

    public ListAPIKeysResult withAPIKeySummaries(Collection<APIKeySummary> aPIKeySummaries) {
        this.setAPIKeySummaries(aPIKeySummaries);
        return this;
    }

    public void setApplicationIntegrationURL(String applicationIntegrationURL) {
        this.applicationIntegrationURL = applicationIntegrationURL;
    }

    public String getApplicationIntegrationURL() {
        return this.applicationIntegrationURL;
    }

    public ListAPIKeysResult withApplicationIntegrationURL(String applicationIntegrationURL) {
        this.setApplicationIntegrationURL(applicationIntegrationURL);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextMarker() != null) {
            sb.append("NextMarker: ").append(this.getNextMarker()).append(",");
        }
        if (this.getAPIKeySummaries() != null) {
            sb.append("APIKeySummaries: ").append(this.getAPIKeySummaries()).append(",");
        }
        if (this.getApplicationIntegrationURL() != null) {
            sb.append("ApplicationIntegrationURL: ").append(this.getApplicationIntegrationURL());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAPIKeysResult)) {
            return false;
        }
        ListAPIKeysResult other = (ListAPIKeysResult)obj;
        if (other.getNextMarker() == null ^ this.getNextMarker() == null) {
            return false;
        }
        if (other.getNextMarker() != null && !other.getNextMarker().equals(this.getNextMarker())) {
            return false;
        }
        if (other.getAPIKeySummaries() == null ^ this.getAPIKeySummaries() == null) {
            return false;
        }
        if (other.getAPIKeySummaries() != null && !other.getAPIKeySummaries().equals(this.getAPIKeySummaries())) {
            return false;
        }
        if (other.getApplicationIntegrationURL() == null ^ this.getApplicationIntegrationURL() == null) {
            return false;
        }
        return other.getApplicationIntegrationURL() == null || other.getApplicationIntegrationURL().equals(this.getApplicationIntegrationURL());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextMarker() == null ? 0 : this.getNextMarker().hashCode());
        hashCode = 31 * hashCode + (this.getAPIKeySummaries() == null ? 0 : this.getAPIKeySummaries().hashCode());
        hashCode = 31 * hashCode + (this.getApplicationIntegrationURL() == null ? 0 : this.getApplicationIntegrationURL().hashCode());
        return hashCode;
    }

    public ListAPIKeysResult clone() {
        try {
            return (ListAPIKeysResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

