/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wafv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.wafv2.model.AssociationConfig;
import com.amazonaws.services.wafv2.model.CaptchaConfig;
import com.amazonaws.services.wafv2.model.ChallengeConfig;
import com.amazonaws.services.wafv2.model.CustomResponseBody;
import com.amazonaws.services.wafv2.model.DefaultAction;
import com.amazonaws.services.wafv2.model.Rule;
import com.amazonaws.services.wafv2.model.Scope;
import com.amazonaws.services.wafv2.model.Tag;
import com.amazonaws.services.wafv2.model.VisibilityConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateWebACLRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String scope;
    private DefaultAction defaultAction;
    private String description;
    private List<Rule> rules;
    private VisibilityConfig visibilityConfig;
    private List<Tag> tags;
    private Map<String, CustomResponseBody> customResponseBodies;
    private CaptchaConfig captchaConfig;
    private ChallengeConfig challengeConfig;
    private List<String> tokenDomains;
    private AssociationConfig associationConfig;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateWebACLRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getScope() {
        return this.scope;
    }

    public CreateWebACLRequest withScope(String scope) {
        this.setScope(scope);
        return this;
    }

    public CreateWebACLRequest withScope(Scope scope) {
        this.scope = scope.toString();
        return this;
    }

    public void setDefaultAction(DefaultAction defaultAction) {
        this.defaultAction = defaultAction;
    }

    public DefaultAction getDefaultAction() {
        return this.defaultAction;
    }

    public CreateWebACLRequest withDefaultAction(DefaultAction defaultAction) {
        this.setDefaultAction(defaultAction);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateWebACLRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public void setRules(Collection<Rule> rules) {
        if (rules == null) {
            this.rules = null;
            return;
        }
        this.rules = new ArrayList<Rule>(rules);
    }

    public CreateWebACLRequest withRules(Rule ... rules) {
        if (this.rules == null) {
            this.setRules(new ArrayList<Rule>(rules.length));
        }
        for (Rule ele : rules) {
            this.rules.add(ele);
        }
        return this;
    }

    public CreateWebACLRequest withRules(Collection<Rule> rules) {
        this.setRules(rules);
        return this;
    }

    public void setVisibilityConfig(VisibilityConfig visibilityConfig) {
        this.visibilityConfig = visibilityConfig;
    }

    public VisibilityConfig getVisibilityConfig() {
        return this.visibilityConfig;
    }

    public CreateWebACLRequest withVisibilityConfig(VisibilityConfig visibilityConfig) {
        this.setVisibilityConfig(visibilityConfig);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateWebACLRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateWebACLRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public Map<String, CustomResponseBody> getCustomResponseBodies() {
        return this.customResponseBodies;
    }

    public void setCustomResponseBodies(Map<String, CustomResponseBody> customResponseBodies) {
        this.customResponseBodies = customResponseBodies;
    }

    public CreateWebACLRequest withCustomResponseBodies(Map<String, CustomResponseBody> customResponseBodies) {
        this.setCustomResponseBodies(customResponseBodies);
        return this;
    }

    public CreateWebACLRequest addCustomResponseBodiesEntry(String key, CustomResponseBody value) {
        if (null == this.customResponseBodies) {
            this.customResponseBodies = new HashMap<String, CustomResponseBody>();
        }
        if (this.customResponseBodies.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.customResponseBodies.put(key, value);
        return this;
    }

    public CreateWebACLRequest clearCustomResponseBodiesEntries() {
        this.customResponseBodies = null;
        return this;
    }

    public void setCaptchaConfig(CaptchaConfig captchaConfig) {
        this.captchaConfig = captchaConfig;
    }

    public CaptchaConfig getCaptchaConfig() {
        return this.captchaConfig;
    }

    public CreateWebACLRequest withCaptchaConfig(CaptchaConfig captchaConfig) {
        this.setCaptchaConfig(captchaConfig);
        return this;
    }

    public void setChallengeConfig(ChallengeConfig challengeConfig) {
        this.challengeConfig = challengeConfig;
    }

    public ChallengeConfig getChallengeConfig() {
        return this.challengeConfig;
    }

    public CreateWebACLRequest withChallengeConfig(ChallengeConfig challengeConfig) {
        this.setChallengeConfig(challengeConfig);
        return this;
    }

    public List<String> getTokenDomains() {
        return this.tokenDomains;
    }

    public void setTokenDomains(Collection<String> tokenDomains) {
        if (tokenDomains == null) {
            this.tokenDomains = null;
            return;
        }
        this.tokenDomains = new ArrayList<String>(tokenDomains);
    }

    public CreateWebACLRequest withTokenDomains(String ... tokenDomains) {
        if (this.tokenDomains == null) {
            this.setTokenDomains(new ArrayList<String>(tokenDomains.length));
        }
        for (String ele : tokenDomains) {
            this.tokenDomains.add(ele);
        }
        return this;
    }

    public CreateWebACLRequest withTokenDomains(Collection<String> tokenDomains) {
        this.setTokenDomains(tokenDomains);
        return this;
    }

    public void setAssociationConfig(AssociationConfig associationConfig) {
        this.associationConfig = associationConfig;
    }

    public AssociationConfig getAssociationConfig() {
        return this.associationConfig;
    }

    public CreateWebACLRequest withAssociationConfig(AssociationConfig associationConfig) {
        this.setAssociationConfig(associationConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getScope() != null) {
            sb.append("Scope: ").append(this.getScope()).append(",");
        }
        if (this.getDefaultAction() != null) {
            sb.append("DefaultAction: ").append(this.getDefaultAction()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getRules() != null) {
            sb.append("Rules: ").append(this.getRules()).append(",");
        }
        if (this.getVisibilityConfig() != null) {
            sb.append("VisibilityConfig: ").append(this.getVisibilityConfig()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getCustomResponseBodies() != null) {
            sb.append("CustomResponseBodies: ").append(this.getCustomResponseBodies()).append(",");
        }
        if (this.getCaptchaConfig() != null) {
            sb.append("CaptchaConfig: ").append(this.getCaptchaConfig()).append(",");
        }
        if (this.getChallengeConfig() != null) {
            sb.append("ChallengeConfig: ").append(this.getChallengeConfig()).append(",");
        }
        if (this.getTokenDomains() != null) {
            sb.append("TokenDomains: ").append(this.getTokenDomains()).append(",");
        }
        if (this.getAssociationConfig() != null) {
            sb.append("AssociationConfig: ").append(this.getAssociationConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWebACLRequest)) {
            return false;
        }
        CreateWebACLRequest other = (CreateWebACLRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getScope() == null ^ this.getScope() == null) {
            return false;
        }
        if (other.getScope() != null && !other.getScope().equals(this.getScope())) {
            return false;
        }
        if (other.getDefaultAction() == null ^ this.getDefaultAction() == null) {
            return false;
        }
        if (other.getDefaultAction() != null && !other.getDefaultAction().equals(this.getDefaultAction())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getRules() == null ^ this.getRules() == null) {
            return false;
        }
        if (other.getRules() != null && !other.getRules().equals(this.getRules())) {
            return false;
        }
        if (other.getVisibilityConfig() == null ^ this.getVisibilityConfig() == null) {
            return false;
        }
        if (other.getVisibilityConfig() != null && !other.getVisibilityConfig().equals(this.getVisibilityConfig())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getCustomResponseBodies() == null ^ this.getCustomResponseBodies() == null) {
            return false;
        }
        if (other.getCustomResponseBodies() != null && !other.getCustomResponseBodies().equals(this.getCustomResponseBodies())) {
            return false;
        }
        if (other.getCaptchaConfig() == null ^ this.getCaptchaConfig() == null) {
            return false;
        }
        if (other.getCaptchaConfig() != null && !other.getCaptchaConfig().equals(this.getCaptchaConfig())) {
            return false;
        }
        if (other.getChallengeConfig() == null ^ this.getChallengeConfig() == null) {
            return false;
        }
        if (other.getChallengeConfig() != null && !other.getChallengeConfig().equals(this.getChallengeConfig())) {
            return false;
        }
        if (other.getTokenDomains() == null ^ this.getTokenDomains() == null) {
            return false;
        }
        if (other.getTokenDomains() != null && !other.getTokenDomains().equals(this.getTokenDomains())) {
            return false;
        }
        if (other.getAssociationConfig() == null ^ this.getAssociationConfig() == null) {
            return false;
        }
        return other.getAssociationConfig() == null || other.getAssociationConfig().equals(this.getAssociationConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getScope() == null ? 0 : this.getScope().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultAction() == null ? 0 : this.getDefaultAction().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getRules() == null ? 0 : this.getRules().hashCode());
        hashCode = 31 * hashCode + (this.getVisibilityConfig() == null ? 0 : this.getVisibilityConfig().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getCustomResponseBodies() == null ? 0 : this.getCustomResponseBodies().hashCode());
        hashCode = 31 * hashCode + (this.getCaptchaConfig() == null ? 0 : this.getCaptchaConfig().hashCode());
        hashCode = 31 * hashCode + (this.getChallengeConfig() == null ? 0 : this.getChallengeConfig().hashCode());
        hashCode = 31 * hashCode + (this.getTokenDomains() == null ? 0 : this.getTokenDomains().hashCode());
        hashCode = 31 * hashCode + (this.getAssociationConfig() == null ? 0 : this.getAssociationConfig().hashCode());
        return hashCode;
    }

    public CreateWebACLRequest clone() {
        return (CreateWebACLRequest)super.clone();
    }
}

