/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.waf.model.Tag;
import com.amazonaws.services.waf.model.WafAction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateWebACLRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String metricName;
    private WafAction defaultAction;
    private String changeToken;
    private List<Tag> tags;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateWebACLRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public CreateWebACLRequest withMetricName(String metricName) {
        this.setMetricName(metricName);
        return this;
    }

    public void setDefaultAction(WafAction defaultAction) {
        this.defaultAction = defaultAction;
    }

    public WafAction getDefaultAction() {
        return this.defaultAction;
    }

    public CreateWebACLRequest withDefaultAction(WafAction defaultAction) {
        this.setDefaultAction(defaultAction);
        return this;
    }

    public void setChangeToken(String changeToken) {
        this.changeToken = changeToken;
    }

    public String getChangeToken() {
        return this.changeToken;
    }

    public CreateWebACLRequest withChangeToken(String changeToken) {
        this.setChangeToken(changeToken);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateWebACLRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateWebACLRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getMetricName() != null) {
            sb.append("MetricName: ").append(this.getMetricName()).append(",");
        }
        if (this.getDefaultAction() != null) {
            sb.append("DefaultAction: ").append(this.getDefaultAction()).append(",");
        }
        if (this.getChangeToken() != null) {
            sb.append("ChangeToken: ").append(this.getChangeToken()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWebACLRequest)) {
            return false;
        }
        CreateWebACLRequest other = (CreateWebACLRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getMetricName() == null ^ this.getMetricName() == null) {
            return false;
        }
        if (other.getMetricName() != null && !other.getMetricName().equals(this.getMetricName())) {
            return false;
        }
        if (other.getDefaultAction() == null ^ this.getDefaultAction() == null) {
            return false;
        }
        if (other.getDefaultAction() != null && !other.getDefaultAction().equals(this.getDefaultAction())) {
            return false;
        }
        if (other.getChangeToken() == null ^ this.getChangeToken() == null) {
            return false;
        }
        if (other.getChangeToken() != null && !other.getChangeToken().equals(this.getChangeToken())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getMetricName() == null ? 0 : this.getMetricName().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultAction() == null ? 0 : this.getDefaultAction().hashCode());
        hashCode = 31 * hashCode + (this.getChangeToken() == null ? 0 : this.getChangeToken().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateWebACLRequest clone() {
        return (CreateWebACLRequest)super.clone();
    }
}

