/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transfer.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.transfer.model.ListedProfile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListProfilesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<ListedProfile> profiles;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListProfilesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<ListedProfile> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(Collection<ListedProfile> profiles) {
        if (profiles == null) {
            this.profiles = null;
            return;
        }
        this.profiles = new ArrayList<ListedProfile>(profiles);
    }

    public ListProfilesResult withProfiles(ListedProfile ... profiles) {
        if (this.profiles == null) {
            this.setProfiles(new ArrayList<ListedProfile>(profiles.length));
        }
        for (ListedProfile ele : profiles) {
            this.profiles.add(ele);
        }
        return this;
    }

    public ListProfilesResult withProfiles(Collection<ListedProfile> profiles) {
        this.setProfiles(profiles);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getProfiles() != null) {
            sb.append("Profiles: ").append(this.getProfiles());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProfilesResult)) {
            return false;
        }
        ListProfilesResult other = (ListProfilesResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getProfiles() == null ^ this.getProfiles() == null) {
            return false;
        }
        return other.getProfiles() == null || other.getProfiles().equals(this.getProfiles());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getProfiles() == null ? 0 : this.getProfiles().hashCode());
        return hashCode;
    }

    public ListProfilesResult clone() {
        try {
            return (ListProfilesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

