/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transfer.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.transfer.model.S3InputFileLocation;

@SdkInternalApi
public class S3InputFileLocationMarshaller {
    private static final MarshallingInfo<String> BUCKET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Bucket").build();
    private static final MarshallingInfo<String> KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Key").build();
    private static final S3InputFileLocationMarshaller instance = new S3InputFileLocationMarshaller();

    public static S3InputFileLocationMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3InputFileLocation s3InputFileLocation, ProtocolMarshaller protocolMarshaller) {
        if (s3InputFileLocation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3InputFileLocation.getBucket(), BUCKET_BINDING);
            protocolMarshaller.marshall((Object)s3InputFileLocation.getKey(), KEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

