/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transcribe.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.transcribe.model.Media;
import com.amazonaws.services.transcribe.model.MedicalScribeChannelDefinition;
import com.amazonaws.services.transcribe.model.MedicalScribeSettings;
import com.amazonaws.services.transcribe.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StartMedicalScribeJobRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String medicalScribeJobName;
    private Media media;
    private String outputBucketName;
    private String outputEncryptionKMSKeyId;
    private Map<String, String> kMSEncryptionContext;
    private String dataAccessRoleArn;
    private MedicalScribeSettings settings;
    private List<MedicalScribeChannelDefinition> channelDefinitions;
    private List<Tag> tags;

    public void setMedicalScribeJobName(String medicalScribeJobName) {
        this.medicalScribeJobName = medicalScribeJobName;
    }

    public String getMedicalScribeJobName() {
        return this.medicalScribeJobName;
    }

    public StartMedicalScribeJobRequest withMedicalScribeJobName(String medicalScribeJobName) {
        this.setMedicalScribeJobName(medicalScribeJobName);
        return this;
    }

    public void setMedia(Media media) {
        this.media = media;
    }

    public Media getMedia() {
        return this.media;
    }

    public StartMedicalScribeJobRequest withMedia(Media media) {
        this.setMedia(media);
        return this;
    }

    public void setOutputBucketName(String outputBucketName) {
        this.outputBucketName = outputBucketName;
    }

    public String getOutputBucketName() {
        return this.outputBucketName;
    }

    public StartMedicalScribeJobRequest withOutputBucketName(String outputBucketName) {
        this.setOutputBucketName(outputBucketName);
        return this;
    }

    public void setOutputEncryptionKMSKeyId(String outputEncryptionKMSKeyId) {
        this.outputEncryptionKMSKeyId = outputEncryptionKMSKeyId;
    }

    public String getOutputEncryptionKMSKeyId() {
        return this.outputEncryptionKMSKeyId;
    }

    public StartMedicalScribeJobRequest withOutputEncryptionKMSKeyId(String outputEncryptionKMSKeyId) {
        this.setOutputEncryptionKMSKeyId(outputEncryptionKMSKeyId);
        return this;
    }

    public Map<String, String> getKMSEncryptionContext() {
        return this.kMSEncryptionContext;
    }

    public void setKMSEncryptionContext(Map<String, String> kMSEncryptionContext) {
        this.kMSEncryptionContext = kMSEncryptionContext;
    }

    public StartMedicalScribeJobRequest withKMSEncryptionContext(Map<String, String> kMSEncryptionContext) {
        this.setKMSEncryptionContext(kMSEncryptionContext);
        return this;
    }

    public StartMedicalScribeJobRequest addKMSEncryptionContextEntry(String key, String value) {
        if (null == this.kMSEncryptionContext) {
            this.kMSEncryptionContext = new HashMap<String, String>();
        }
        if (this.kMSEncryptionContext.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.kMSEncryptionContext.put(key, value);
        return this;
    }

    public StartMedicalScribeJobRequest clearKMSEncryptionContextEntries() {
        this.kMSEncryptionContext = null;
        return this;
    }

    public void setDataAccessRoleArn(String dataAccessRoleArn) {
        this.dataAccessRoleArn = dataAccessRoleArn;
    }

    public String getDataAccessRoleArn() {
        return this.dataAccessRoleArn;
    }

    public StartMedicalScribeJobRequest withDataAccessRoleArn(String dataAccessRoleArn) {
        this.setDataAccessRoleArn(dataAccessRoleArn);
        return this;
    }

    public void setSettings(MedicalScribeSettings settings) {
        this.settings = settings;
    }

    public MedicalScribeSettings getSettings() {
        return this.settings;
    }

    public StartMedicalScribeJobRequest withSettings(MedicalScribeSettings settings) {
        this.setSettings(settings);
        return this;
    }

    public List<MedicalScribeChannelDefinition> getChannelDefinitions() {
        return this.channelDefinitions;
    }

    public void setChannelDefinitions(Collection<MedicalScribeChannelDefinition> channelDefinitions) {
        if (channelDefinitions == null) {
            this.channelDefinitions = null;
            return;
        }
        this.channelDefinitions = new ArrayList<MedicalScribeChannelDefinition>(channelDefinitions);
    }

    public StartMedicalScribeJobRequest withChannelDefinitions(MedicalScribeChannelDefinition ... channelDefinitions) {
        if (this.channelDefinitions == null) {
            this.setChannelDefinitions(new ArrayList<MedicalScribeChannelDefinition>(channelDefinitions.length));
        }
        for (MedicalScribeChannelDefinition ele : channelDefinitions) {
            this.channelDefinitions.add(ele);
        }
        return this;
    }

    public StartMedicalScribeJobRequest withChannelDefinitions(Collection<MedicalScribeChannelDefinition> channelDefinitions) {
        this.setChannelDefinitions(channelDefinitions);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public StartMedicalScribeJobRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public StartMedicalScribeJobRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMedicalScribeJobName() != null) {
            sb.append("MedicalScribeJobName: ").append(this.getMedicalScribeJobName()).append(",");
        }
        if (this.getMedia() != null) {
            sb.append("Media: ").append(this.getMedia()).append(",");
        }
        if (this.getOutputBucketName() != null) {
            sb.append("OutputBucketName: ").append(this.getOutputBucketName()).append(",");
        }
        if (this.getOutputEncryptionKMSKeyId() != null) {
            sb.append("OutputEncryptionKMSKeyId: ").append(this.getOutputEncryptionKMSKeyId()).append(",");
        }
        if (this.getKMSEncryptionContext() != null) {
            sb.append("KMSEncryptionContext: ").append(this.getKMSEncryptionContext()).append(",");
        }
        if (this.getDataAccessRoleArn() != null) {
            sb.append("DataAccessRoleArn: ").append(this.getDataAccessRoleArn()).append(",");
        }
        if (this.getSettings() != null) {
            sb.append("Settings: ").append(this.getSettings()).append(",");
        }
        if (this.getChannelDefinitions() != null) {
            sb.append("ChannelDefinitions: ").append(this.getChannelDefinitions()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMedicalScribeJobRequest)) {
            return false;
        }
        StartMedicalScribeJobRequest other = (StartMedicalScribeJobRequest)obj;
        if (other.getMedicalScribeJobName() == null ^ this.getMedicalScribeJobName() == null) {
            return false;
        }
        if (other.getMedicalScribeJobName() != null && !other.getMedicalScribeJobName().equals(this.getMedicalScribeJobName())) {
            return false;
        }
        if (other.getMedia() == null ^ this.getMedia() == null) {
            return false;
        }
        if (other.getMedia() != null && !other.getMedia().equals(this.getMedia())) {
            return false;
        }
        if (other.getOutputBucketName() == null ^ this.getOutputBucketName() == null) {
            return false;
        }
        if (other.getOutputBucketName() != null && !other.getOutputBucketName().equals(this.getOutputBucketName())) {
            return false;
        }
        if (other.getOutputEncryptionKMSKeyId() == null ^ this.getOutputEncryptionKMSKeyId() == null) {
            return false;
        }
        if (other.getOutputEncryptionKMSKeyId() != null && !other.getOutputEncryptionKMSKeyId().equals(this.getOutputEncryptionKMSKeyId())) {
            return false;
        }
        if (other.getKMSEncryptionContext() == null ^ this.getKMSEncryptionContext() == null) {
            return false;
        }
        if (other.getKMSEncryptionContext() != null && !other.getKMSEncryptionContext().equals(this.getKMSEncryptionContext())) {
            return false;
        }
        if (other.getDataAccessRoleArn() == null ^ this.getDataAccessRoleArn() == null) {
            return false;
        }
        if (other.getDataAccessRoleArn() != null && !other.getDataAccessRoleArn().equals(this.getDataAccessRoleArn())) {
            return false;
        }
        if (other.getSettings() == null ^ this.getSettings() == null) {
            return false;
        }
        if (other.getSettings() != null && !other.getSettings().equals(this.getSettings())) {
            return false;
        }
        if (other.getChannelDefinitions() == null ^ this.getChannelDefinitions() == null) {
            return false;
        }
        if (other.getChannelDefinitions() != null && !other.getChannelDefinitions().equals(this.getChannelDefinitions())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMedicalScribeJobName() == null ? 0 : this.getMedicalScribeJobName().hashCode());
        hashCode = 31 * hashCode + (this.getMedia() == null ? 0 : this.getMedia().hashCode());
        hashCode = 31 * hashCode + (this.getOutputBucketName() == null ? 0 : this.getOutputBucketName().hashCode());
        hashCode = 31 * hashCode + (this.getOutputEncryptionKMSKeyId() == null ? 0 : this.getOutputEncryptionKMSKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getKMSEncryptionContext() == null ? 0 : this.getKMSEncryptionContext().hashCode());
        hashCode = 31 * hashCode + (this.getDataAccessRoleArn() == null ? 0 : this.getDataAccessRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getSettings() == null ? 0 : this.getSettings().hashCode());
        hashCode = 31 * hashCode + (this.getChannelDefinitions() == null ? 0 : this.getChannelDefinitions().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public StartMedicalScribeJobRequest clone() {
        return (StartMedicalScribeJobRequest)super.clone();
    }
}

