/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.timestreamquery.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.timestreamquery.model.ParameterMapping;
import com.amazonaws.services.timestreamquery.model.SelectColumn;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PrepareQueryResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String queryString;
    private List<SelectColumn> columns;
    private List<ParameterMapping> parameters;

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public PrepareQueryResult withQueryString(String queryString) {
        this.setQueryString(queryString);
        return this;
    }

    public List<SelectColumn> getColumns() {
        return this.columns;
    }

    public void setColumns(Collection<SelectColumn> columns) {
        if (columns == null) {
            this.columns = null;
            return;
        }
        this.columns = new ArrayList<SelectColumn>(columns);
    }

    public PrepareQueryResult withColumns(SelectColumn ... columns) {
        if (this.columns == null) {
            this.setColumns(new ArrayList<SelectColumn>(columns.length));
        }
        for (SelectColumn ele : columns) {
            this.columns.add(ele);
        }
        return this;
    }

    public PrepareQueryResult withColumns(Collection<SelectColumn> columns) {
        this.setColumns(columns);
        return this;
    }

    public List<ParameterMapping> getParameters() {
        return this.parameters;
    }

    public void setParameters(Collection<ParameterMapping> parameters) {
        if (parameters == null) {
            this.parameters = null;
            return;
        }
        this.parameters = new ArrayList<ParameterMapping>(parameters);
    }

    public PrepareQueryResult withParameters(ParameterMapping ... parameters) {
        if (this.parameters == null) {
            this.setParameters(new ArrayList<ParameterMapping>(parameters.length));
        }
        for (ParameterMapping ele : parameters) {
            this.parameters.add(ele);
        }
        return this;
    }

    public PrepareQueryResult withParameters(Collection<ParameterMapping> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getQueryString() != null) {
            sb.append("QueryString: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getColumns() != null) {
            sb.append("Columns: ").append(this.getColumns()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrepareQueryResult)) {
            return false;
        }
        PrepareQueryResult other = (PrepareQueryResult)obj;
        if (other.getQueryString() == null ^ this.getQueryString() == null) {
            return false;
        }
        if (other.getQueryString() != null && !other.getQueryString().equals(this.getQueryString())) {
            return false;
        }
        if (other.getColumns() == null ^ this.getColumns() == null) {
            return false;
        }
        if (other.getColumns() != null && !other.getColumns().equals(this.getColumns())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        return other.getParameters() == null || other.getParameters().equals(this.getParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getQueryString() == null ? 0 : this.getQueryString().hashCode());
        hashCode = 31 * hashCode + (this.getColumns() == null ? 0 : this.getColumns().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        return hashCode;
    }

    public PrepareQueryResult clone() {
        try {
            return (PrepareQueryResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

