/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.textract.model.FeatureType;
import com.amazonaws.services.textract.model.transform.AdapterOverviewMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class AdapterOverview
implements Serializable,
Cloneable,
StructuredPojo {
    private String adapterId;
    private String adapterName;
    private Date creationTime;
    private List<String> featureTypes;

    public void setAdapterId(String adapterId) {
        this.adapterId = adapterId;
    }

    public String getAdapterId() {
        return this.adapterId;
    }

    public AdapterOverview withAdapterId(String adapterId) {
        this.setAdapterId(adapterId);
        return this;
    }

    public void setAdapterName(String adapterName) {
        this.adapterName = adapterName;
    }

    public String getAdapterName() {
        return this.adapterName;
    }

    public AdapterOverview withAdapterName(String adapterName) {
        this.setAdapterName(adapterName);
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public AdapterOverview withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public List<String> getFeatureTypes() {
        return this.featureTypes;
    }

    public void setFeatureTypes(Collection<String> featureTypes) {
        if (featureTypes == null) {
            this.featureTypes = null;
            return;
        }
        this.featureTypes = new ArrayList<String>(featureTypes);
    }

    public AdapterOverview withFeatureTypes(String ... featureTypes) {
        if (this.featureTypes == null) {
            this.setFeatureTypes(new ArrayList<String>(featureTypes.length));
        }
        for (String ele : featureTypes) {
            this.featureTypes.add(ele);
        }
        return this;
    }

    public AdapterOverview withFeatureTypes(Collection<String> featureTypes) {
        this.setFeatureTypes(featureTypes);
        return this;
    }

    public AdapterOverview withFeatureTypes(FeatureType ... featureTypes) {
        ArrayList<String> featureTypesCopy = new ArrayList<String>(featureTypes.length);
        for (FeatureType value : featureTypes) {
            featureTypesCopy.add(value.toString());
        }
        if (this.getFeatureTypes() == null) {
            this.setFeatureTypes(featureTypesCopy);
        } else {
            this.getFeatureTypes().addAll(featureTypesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAdapterId() != null) {
            sb.append("AdapterId: ").append(this.getAdapterId()).append(",");
        }
        if (this.getAdapterName() != null) {
            sb.append("AdapterName: ").append(this.getAdapterName()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getFeatureTypes() != null) {
            sb.append("FeatureTypes: ").append(this.getFeatureTypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdapterOverview)) {
            return false;
        }
        AdapterOverview other = (AdapterOverview)obj;
        if (other.getAdapterId() == null ^ this.getAdapterId() == null) {
            return false;
        }
        if (other.getAdapterId() != null && !other.getAdapterId().equals(this.getAdapterId())) {
            return false;
        }
        if (other.getAdapterName() == null ^ this.getAdapterName() == null) {
            return false;
        }
        if (other.getAdapterName() != null && !other.getAdapterName().equals(this.getAdapterName())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getFeatureTypes() == null ^ this.getFeatureTypes() == null) {
            return false;
        }
        return other.getFeatureTypes() == null || other.getFeatureTypes().equals(this.getFeatureTypes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAdapterId() == null ? 0 : this.getAdapterId().hashCode());
        hashCode = 31 * hashCode + (this.getAdapterName() == null ? 0 : this.getAdapterName().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getFeatureTypes() == null ? 0 : this.getFeatureTypes().hashCode());
        return hashCode;
    }

    public AdapterOverview clone() {
        try {
            return (AdapterOverview)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AdapterOverviewMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

