/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.builder.states;

import com.amazonaws.services.stepfunctions.builder.internal.Buildable;
import com.amazonaws.services.stepfunctions.builder.states.State;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Branch {
    @JsonProperty(value="StartAt")
    private final String startAt;
    @JsonProperty(value="Comment")
    private final String comment;
    @JsonProperty(value="States")
    private final Map<String, State> states;

    private Branch(Builder builder) {
        this.startAt = builder.startAt;
        this.comment = builder.comment;
        this.states = Buildable.Utils.build(builder.stateBuilders);
    }

    public String getStartAt() {
        return this.startAt;
    }

    public String getComment() {
        return this.comment;
    }

    public Map<String, State> getStates() {
        return this.states;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements Buildable<Branch> {
        @JsonProperty(value="StartAt")
        private String startAt;
        @JsonProperty(value="Comment")
        private String comment;
        @JsonProperty(value="States")
        private Map<String, State.Builder> stateBuilders = new LinkedHashMap<String, State.Builder>();

        private Builder() {
        }

        public Builder startAt(String startAt) {
            this.startAt = startAt;
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder state(String stateName, State.Builder stateBuilder) {
            this.stateBuilders.put(stateName, stateBuilder);
            return this;
        }

        @Override
        public Branch build() {
            return new Branch(this);
        }
    }
}

