/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.stepfunctions.builder.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public interface Buildable<T> {
    public T build();

    public static class Utils {
        private Utils() {
        }

        public static <K, T> Map<K, T> build(Map<K, ? extends Buildable<T>> buildableMap) {
            LinkedHashMap<K, T> builtMap = new LinkedHashMap<K, T>(buildableMap.size());
            for (Map.Entry<K, Buildable<T>> entry : buildableMap.entrySet()) {
                builtMap.put(entry.getKey(), entry.getValue().build());
            }
            return Collections.unmodifiableMap(builtMap);
        }

        public static <T> List<T> build(List<? extends Buildable<T>> buildableList) {
            ArrayList<T> builtList = new ArrayList<T>(buildableList.size());
            for (Buildable<T> buildable : buildableList) {
                builtList.add(buildable.build());
            }
            return Collections.unmodifiableList(builtList);
        }
    }
}

