/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssooidc.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RegisterClientRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clientName;
    private String clientType;
    private List<String> scopes;
    private List<String> redirectUris;
    private List<String> grantTypes;
    private String issuerUrl;
    private String entitledApplicationArn;

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getClientName() {
        return this.clientName;
    }

    public RegisterClientRequest withClientName(String clientName) {
        this.setClientName(clientName);
        return this;
    }

    public void setClientType(String clientType) {
        this.clientType = clientType;
    }

    public String getClientType() {
        return this.clientType;
    }

    public RegisterClientRequest withClientType(String clientType) {
        this.setClientType(clientType);
        return this;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(Collection<String> scopes) {
        if (scopes == null) {
            this.scopes = null;
            return;
        }
        this.scopes = new ArrayList<String>(scopes);
    }

    public RegisterClientRequest withScopes(String ... scopes) {
        if (this.scopes == null) {
            this.setScopes(new ArrayList<String>(scopes.length));
        }
        for (String ele : scopes) {
            this.scopes.add(ele);
        }
        return this;
    }

    public RegisterClientRequest withScopes(Collection<String> scopes) {
        this.setScopes(scopes);
        return this;
    }

    public List<String> getRedirectUris() {
        return this.redirectUris;
    }

    public void setRedirectUris(Collection<String> redirectUris) {
        if (redirectUris == null) {
            this.redirectUris = null;
            return;
        }
        this.redirectUris = new ArrayList<String>(redirectUris);
    }

    public RegisterClientRequest withRedirectUris(String ... redirectUris) {
        if (this.redirectUris == null) {
            this.setRedirectUris(new ArrayList<String>(redirectUris.length));
        }
        for (String ele : redirectUris) {
            this.redirectUris.add(ele);
        }
        return this;
    }

    public RegisterClientRequest withRedirectUris(Collection<String> redirectUris) {
        this.setRedirectUris(redirectUris);
        return this;
    }

    public List<String> getGrantTypes() {
        return this.grantTypes;
    }

    public void setGrantTypes(Collection<String> grantTypes) {
        if (grantTypes == null) {
            this.grantTypes = null;
            return;
        }
        this.grantTypes = new ArrayList<String>(grantTypes);
    }

    public RegisterClientRequest withGrantTypes(String ... grantTypes) {
        if (this.grantTypes == null) {
            this.setGrantTypes(new ArrayList<String>(grantTypes.length));
        }
        for (String ele : grantTypes) {
            this.grantTypes.add(ele);
        }
        return this;
    }

    public RegisterClientRequest withGrantTypes(Collection<String> grantTypes) {
        this.setGrantTypes(grantTypes);
        return this;
    }

    public void setIssuerUrl(String issuerUrl) {
        this.issuerUrl = issuerUrl;
    }

    public String getIssuerUrl() {
        return this.issuerUrl;
    }

    public RegisterClientRequest withIssuerUrl(String issuerUrl) {
        this.setIssuerUrl(issuerUrl);
        return this;
    }

    public void setEntitledApplicationArn(String entitledApplicationArn) {
        this.entitledApplicationArn = entitledApplicationArn;
    }

    public String getEntitledApplicationArn() {
        return this.entitledApplicationArn;
    }

    public RegisterClientRequest withEntitledApplicationArn(String entitledApplicationArn) {
        this.setEntitledApplicationArn(entitledApplicationArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientName() != null) {
            sb.append("ClientName: ").append(this.getClientName()).append(",");
        }
        if (this.getClientType() != null) {
            sb.append("ClientType: ").append(this.getClientType()).append(",");
        }
        if (this.getScopes() != null) {
            sb.append("Scopes: ").append(this.getScopes()).append(",");
        }
        if (this.getRedirectUris() != null) {
            sb.append("RedirectUris: ").append(this.getRedirectUris()).append(",");
        }
        if (this.getGrantTypes() != null) {
            sb.append("GrantTypes: ").append(this.getGrantTypes()).append(",");
        }
        if (this.getIssuerUrl() != null) {
            sb.append("IssuerUrl: ").append(this.getIssuerUrl()).append(",");
        }
        if (this.getEntitledApplicationArn() != null) {
            sb.append("EntitledApplicationArn: ").append(this.getEntitledApplicationArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterClientRequest)) {
            return false;
        }
        RegisterClientRequest other = (RegisterClientRequest)obj;
        if (other.getClientName() == null ^ this.getClientName() == null) {
            return false;
        }
        if (other.getClientName() != null && !other.getClientName().equals(this.getClientName())) {
            return false;
        }
        if (other.getClientType() == null ^ this.getClientType() == null) {
            return false;
        }
        if (other.getClientType() != null && !other.getClientType().equals(this.getClientType())) {
            return false;
        }
        if (other.getScopes() == null ^ this.getScopes() == null) {
            return false;
        }
        if (other.getScopes() != null && !other.getScopes().equals(this.getScopes())) {
            return false;
        }
        if (other.getRedirectUris() == null ^ this.getRedirectUris() == null) {
            return false;
        }
        if (other.getRedirectUris() != null && !other.getRedirectUris().equals(this.getRedirectUris())) {
            return false;
        }
        if (other.getGrantTypes() == null ^ this.getGrantTypes() == null) {
            return false;
        }
        if (other.getGrantTypes() != null && !other.getGrantTypes().equals(this.getGrantTypes())) {
            return false;
        }
        if (other.getIssuerUrl() == null ^ this.getIssuerUrl() == null) {
            return false;
        }
        if (other.getIssuerUrl() != null && !other.getIssuerUrl().equals(this.getIssuerUrl())) {
            return false;
        }
        if (other.getEntitledApplicationArn() == null ^ this.getEntitledApplicationArn() == null) {
            return false;
        }
        return other.getEntitledApplicationArn() == null || other.getEntitledApplicationArn().equals(this.getEntitledApplicationArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientName() == null ? 0 : this.getClientName().hashCode());
        hashCode = 31 * hashCode + (this.getClientType() == null ? 0 : this.getClientType().hashCode());
        hashCode = 31 * hashCode + (this.getScopes() == null ? 0 : this.getScopes().hashCode());
        hashCode = 31 * hashCode + (this.getRedirectUris() == null ? 0 : this.getRedirectUris().hashCode());
        hashCode = 31 * hashCode + (this.getGrantTypes() == null ? 0 : this.getGrantTypes().hashCode());
        hashCode = 31 * hashCode + (this.getIssuerUrl() == null ? 0 : this.getIssuerUrl().hashCode());
        hashCode = 31 * hashCode + (this.getEntitledApplicationArn() == null ? 0 : this.getEntitledApplicationArn().hashCode());
        return hashCode;
    }

    public RegisterClientRequest clone() {
        return (RegisterClientRequest)super.clone();
    }
}

