/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssoadmin.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ssoadmin.model.AuthorizedTokenIssuer;
import com.amazonaws.services.ssoadmin.model.transform.JwtBearerGrantMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class JwtBearerGrant
implements Serializable,
Cloneable,
StructuredPojo {
    private List<AuthorizedTokenIssuer> authorizedTokenIssuers;

    public List<AuthorizedTokenIssuer> getAuthorizedTokenIssuers() {
        return this.authorizedTokenIssuers;
    }

    public void setAuthorizedTokenIssuers(Collection<AuthorizedTokenIssuer> authorizedTokenIssuers) {
        if (authorizedTokenIssuers == null) {
            this.authorizedTokenIssuers = null;
            return;
        }
        this.authorizedTokenIssuers = new ArrayList<AuthorizedTokenIssuer>(authorizedTokenIssuers);
    }

    public JwtBearerGrant withAuthorizedTokenIssuers(AuthorizedTokenIssuer ... authorizedTokenIssuers) {
        if (this.authorizedTokenIssuers == null) {
            this.setAuthorizedTokenIssuers(new ArrayList<AuthorizedTokenIssuer>(authorizedTokenIssuers.length));
        }
        for (AuthorizedTokenIssuer ele : authorizedTokenIssuers) {
            this.authorizedTokenIssuers.add(ele);
        }
        return this;
    }

    public JwtBearerGrant withAuthorizedTokenIssuers(Collection<AuthorizedTokenIssuer> authorizedTokenIssuers) {
        this.setAuthorizedTokenIssuers(authorizedTokenIssuers);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAuthorizedTokenIssuers() != null) {
            sb.append("AuthorizedTokenIssuers: ").append(this.getAuthorizedTokenIssuers());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JwtBearerGrant)) {
            return false;
        }
        JwtBearerGrant other = (JwtBearerGrant)obj;
        if (other.getAuthorizedTokenIssuers() == null ^ this.getAuthorizedTokenIssuers() == null) {
            return false;
        }
        return other.getAuthorizedTokenIssuers() == null || other.getAuthorizedTokenIssuers().equals(this.getAuthorizedTokenIssuers());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAuthorizedTokenIssuers() == null ? 0 : this.getAuthorizedTokenIssuers().hashCode());
        return hashCode;
    }

    public JwtBearerGrant clone() {
        try {
            return (JwtBearerGrant)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JwtBearerGrantMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

