/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmincidents.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.ssmincidents.model.EventSummary;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class EventSummaryMarshaller {
    private static final MarshallingInfo<String> EVENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventId").build();
    private static final MarshallingInfo<List> EVENTREFERENCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventReferences").build();
    private static final MarshallingInfo<Date> EVENTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> EVENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventType").build();
    private static final MarshallingInfo<Date> EVENTUPDATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("eventUpdatedTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> INCIDENTRECORDARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("incidentRecordArn").build();
    private static final EventSummaryMarshaller instance = new EventSummaryMarshaller();

    public static EventSummaryMarshaller getInstance() {
        return instance;
    }

    public void marshall(EventSummary eventSummary, ProtocolMarshaller protocolMarshaller) {
        if (eventSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)eventSummary.getEventId(), EVENTID_BINDING);
            protocolMarshaller.marshall(eventSummary.getEventReferences(), EVENTREFERENCES_BINDING);
            protocolMarshaller.marshall((Object)eventSummary.getEventTime(), EVENTTIME_BINDING);
            protocolMarshaller.marshall((Object)eventSummary.getEventType(), EVENTTYPE_BINDING);
            protocolMarshaller.marshall((Object)eventSummary.getEventUpdatedTime(), EVENTUPDATEDTIME_BINDING);
            protocolMarshaller.marshall((Object)eventSummary.getIncidentRecordArn(), INCIDENTRECORDARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

