/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmincidents.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.ssmincidents.model.RelatedItem;
import com.amazonaws.services.ssmincidents.model.TriggerDetails;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StartIncidentRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clientToken;
    private Integer impact;
    private List<RelatedItem> relatedItems;
    private String responsePlanArn;
    private String title;
    private TriggerDetails triggerDetails;

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public StartIncidentRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setImpact(Integer impact) {
        this.impact = impact;
    }

    public Integer getImpact() {
        return this.impact;
    }

    public StartIncidentRequest withImpact(Integer impact) {
        this.setImpact(impact);
        return this;
    }

    public List<RelatedItem> getRelatedItems() {
        return this.relatedItems;
    }

    public void setRelatedItems(Collection<RelatedItem> relatedItems) {
        if (relatedItems == null) {
            this.relatedItems = null;
            return;
        }
        this.relatedItems = new ArrayList<RelatedItem>(relatedItems);
    }

    public StartIncidentRequest withRelatedItems(RelatedItem ... relatedItems) {
        if (this.relatedItems == null) {
            this.setRelatedItems(new ArrayList<RelatedItem>(relatedItems.length));
        }
        for (RelatedItem ele : relatedItems) {
            this.relatedItems.add(ele);
        }
        return this;
    }

    public StartIncidentRequest withRelatedItems(Collection<RelatedItem> relatedItems) {
        this.setRelatedItems(relatedItems);
        return this;
    }

    public void setResponsePlanArn(String responsePlanArn) {
        this.responsePlanArn = responsePlanArn;
    }

    public String getResponsePlanArn() {
        return this.responsePlanArn;
    }

    public StartIncidentRequest withResponsePlanArn(String responsePlanArn) {
        this.setResponsePlanArn(responsePlanArn);
        return this;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public StartIncidentRequest withTitle(String title) {
        this.setTitle(title);
        return this;
    }

    public void setTriggerDetails(TriggerDetails triggerDetails) {
        this.triggerDetails = triggerDetails;
    }

    public TriggerDetails getTriggerDetails() {
        return this.triggerDetails;
    }

    public StartIncidentRequest withTriggerDetails(TriggerDetails triggerDetails) {
        this.setTriggerDetails(triggerDetails);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getImpact() != null) {
            sb.append("Impact: ").append(this.getImpact()).append(",");
        }
        if (this.getRelatedItems() != null) {
            sb.append("RelatedItems: ").append(this.getRelatedItems()).append(",");
        }
        if (this.getResponsePlanArn() != null) {
            sb.append("ResponsePlanArn: ").append(this.getResponsePlanArn()).append(",");
        }
        if (this.getTitle() != null) {
            sb.append("Title: ").append(this.getTitle()).append(",");
        }
        if (this.getTriggerDetails() != null) {
            sb.append("TriggerDetails: ").append(this.getTriggerDetails());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartIncidentRequest)) {
            return false;
        }
        StartIncidentRequest other = (StartIncidentRequest)obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getImpact() == null ^ this.getImpact() == null) {
            return false;
        }
        if (other.getImpact() != null && !other.getImpact().equals(this.getImpact())) {
            return false;
        }
        if (other.getRelatedItems() == null ^ this.getRelatedItems() == null) {
            return false;
        }
        if (other.getRelatedItems() != null && !other.getRelatedItems().equals(this.getRelatedItems())) {
            return false;
        }
        if (other.getResponsePlanArn() == null ^ this.getResponsePlanArn() == null) {
            return false;
        }
        if (other.getResponsePlanArn() != null && !other.getResponsePlanArn().equals(this.getResponsePlanArn())) {
            return false;
        }
        if (other.getTitle() == null ^ this.getTitle() == null) {
            return false;
        }
        if (other.getTitle() != null && !other.getTitle().equals(this.getTitle())) {
            return false;
        }
        if (other.getTriggerDetails() == null ^ this.getTriggerDetails() == null) {
            return false;
        }
        return other.getTriggerDetails() == null || other.getTriggerDetails().equals(this.getTriggerDetails());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getImpact() == null ? 0 : this.getImpact().hashCode());
        hashCode = 31 * hashCode + (this.getRelatedItems() == null ? 0 : this.getRelatedItems().hashCode());
        hashCode = 31 * hashCode + (this.getResponsePlanArn() == null ? 0 : this.getResponsePlanArn().hashCode());
        hashCode = 31 * hashCode + (this.getTitle() == null ? 0 : this.getTitle().hashCode());
        hashCode = 31 * hashCode + (this.getTriggerDetails() == null ? 0 : this.getTriggerDetails().hashCode());
        return hashCode;
    }

    public StartIncidentRequest clone() {
        return (StartIncidentRequest)super.clone();
    }
}

