/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmincidents.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.ssmincidents.model.Action;
import com.amazonaws.services.ssmincidents.model.ChatChannel;
import com.amazonaws.services.ssmincidents.model.IncidentTemplate;
import com.amazonaws.services.ssmincidents.model.Integration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateResponsePlanRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<Action> actions;
    private ChatChannel chatChannel;
    private String clientToken;
    private String displayName;
    private List<String> engagements;
    private IncidentTemplate incidentTemplate;
    private List<Integration> integrations;
    private String name;
    private Map<String, String> tags;

    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(Collection<Action> actions) {
        if (actions == null) {
            this.actions = null;
            return;
        }
        this.actions = new ArrayList<Action>(actions);
    }

    public CreateResponsePlanRequest withActions(Action ... actions) {
        if (this.actions == null) {
            this.setActions(new ArrayList<Action>(actions.length));
        }
        for (Action ele : actions) {
            this.actions.add(ele);
        }
        return this;
    }

    public CreateResponsePlanRequest withActions(Collection<Action> actions) {
        this.setActions(actions);
        return this;
    }

    public void setChatChannel(ChatChannel chatChannel) {
        this.chatChannel = chatChannel;
    }

    public ChatChannel getChatChannel() {
        return this.chatChannel;
    }

    public CreateResponsePlanRequest withChatChannel(ChatChannel chatChannel) {
        this.setChatChannel(chatChannel);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateResponsePlanRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public CreateResponsePlanRequest withDisplayName(String displayName) {
        this.setDisplayName(displayName);
        return this;
    }

    public List<String> getEngagements() {
        return this.engagements;
    }

    public void setEngagements(Collection<String> engagements) {
        if (engagements == null) {
            this.engagements = null;
            return;
        }
        this.engagements = new ArrayList<String>(engagements);
    }

    public CreateResponsePlanRequest withEngagements(String ... engagements) {
        if (this.engagements == null) {
            this.setEngagements(new ArrayList<String>(engagements.length));
        }
        for (String ele : engagements) {
            this.engagements.add(ele);
        }
        return this;
    }

    public CreateResponsePlanRequest withEngagements(Collection<String> engagements) {
        this.setEngagements(engagements);
        return this;
    }

    public void setIncidentTemplate(IncidentTemplate incidentTemplate) {
        this.incidentTemplate = incidentTemplate;
    }

    public IncidentTemplate getIncidentTemplate() {
        return this.incidentTemplate;
    }

    public CreateResponsePlanRequest withIncidentTemplate(IncidentTemplate incidentTemplate) {
        this.setIncidentTemplate(incidentTemplate);
        return this;
    }

    public List<Integration> getIntegrations() {
        return this.integrations;
    }

    public void setIntegrations(Collection<Integration> integrations) {
        if (integrations == null) {
            this.integrations = null;
            return;
        }
        this.integrations = new ArrayList<Integration>(integrations);
    }

    public CreateResponsePlanRequest withIntegrations(Integration ... integrations) {
        if (this.integrations == null) {
            this.setIntegrations(new ArrayList<Integration>(integrations.length));
        }
        for (Integration ele : integrations) {
            this.integrations.add(ele);
        }
        return this;
    }

    public CreateResponsePlanRequest withIntegrations(Collection<Integration> integrations) {
        this.setIntegrations(integrations);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateResponsePlanRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateResponsePlanRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateResponsePlanRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateResponsePlanRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getActions() != null) {
            sb.append("Actions: ").append(this.getActions()).append(",");
        }
        if (this.getChatChannel() != null) {
            sb.append("ChatChannel: ").append(this.getChatChannel()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getDisplayName() != null) {
            sb.append("DisplayName: ").append(this.getDisplayName()).append(",");
        }
        if (this.getEngagements() != null) {
            sb.append("Engagements: ").append(this.getEngagements()).append(",");
        }
        if (this.getIncidentTemplate() != null) {
            sb.append("IncidentTemplate: ").append(this.getIncidentTemplate()).append(",");
        }
        if (this.getIntegrations() != null) {
            sb.append("Integrations: ").append(this.getIntegrations()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResponsePlanRequest)) {
            return false;
        }
        CreateResponsePlanRequest other = (CreateResponsePlanRequest)obj;
        if (other.getActions() == null ^ this.getActions() == null) {
            return false;
        }
        if (other.getActions() != null && !other.getActions().equals(this.getActions())) {
            return false;
        }
        if (other.getChatChannel() == null ^ this.getChatChannel() == null) {
            return false;
        }
        if (other.getChatChannel() != null && !other.getChatChannel().equals(this.getChatChannel())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getDisplayName() == null ^ this.getDisplayName() == null) {
            return false;
        }
        if (other.getDisplayName() != null && !other.getDisplayName().equals(this.getDisplayName())) {
            return false;
        }
        if (other.getEngagements() == null ^ this.getEngagements() == null) {
            return false;
        }
        if (other.getEngagements() != null && !other.getEngagements().equals(this.getEngagements())) {
            return false;
        }
        if (other.getIncidentTemplate() == null ^ this.getIncidentTemplate() == null) {
            return false;
        }
        if (other.getIncidentTemplate() != null && !other.getIncidentTemplate().equals(this.getIncidentTemplate())) {
            return false;
        }
        if (other.getIntegrations() == null ^ this.getIntegrations() == null) {
            return false;
        }
        if (other.getIntegrations() != null && !other.getIntegrations().equals(this.getIntegrations())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getActions() == null ? 0 : this.getActions().hashCode());
        hashCode = 31 * hashCode + (this.getChatChannel() == null ? 0 : this.getChatChannel().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getDisplayName() == null ? 0 : this.getDisplayName().hashCode());
        hashCode = 31 * hashCode + (this.getEngagements() == null ? 0 : this.getEngagements().hashCode());
        hashCode = 31 * hashCode + (this.getIncidentTemplate() == null ? 0 : this.getIncidentTemplate().hashCode());
        hashCode = 31 * hashCode + (this.getIntegrations() == null ? 0 : this.getIntegrations().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateResponsePlanRequest clone() {
        return (CreateResponsePlanRequest)super.clone();
    }
}

