/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmincidents.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.ssmincidents.model.Action;
import com.amazonaws.services.ssmincidents.model.ChatChannel;
import com.amazonaws.services.ssmincidents.model.Integration;
import com.amazonaws.services.ssmincidents.model.NotificationTargetItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpdateResponsePlanRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<Action> actions;
    private String arn;
    private ChatChannel chatChannel;
    private String clientToken;
    private String displayName;
    private List<String> engagements;
    private String incidentTemplateDedupeString;
    private Integer incidentTemplateImpact;
    private List<NotificationTargetItem> incidentTemplateNotificationTargets;
    private String incidentTemplateSummary;
    private Map<String, String> incidentTemplateTags;
    private String incidentTemplateTitle;
    private List<Integration> integrations;

    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(Collection<Action> actions) {
        if (actions == null) {
            this.actions = null;
            return;
        }
        this.actions = new ArrayList<Action>(actions);
    }

    public UpdateResponsePlanRequest withActions(Action ... actions) {
        if (this.actions == null) {
            this.setActions(new ArrayList<Action>(actions.length));
        }
        for (Action ele : actions) {
            this.actions.add(ele);
        }
        return this;
    }

    public UpdateResponsePlanRequest withActions(Collection<Action> actions) {
        this.setActions(actions);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public UpdateResponsePlanRequest withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setChatChannel(ChatChannel chatChannel) {
        this.chatChannel = chatChannel;
    }

    public ChatChannel getChatChannel() {
        return this.chatChannel;
    }

    public UpdateResponsePlanRequest withChatChannel(ChatChannel chatChannel) {
        this.setChatChannel(chatChannel);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public UpdateResponsePlanRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public UpdateResponsePlanRequest withDisplayName(String displayName) {
        this.setDisplayName(displayName);
        return this;
    }

    public List<String> getEngagements() {
        return this.engagements;
    }

    public void setEngagements(Collection<String> engagements) {
        if (engagements == null) {
            this.engagements = null;
            return;
        }
        this.engagements = new ArrayList<String>(engagements);
    }

    public UpdateResponsePlanRequest withEngagements(String ... engagements) {
        if (this.engagements == null) {
            this.setEngagements(new ArrayList<String>(engagements.length));
        }
        for (String ele : engagements) {
            this.engagements.add(ele);
        }
        return this;
    }

    public UpdateResponsePlanRequest withEngagements(Collection<String> engagements) {
        this.setEngagements(engagements);
        return this;
    }

    public void setIncidentTemplateDedupeString(String incidentTemplateDedupeString) {
        this.incidentTemplateDedupeString = incidentTemplateDedupeString;
    }

    public String getIncidentTemplateDedupeString() {
        return this.incidentTemplateDedupeString;
    }

    public UpdateResponsePlanRequest withIncidentTemplateDedupeString(String incidentTemplateDedupeString) {
        this.setIncidentTemplateDedupeString(incidentTemplateDedupeString);
        return this;
    }

    public void setIncidentTemplateImpact(Integer incidentTemplateImpact) {
        this.incidentTemplateImpact = incidentTemplateImpact;
    }

    public Integer getIncidentTemplateImpact() {
        return this.incidentTemplateImpact;
    }

    public UpdateResponsePlanRequest withIncidentTemplateImpact(Integer incidentTemplateImpact) {
        this.setIncidentTemplateImpact(incidentTemplateImpact);
        return this;
    }

    public List<NotificationTargetItem> getIncidentTemplateNotificationTargets() {
        return this.incidentTemplateNotificationTargets;
    }

    public void setIncidentTemplateNotificationTargets(Collection<NotificationTargetItem> incidentTemplateNotificationTargets) {
        if (incidentTemplateNotificationTargets == null) {
            this.incidentTemplateNotificationTargets = null;
            return;
        }
        this.incidentTemplateNotificationTargets = new ArrayList<NotificationTargetItem>(incidentTemplateNotificationTargets);
    }

    public UpdateResponsePlanRequest withIncidentTemplateNotificationTargets(NotificationTargetItem ... incidentTemplateNotificationTargets) {
        if (this.incidentTemplateNotificationTargets == null) {
            this.setIncidentTemplateNotificationTargets(new ArrayList<NotificationTargetItem>(incidentTemplateNotificationTargets.length));
        }
        for (NotificationTargetItem ele : incidentTemplateNotificationTargets) {
            this.incidentTemplateNotificationTargets.add(ele);
        }
        return this;
    }

    public UpdateResponsePlanRequest withIncidentTemplateNotificationTargets(Collection<NotificationTargetItem> incidentTemplateNotificationTargets) {
        this.setIncidentTemplateNotificationTargets(incidentTemplateNotificationTargets);
        return this;
    }

    public void setIncidentTemplateSummary(String incidentTemplateSummary) {
        this.incidentTemplateSummary = incidentTemplateSummary;
    }

    public String getIncidentTemplateSummary() {
        return this.incidentTemplateSummary;
    }

    public UpdateResponsePlanRequest withIncidentTemplateSummary(String incidentTemplateSummary) {
        this.setIncidentTemplateSummary(incidentTemplateSummary);
        return this;
    }

    public Map<String, String> getIncidentTemplateTags() {
        return this.incidentTemplateTags;
    }

    public void setIncidentTemplateTags(Map<String, String> incidentTemplateTags) {
        this.incidentTemplateTags = incidentTemplateTags;
    }

    public UpdateResponsePlanRequest withIncidentTemplateTags(Map<String, String> incidentTemplateTags) {
        this.setIncidentTemplateTags(incidentTemplateTags);
        return this;
    }

    public UpdateResponsePlanRequest addIncidentTemplateTagsEntry(String key, String value) {
        if (null == this.incidentTemplateTags) {
            this.incidentTemplateTags = new HashMap<String, String>();
        }
        if (this.incidentTemplateTags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.incidentTemplateTags.put(key, value);
        return this;
    }

    public UpdateResponsePlanRequest clearIncidentTemplateTagsEntries() {
        this.incidentTemplateTags = null;
        return this;
    }

    public void setIncidentTemplateTitle(String incidentTemplateTitle) {
        this.incidentTemplateTitle = incidentTemplateTitle;
    }

    public String getIncidentTemplateTitle() {
        return this.incidentTemplateTitle;
    }

    public UpdateResponsePlanRequest withIncidentTemplateTitle(String incidentTemplateTitle) {
        this.setIncidentTemplateTitle(incidentTemplateTitle);
        return this;
    }

    public List<Integration> getIntegrations() {
        return this.integrations;
    }

    public void setIntegrations(Collection<Integration> integrations) {
        if (integrations == null) {
            this.integrations = null;
            return;
        }
        this.integrations = new ArrayList<Integration>(integrations);
    }

    public UpdateResponsePlanRequest withIntegrations(Integration ... integrations) {
        if (this.integrations == null) {
            this.setIntegrations(new ArrayList<Integration>(integrations.length));
        }
        for (Integration ele : integrations) {
            this.integrations.add(ele);
        }
        return this;
    }

    public UpdateResponsePlanRequest withIntegrations(Collection<Integration> integrations) {
        this.setIntegrations(integrations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getActions() != null) {
            sb.append("Actions: ").append(this.getActions()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getChatChannel() != null) {
            sb.append("ChatChannel: ").append(this.getChatChannel()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getDisplayName() != null) {
            sb.append("DisplayName: ").append(this.getDisplayName()).append(",");
        }
        if (this.getEngagements() != null) {
            sb.append("Engagements: ").append(this.getEngagements()).append(",");
        }
        if (this.getIncidentTemplateDedupeString() != null) {
            sb.append("IncidentTemplateDedupeString: ").append(this.getIncidentTemplateDedupeString()).append(",");
        }
        if (this.getIncidentTemplateImpact() != null) {
            sb.append("IncidentTemplateImpact: ").append(this.getIncidentTemplateImpact()).append(",");
        }
        if (this.getIncidentTemplateNotificationTargets() != null) {
            sb.append("IncidentTemplateNotificationTargets: ").append(this.getIncidentTemplateNotificationTargets()).append(",");
        }
        if (this.getIncidentTemplateSummary() != null) {
            sb.append("IncidentTemplateSummary: ").append(this.getIncidentTemplateSummary()).append(",");
        }
        if (this.getIncidentTemplateTags() != null) {
            sb.append("IncidentTemplateTags: ").append(this.getIncidentTemplateTags()).append(",");
        }
        if (this.getIncidentTemplateTitle() != null) {
            sb.append("IncidentTemplateTitle: ").append(this.getIncidentTemplateTitle()).append(",");
        }
        if (this.getIntegrations() != null) {
            sb.append("Integrations: ").append(this.getIntegrations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResponsePlanRequest)) {
            return false;
        }
        UpdateResponsePlanRequest other = (UpdateResponsePlanRequest)obj;
        if (other.getActions() == null ^ this.getActions() == null) {
            return false;
        }
        if (other.getActions() != null && !other.getActions().equals(this.getActions())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getChatChannel() == null ^ this.getChatChannel() == null) {
            return false;
        }
        if (other.getChatChannel() != null && !other.getChatChannel().equals(this.getChatChannel())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getDisplayName() == null ^ this.getDisplayName() == null) {
            return false;
        }
        if (other.getDisplayName() != null && !other.getDisplayName().equals(this.getDisplayName())) {
            return false;
        }
        if (other.getEngagements() == null ^ this.getEngagements() == null) {
            return false;
        }
        if (other.getEngagements() != null && !other.getEngagements().equals(this.getEngagements())) {
            return false;
        }
        if (other.getIncidentTemplateDedupeString() == null ^ this.getIncidentTemplateDedupeString() == null) {
            return false;
        }
        if (other.getIncidentTemplateDedupeString() != null && !other.getIncidentTemplateDedupeString().equals(this.getIncidentTemplateDedupeString())) {
            return false;
        }
        if (other.getIncidentTemplateImpact() == null ^ this.getIncidentTemplateImpact() == null) {
            return false;
        }
        if (other.getIncidentTemplateImpact() != null && !other.getIncidentTemplateImpact().equals(this.getIncidentTemplateImpact())) {
            return false;
        }
        if (other.getIncidentTemplateNotificationTargets() == null ^ this.getIncidentTemplateNotificationTargets() == null) {
            return false;
        }
        if (other.getIncidentTemplateNotificationTargets() != null && !other.getIncidentTemplateNotificationTargets().equals(this.getIncidentTemplateNotificationTargets())) {
            return false;
        }
        if (other.getIncidentTemplateSummary() == null ^ this.getIncidentTemplateSummary() == null) {
            return false;
        }
        if (other.getIncidentTemplateSummary() != null && !other.getIncidentTemplateSummary().equals(this.getIncidentTemplateSummary())) {
            return false;
        }
        if (other.getIncidentTemplateTags() == null ^ this.getIncidentTemplateTags() == null) {
            return false;
        }
        if (other.getIncidentTemplateTags() != null && !other.getIncidentTemplateTags().equals(this.getIncidentTemplateTags())) {
            return false;
        }
        if (other.getIncidentTemplateTitle() == null ^ this.getIncidentTemplateTitle() == null) {
            return false;
        }
        if (other.getIncidentTemplateTitle() != null && !other.getIncidentTemplateTitle().equals(this.getIncidentTemplateTitle())) {
            return false;
        }
        if (other.getIntegrations() == null ^ this.getIntegrations() == null) {
            return false;
        }
        return other.getIntegrations() == null || other.getIntegrations().equals(this.getIntegrations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getActions() == null ? 0 : this.getActions().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getChatChannel() == null ? 0 : this.getChatChannel().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getDisplayName() == null ? 0 : this.getDisplayName().hashCode());
        hashCode = 31 * hashCode + (this.getEngagements() == null ? 0 : this.getEngagements().hashCode());
        hashCode = 31 * hashCode + (this.getIncidentTemplateDedupeString() == null ? 0 : this.getIncidentTemplateDedupeString().hashCode());
        hashCode = 31 * hashCode + (this.getIncidentTemplateImpact() == null ? 0 : this.getIncidentTemplateImpact().hashCode());
        hashCode = 31 * hashCode + (this.getIncidentTemplateNotificationTargets() == null ? 0 : this.getIncidentTemplateNotificationTargets().hashCode());
        hashCode = 31 * hashCode + (this.getIncidentTemplateSummary() == null ? 0 : this.getIncidentTemplateSummary().hashCode());
        hashCode = 31 * hashCode + (this.getIncidentTemplateTags() == null ? 0 : this.getIncidentTemplateTags().hashCode());
        hashCode = 31 * hashCode + (this.getIncidentTemplateTitle() == null ? 0 : this.getIncidentTemplateTitle().hashCode());
        hashCode = 31 * hashCode + (this.getIntegrations() == null ? 0 : this.getIntegrations().hashCode());
        return hashCode;
    }

    public UpdateResponsePlanRequest clone() {
        return (UpdateResponsePlanRequest)super.clone();
    }
}

