/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmincidents;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.ssmincidents.AWSSSMIncidents;
import com.amazonaws.services.ssmincidents.AWSSSMIncidentsClientBuilder;
import com.amazonaws.services.ssmincidents.model.AWSSSMIncidentsException;
import com.amazonaws.services.ssmincidents.model.CreateReplicationSetRequest;
import com.amazonaws.services.ssmincidents.model.CreateReplicationSetResult;
import com.amazonaws.services.ssmincidents.model.CreateResponsePlanRequest;
import com.amazonaws.services.ssmincidents.model.CreateResponsePlanResult;
import com.amazonaws.services.ssmincidents.model.CreateTimelineEventRequest;
import com.amazonaws.services.ssmincidents.model.CreateTimelineEventResult;
import com.amazonaws.services.ssmincidents.model.DeleteIncidentRecordRequest;
import com.amazonaws.services.ssmincidents.model.DeleteIncidentRecordResult;
import com.amazonaws.services.ssmincidents.model.DeleteReplicationSetRequest;
import com.amazonaws.services.ssmincidents.model.DeleteReplicationSetResult;
import com.amazonaws.services.ssmincidents.model.DeleteResourcePolicyRequest;
import com.amazonaws.services.ssmincidents.model.DeleteResourcePolicyResult;
import com.amazonaws.services.ssmincidents.model.DeleteResponsePlanRequest;
import com.amazonaws.services.ssmincidents.model.DeleteResponsePlanResult;
import com.amazonaws.services.ssmincidents.model.DeleteTimelineEventRequest;
import com.amazonaws.services.ssmincidents.model.DeleteTimelineEventResult;
import com.amazonaws.services.ssmincidents.model.GetIncidentRecordRequest;
import com.amazonaws.services.ssmincidents.model.GetIncidentRecordResult;
import com.amazonaws.services.ssmincidents.model.GetReplicationSetRequest;
import com.amazonaws.services.ssmincidents.model.GetReplicationSetResult;
import com.amazonaws.services.ssmincidents.model.GetResourcePoliciesRequest;
import com.amazonaws.services.ssmincidents.model.GetResourcePoliciesResult;
import com.amazonaws.services.ssmincidents.model.GetResponsePlanRequest;
import com.amazonaws.services.ssmincidents.model.GetResponsePlanResult;
import com.amazonaws.services.ssmincidents.model.GetTimelineEventRequest;
import com.amazonaws.services.ssmincidents.model.GetTimelineEventResult;
import com.amazonaws.services.ssmincidents.model.ListIncidentRecordsRequest;
import com.amazonaws.services.ssmincidents.model.ListIncidentRecordsResult;
import com.amazonaws.services.ssmincidents.model.ListRelatedItemsRequest;
import com.amazonaws.services.ssmincidents.model.ListRelatedItemsResult;
import com.amazonaws.services.ssmincidents.model.ListReplicationSetsRequest;
import com.amazonaws.services.ssmincidents.model.ListReplicationSetsResult;
import com.amazonaws.services.ssmincidents.model.ListResponsePlansRequest;
import com.amazonaws.services.ssmincidents.model.ListResponsePlansResult;
import com.amazonaws.services.ssmincidents.model.ListTagsForResourceRequest;
import com.amazonaws.services.ssmincidents.model.ListTagsForResourceResult;
import com.amazonaws.services.ssmincidents.model.ListTimelineEventsRequest;
import com.amazonaws.services.ssmincidents.model.ListTimelineEventsResult;
import com.amazonaws.services.ssmincidents.model.PutResourcePolicyRequest;
import com.amazonaws.services.ssmincidents.model.PutResourcePolicyResult;
import com.amazonaws.services.ssmincidents.model.StartIncidentRequest;
import com.amazonaws.services.ssmincidents.model.StartIncidentResult;
import com.amazonaws.services.ssmincidents.model.TagResourceRequest;
import com.amazonaws.services.ssmincidents.model.TagResourceResult;
import com.amazonaws.services.ssmincidents.model.UntagResourceRequest;
import com.amazonaws.services.ssmincidents.model.UntagResourceResult;
import com.amazonaws.services.ssmincidents.model.UpdateDeletionProtectionRequest;
import com.amazonaws.services.ssmincidents.model.UpdateDeletionProtectionResult;
import com.amazonaws.services.ssmincidents.model.UpdateIncidentRecordRequest;
import com.amazonaws.services.ssmincidents.model.UpdateIncidentRecordResult;
import com.amazonaws.services.ssmincidents.model.UpdateRelatedItemsRequest;
import com.amazonaws.services.ssmincidents.model.UpdateRelatedItemsResult;
import com.amazonaws.services.ssmincidents.model.UpdateReplicationSetRequest;
import com.amazonaws.services.ssmincidents.model.UpdateReplicationSetResult;
import com.amazonaws.services.ssmincidents.model.UpdateResponsePlanRequest;
import com.amazonaws.services.ssmincidents.model.UpdateResponsePlanResult;
import com.amazonaws.services.ssmincidents.model.UpdateTimelineEventRequest;
import com.amazonaws.services.ssmincidents.model.UpdateTimelineEventResult;
import com.amazonaws.services.ssmincidents.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.ssmincidents.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.ssmincidents.model.transform.CreateReplicationSetRequestProtocolMarshaller;
import com.amazonaws.services.ssmincidents.model.transform.CreateReplicationSetResultJsonUnmarshaller;
import com.amazonaws.services.ssmincidents.model.transform.CreateResponsePlanRequestProtocolMarshaller;
import com.amazonaws.services.ssmincidents.model.transform.CreateResponsePlanResultJsonUnmarshaller;
import com.amazonaws.services.ssmincidents.model.transform.CreateTimelineEventRequestProtocolMarshaller;
import com.amazonaws.services.ssmincidents.model.transform.CreateTimelineEventResultJsonUnmarshaller;
import com.amazonaws.services.ssmincidents.model.transform.DeleteIncidentRecordRequestProtocolMarshaller;
import com.amazonaws.services.ssmincidents.model.transform.DeleteIncidentRecordResultJsonUnmarshaller;
import com.amazonaws.services.ssmincidents.model.transform.DeleteReplicationSetRequestProtocolMarshaller;
import com.amazonaws.services.ssmincidents.model.transform.DeleteReplicationSetResultJsonUnmarshaller;
import com.amazonaws.services.ssmincidents.model.transform.DeleteResourcePolicyRequestProtocolMarshaller;
import com.amazonaws.services.ssmincidents.model.transform.DeleteResourcePolicyResultJsonUnmarshaller;
import com.amazonaws.services.ssmincidents.model.transform.DeleteResponsePlanRequestProtocolMarshaller;
import com.amazonaws.services.ssmincidents.model.transform.DeleteResponsePlanResultJsonUnmarshaller;
import com.amazonaws.services.ssmincidents.model.transform.DeleteTimelineEventRequestProtocolMarshaller;
import com.amazonaws.services.ssmincidents.model.transform.DeleteTimelineEventResultJsonUnmarshaller;
import com.amazonaws.services.ssmincidents.model.transform.GetIncidentRecordRequestProtocolMarshaller;
import com.amazonaws.services.ssmincidents.model.transform.GetIncidentRecordResultJsonUnmarshaller;
import com.amazonaws.services.ssmincidents.model.transform.GetReplicationSetRequestProtocolMarshaller;
import com.amazonaws.services.ssmincidents.model.transform.GetReplicationSetResultJsonUnmarshaller;
import com.amazonaws.services.ssmincidents.model.transform.GetResourcePoliciesRequestProtocolMarshaller;
import com.amazonaws.services.ssmincidents.model.transform.GetResourcePoliciesResultJsonUnmarshaller;
import com.amazonaws.services.ssmincidents.model.transform.GetResponsePlanRequestProtocolMarshaller;
import com.amazonaws.services.ssmincidents.model.transform.GetResponsePlanResultJsonUnmarshaller;
import com.amazonaws.services.ssmincidents.model.transform.GetTimelineEventRequestProtocolMarshaller;
import com.amazonaws.services.ssmincidents.model.transform.GetTimelineEventResultJsonUnmarshaller;
import com.amazonaws.services.ssmincidents.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.ssmincidents.model.transform.ListIncidentRecordsRequestProtocolMarshaller;
import com.amazonaws.services.ssmincidents.model.transform.ListIncidentRecordsResultJsonUnmarshaller;
import com.amazonaws.services.ssmincidents.model.transform.ListRelatedItemsRequestProtocolMarshaller;
import com.amazonaws.services.ssmincidents.model.transform.ListRelatedItemsResultJsonUnmarshaller;
import com.amazonaws.services.ssmincidents.model.transform.ListReplicationSetsRequestProtocolMarshaller;
import com.amazonaws.services.ssmincidents.model.transform.ListReplicationSetsResultJsonUnmarshaller;
import com.amazonaws.services.ssmincidents.model.transform.ListResponsePlansRequestProtocolMarshaller;
import com.amazonaws.services.ssmincidents.model.transform.ListResponsePlansResultJsonUnmarshaller;
import com.amazonaws.services.ssmincidents.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.ssmincidents.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.ssmincidents.model.transform.ListTimelineEventsRequestProtocolMarshaller;
import com.amazonaws.services.ssmincidents.model.transform.ListTimelineEventsResultJsonUnmarshaller;
import com.amazonaws.services.ssmincidents.model.transform.PutResourcePolicyRequestProtocolMarshaller;
import com.amazonaws.services.ssmincidents.model.transform.PutResourcePolicyResultJsonUnmarshaller;
import com.amazonaws.services.ssmincidents.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.ssmincidents.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.ssmincidents.model.transform.StartIncidentRequestProtocolMarshaller;
import com.amazonaws.services.ssmincidents.model.transform.StartIncidentResultJsonUnmarshaller;
import com.amazonaws.services.ssmincidents.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.ssmincidents.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.ssmincidents.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.ssmincidents.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.ssmincidents.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.ssmincidents.model.transform.UpdateDeletionProtectionRequestProtocolMarshaller;
import com.amazonaws.services.ssmincidents.model.transform.UpdateDeletionProtectionResultJsonUnmarshaller;
import com.amazonaws.services.ssmincidents.model.transform.UpdateIncidentRecordRequestProtocolMarshaller;
import com.amazonaws.services.ssmincidents.model.transform.UpdateIncidentRecordResultJsonUnmarshaller;
import com.amazonaws.services.ssmincidents.model.transform.UpdateRelatedItemsRequestProtocolMarshaller;
import com.amazonaws.services.ssmincidents.model.transform.UpdateRelatedItemsResultJsonUnmarshaller;
import com.amazonaws.services.ssmincidents.model.transform.UpdateReplicationSetRequestProtocolMarshaller;
import com.amazonaws.services.ssmincidents.model.transform.UpdateReplicationSetResultJsonUnmarshaller;
import com.amazonaws.services.ssmincidents.model.transform.UpdateResponsePlanRequestProtocolMarshaller;
import com.amazonaws.services.ssmincidents.model.transform.UpdateResponsePlanResultJsonUnmarshaller;
import com.amazonaws.services.ssmincidents.model.transform.UpdateTimelineEventRequestProtocolMarshaller;
import com.amazonaws.services.ssmincidents.model.transform.UpdateTimelineEventResultJsonUnmarshaller;
import com.amazonaws.services.ssmincidents.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.services.ssmincidents.waiters.AWSSSMIncidentsWaiters;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSSSMIncidentsClient
extends AmazonWebServiceClient
implements AWSSSMIncidents {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSSSMIncidents.class);
    private static final String DEFAULT_SIGNING_NAME = "ssm-incidents";
    private volatile AWSSSMIncidentsWaiters waiters;
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSSSMIncidentsException.class));

    public static AWSSSMIncidentsClientBuilder builder() {
        return AWSSSMIncidentsClientBuilder.standard();
    }

    AWSSSMIncidentsClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSSSMIncidentsClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("ssm-incidents.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/ssmincidents/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/ssmincidents/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CreateReplicationSetResult createReplicationSet(CreateReplicationSetRequest request) {
        request = (CreateReplicationSetRequest)this.beforeClientExecution(request);
        return this.executeCreateReplicationSet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateReplicationSetResult executeCreateReplicationSet(CreateReplicationSetRequest createReplicationSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createReplicationSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateReplicationSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateReplicationSetRequestProtocolMarshaller(protocolFactory).marshall((CreateReplicationSetRequest)super.beforeMarshalling((AmazonWebServiceRequest)createReplicationSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Incidents");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateReplicationSet");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateReplicationSetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateReplicationSetResult createReplicationSetResult = (CreateReplicationSetResult)response.getAwsResponse();
            return createReplicationSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateResponsePlanResult createResponsePlan(CreateResponsePlanRequest request) {
        request = (CreateResponsePlanRequest)this.beforeClientExecution(request);
        return this.executeCreateResponsePlan(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateResponsePlanResult executeCreateResponsePlan(CreateResponsePlanRequest createResponsePlanRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createResponsePlanRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateResponsePlanRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateResponsePlanRequestProtocolMarshaller(protocolFactory).marshall((CreateResponsePlanRequest)super.beforeMarshalling((AmazonWebServiceRequest)createResponsePlanRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Incidents");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateResponsePlan");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateResponsePlanResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateResponsePlanResult createResponsePlanResult = (CreateResponsePlanResult)response.getAwsResponse();
            return createResponsePlanResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateTimelineEventResult createTimelineEvent(CreateTimelineEventRequest request) {
        request = (CreateTimelineEventRequest)this.beforeClientExecution(request);
        return this.executeCreateTimelineEvent(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateTimelineEventResult executeCreateTimelineEvent(CreateTimelineEventRequest createTimelineEventRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createTimelineEventRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateTimelineEventRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateTimelineEventRequestProtocolMarshaller(protocolFactory).marshall((CreateTimelineEventRequest)super.beforeMarshalling((AmazonWebServiceRequest)createTimelineEventRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Incidents");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateTimelineEvent");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateTimelineEventResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateTimelineEventResult createTimelineEventResult = (CreateTimelineEventResult)response.getAwsResponse();
            return createTimelineEventResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteIncidentRecordResult deleteIncidentRecord(DeleteIncidentRecordRequest request) {
        request = (DeleteIncidentRecordRequest)this.beforeClientExecution(request);
        return this.executeDeleteIncidentRecord(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteIncidentRecordResult executeDeleteIncidentRecord(DeleteIncidentRecordRequest deleteIncidentRecordRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteIncidentRecordRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteIncidentRecordRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteIncidentRecordRequestProtocolMarshaller(protocolFactory).marshall((DeleteIncidentRecordRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteIncidentRecordRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Incidents");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteIncidentRecord");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteIncidentRecordResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteIncidentRecordResult deleteIncidentRecordResult = (DeleteIncidentRecordResult)response.getAwsResponse();
            return deleteIncidentRecordResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteReplicationSetResult deleteReplicationSet(DeleteReplicationSetRequest request) {
        request = (DeleteReplicationSetRequest)this.beforeClientExecution(request);
        return this.executeDeleteReplicationSet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteReplicationSetResult executeDeleteReplicationSet(DeleteReplicationSetRequest deleteReplicationSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteReplicationSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteReplicationSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteReplicationSetRequestProtocolMarshaller(protocolFactory).marshall((DeleteReplicationSetRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteReplicationSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Incidents");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteReplicationSet");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteReplicationSetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteReplicationSetResult deleteReplicationSetResult = (DeleteReplicationSetResult)response.getAwsResponse();
            return deleteReplicationSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteResourcePolicyResult deleteResourcePolicy(DeleteResourcePolicyRequest request) {
        request = (DeleteResourcePolicyRequest)this.beforeClientExecution(request);
        return this.executeDeleteResourcePolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteResourcePolicyResult executeDeleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteResourcePolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteResourcePolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteResourcePolicyRequestProtocolMarshaller(protocolFactory).marshall((DeleteResourcePolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteResourcePolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Incidents");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteResourcePolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteResourcePolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteResourcePolicyResult deleteResourcePolicyResult = (DeleteResourcePolicyResult)response.getAwsResponse();
            return deleteResourcePolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteResponsePlanResult deleteResponsePlan(DeleteResponsePlanRequest request) {
        request = (DeleteResponsePlanRequest)this.beforeClientExecution(request);
        return this.executeDeleteResponsePlan(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteResponsePlanResult executeDeleteResponsePlan(DeleteResponsePlanRequest deleteResponsePlanRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteResponsePlanRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteResponsePlanRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteResponsePlanRequestProtocolMarshaller(protocolFactory).marshall((DeleteResponsePlanRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteResponsePlanRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Incidents");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteResponsePlan");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteResponsePlanResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteResponsePlanResult deleteResponsePlanResult = (DeleteResponsePlanResult)response.getAwsResponse();
            return deleteResponsePlanResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteTimelineEventResult deleteTimelineEvent(DeleteTimelineEventRequest request) {
        request = (DeleteTimelineEventRequest)this.beforeClientExecution(request);
        return this.executeDeleteTimelineEvent(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteTimelineEventResult executeDeleteTimelineEvent(DeleteTimelineEventRequest deleteTimelineEventRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteTimelineEventRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteTimelineEventRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteTimelineEventRequestProtocolMarshaller(protocolFactory).marshall((DeleteTimelineEventRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteTimelineEventRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Incidents");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteTimelineEvent");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteTimelineEventResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteTimelineEventResult deleteTimelineEventResult = (DeleteTimelineEventResult)response.getAwsResponse();
            return deleteTimelineEventResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetIncidentRecordResult getIncidentRecord(GetIncidentRecordRequest request) {
        request = (GetIncidentRecordRequest)this.beforeClientExecution(request);
        return this.executeGetIncidentRecord(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetIncidentRecordResult executeGetIncidentRecord(GetIncidentRecordRequest getIncidentRecordRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getIncidentRecordRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetIncidentRecordRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetIncidentRecordRequestProtocolMarshaller(protocolFactory).marshall((GetIncidentRecordRequest)super.beforeMarshalling((AmazonWebServiceRequest)getIncidentRecordRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Incidents");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetIncidentRecord");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetIncidentRecordResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetIncidentRecordResult getIncidentRecordResult = (GetIncidentRecordResult)response.getAwsResponse();
            return getIncidentRecordResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetReplicationSetResult getReplicationSet(GetReplicationSetRequest request) {
        request = (GetReplicationSetRequest)this.beforeClientExecution(request);
        return this.executeGetReplicationSet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetReplicationSetResult executeGetReplicationSet(GetReplicationSetRequest getReplicationSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getReplicationSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetReplicationSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetReplicationSetRequestProtocolMarshaller(protocolFactory).marshall((GetReplicationSetRequest)super.beforeMarshalling((AmazonWebServiceRequest)getReplicationSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Incidents");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetReplicationSet");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetReplicationSetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetReplicationSetResult getReplicationSetResult = (GetReplicationSetResult)response.getAwsResponse();
            return getReplicationSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetResourcePoliciesResult getResourcePolicies(GetResourcePoliciesRequest request) {
        request = (GetResourcePoliciesRequest)this.beforeClientExecution(request);
        return this.executeGetResourcePolicies(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetResourcePoliciesResult executeGetResourcePolicies(GetResourcePoliciesRequest getResourcePoliciesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getResourcePoliciesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetResourcePoliciesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetResourcePoliciesRequestProtocolMarshaller(protocolFactory).marshall((GetResourcePoliciesRequest)super.beforeMarshalling((AmazonWebServiceRequest)getResourcePoliciesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Incidents");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetResourcePolicies");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetResourcePoliciesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetResourcePoliciesResult getResourcePoliciesResult = (GetResourcePoliciesResult)response.getAwsResponse();
            return getResourcePoliciesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetResponsePlanResult getResponsePlan(GetResponsePlanRequest request) {
        request = (GetResponsePlanRequest)this.beforeClientExecution(request);
        return this.executeGetResponsePlan(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetResponsePlanResult executeGetResponsePlan(GetResponsePlanRequest getResponsePlanRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getResponsePlanRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetResponsePlanRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetResponsePlanRequestProtocolMarshaller(protocolFactory).marshall((GetResponsePlanRequest)super.beforeMarshalling((AmazonWebServiceRequest)getResponsePlanRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Incidents");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetResponsePlan");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetResponsePlanResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetResponsePlanResult getResponsePlanResult = (GetResponsePlanResult)response.getAwsResponse();
            return getResponsePlanResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetTimelineEventResult getTimelineEvent(GetTimelineEventRequest request) {
        request = (GetTimelineEventRequest)this.beforeClientExecution(request);
        return this.executeGetTimelineEvent(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetTimelineEventResult executeGetTimelineEvent(GetTimelineEventRequest getTimelineEventRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getTimelineEventRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetTimelineEventRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetTimelineEventRequestProtocolMarshaller(protocolFactory).marshall((GetTimelineEventRequest)super.beforeMarshalling((AmazonWebServiceRequest)getTimelineEventRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Incidents");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetTimelineEvent");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetTimelineEventResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetTimelineEventResult getTimelineEventResult = (GetTimelineEventResult)response.getAwsResponse();
            return getTimelineEventResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListIncidentRecordsResult listIncidentRecords(ListIncidentRecordsRequest request) {
        request = (ListIncidentRecordsRequest)this.beforeClientExecution(request);
        return this.executeListIncidentRecords(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListIncidentRecordsResult executeListIncidentRecords(ListIncidentRecordsRequest listIncidentRecordsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listIncidentRecordsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListIncidentRecordsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListIncidentRecordsRequestProtocolMarshaller(protocolFactory).marshall((ListIncidentRecordsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listIncidentRecordsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Incidents");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListIncidentRecords");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListIncidentRecordsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListIncidentRecordsResult listIncidentRecordsResult = (ListIncidentRecordsResult)response.getAwsResponse();
            return listIncidentRecordsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListRelatedItemsResult listRelatedItems(ListRelatedItemsRequest request) {
        request = (ListRelatedItemsRequest)this.beforeClientExecution(request);
        return this.executeListRelatedItems(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListRelatedItemsResult executeListRelatedItems(ListRelatedItemsRequest listRelatedItemsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRelatedItemsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRelatedItemsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRelatedItemsRequestProtocolMarshaller(protocolFactory).marshall((ListRelatedItemsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listRelatedItemsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Incidents");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListRelatedItems");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListRelatedItemsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListRelatedItemsResult listRelatedItemsResult = (ListRelatedItemsResult)response.getAwsResponse();
            return listRelatedItemsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListReplicationSetsResult listReplicationSets(ListReplicationSetsRequest request) {
        request = (ListReplicationSetsRequest)this.beforeClientExecution(request);
        return this.executeListReplicationSets(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListReplicationSetsResult executeListReplicationSets(ListReplicationSetsRequest listReplicationSetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listReplicationSetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListReplicationSetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListReplicationSetsRequestProtocolMarshaller(protocolFactory).marshall((ListReplicationSetsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listReplicationSetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Incidents");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListReplicationSets");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListReplicationSetsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListReplicationSetsResult listReplicationSetsResult = (ListReplicationSetsResult)response.getAwsResponse();
            return listReplicationSetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListResponsePlansResult listResponsePlans(ListResponsePlansRequest request) {
        request = (ListResponsePlansRequest)this.beforeClientExecution(request);
        return this.executeListResponsePlans(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListResponsePlansResult executeListResponsePlans(ListResponsePlansRequest listResponsePlansRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listResponsePlansRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListResponsePlansRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListResponsePlansRequestProtocolMarshaller(protocolFactory).marshall((ListResponsePlansRequest)super.beforeMarshalling((AmazonWebServiceRequest)listResponsePlansRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Incidents");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListResponsePlans");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListResponsePlansResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListResponsePlansResult listResponsePlansResult = (ListResponsePlansResult)response.getAwsResponse();
            return listResponsePlansResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Incidents");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTimelineEventsResult listTimelineEvents(ListTimelineEventsRequest request) {
        request = (ListTimelineEventsRequest)this.beforeClientExecution(request);
        return this.executeListTimelineEvents(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTimelineEventsResult executeListTimelineEvents(ListTimelineEventsRequest listTimelineEventsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTimelineEventsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTimelineEventsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTimelineEventsRequestProtocolMarshaller(protocolFactory).marshall((ListTimelineEventsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTimelineEventsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Incidents");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTimelineEvents");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTimelineEventsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTimelineEventsResult listTimelineEventsResult = (ListTimelineEventsResult)response.getAwsResponse();
            return listTimelineEventsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutResourcePolicyResult putResourcePolicy(PutResourcePolicyRequest request) {
        request = (PutResourcePolicyRequest)this.beforeClientExecution(request);
        return this.executePutResourcePolicy(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutResourcePolicyResult executePutResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putResourcePolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutResourcePolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutResourcePolicyRequestProtocolMarshaller(protocolFactory).marshall((PutResourcePolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)putResourcePolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Incidents");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutResourcePolicy");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutResourcePolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutResourcePolicyResult putResourcePolicyResult = (PutResourcePolicyResult)response.getAwsResponse();
            return putResourcePolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartIncidentResult startIncident(StartIncidentRequest request) {
        request = (StartIncidentRequest)this.beforeClientExecution(request);
        return this.executeStartIncident(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartIncidentResult executeStartIncident(StartIncidentRequest startIncidentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startIncidentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartIncidentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartIncidentRequestProtocolMarshaller(protocolFactory).marshall((StartIncidentRequest)super.beforeMarshalling((AmazonWebServiceRequest)startIncidentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Incidents");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartIncident");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartIncidentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartIncidentResult startIncidentResult = (StartIncidentResult)response.getAwsResponse();
            return startIncidentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Incidents");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Incidents");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateDeletionProtectionResult updateDeletionProtection(UpdateDeletionProtectionRequest request) {
        request = (UpdateDeletionProtectionRequest)this.beforeClientExecution(request);
        return this.executeUpdateDeletionProtection(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateDeletionProtectionResult executeUpdateDeletionProtection(UpdateDeletionProtectionRequest updateDeletionProtectionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateDeletionProtectionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateDeletionProtectionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateDeletionProtectionRequestProtocolMarshaller(protocolFactory).marshall((UpdateDeletionProtectionRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateDeletionProtectionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Incidents");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateDeletionProtection");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateDeletionProtectionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateDeletionProtectionResult updateDeletionProtectionResult = (UpdateDeletionProtectionResult)response.getAwsResponse();
            return updateDeletionProtectionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateIncidentRecordResult updateIncidentRecord(UpdateIncidentRecordRequest request) {
        request = (UpdateIncidentRecordRequest)this.beforeClientExecution(request);
        return this.executeUpdateIncidentRecord(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateIncidentRecordResult executeUpdateIncidentRecord(UpdateIncidentRecordRequest updateIncidentRecordRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateIncidentRecordRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateIncidentRecordRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateIncidentRecordRequestProtocolMarshaller(protocolFactory).marshall((UpdateIncidentRecordRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateIncidentRecordRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Incidents");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateIncidentRecord");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateIncidentRecordResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateIncidentRecordResult updateIncidentRecordResult = (UpdateIncidentRecordResult)response.getAwsResponse();
            return updateIncidentRecordResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateRelatedItemsResult updateRelatedItems(UpdateRelatedItemsRequest request) {
        request = (UpdateRelatedItemsRequest)this.beforeClientExecution(request);
        return this.executeUpdateRelatedItems(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateRelatedItemsResult executeUpdateRelatedItems(UpdateRelatedItemsRequest updateRelatedItemsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateRelatedItemsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateRelatedItemsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateRelatedItemsRequestProtocolMarshaller(protocolFactory).marshall((UpdateRelatedItemsRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateRelatedItemsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Incidents");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateRelatedItems");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateRelatedItemsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateRelatedItemsResult updateRelatedItemsResult = (UpdateRelatedItemsResult)response.getAwsResponse();
            return updateRelatedItemsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateReplicationSetResult updateReplicationSet(UpdateReplicationSetRequest request) {
        request = (UpdateReplicationSetRequest)this.beforeClientExecution(request);
        return this.executeUpdateReplicationSet(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateReplicationSetResult executeUpdateReplicationSet(UpdateReplicationSetRequest updateReplicationSetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateReplicationSetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateReplicationSetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateReplicationSetRequestProtocolMarshaller(protocolFactory).marshall((UpdateReplicationSetRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateReplicationSetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Incidents");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateReplicationSet");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateReplicationSetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateReplicationSetResult updateReplicationSetResult = (UpdateReplicationSetResult)response.getAwsResponse();
            return updateReplicationSetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateResponsePlanResult updateResponsePlan(UpdateResponsePlanRequest request) {
        request = (UpdateResponsePlanRequest)this.beforeClientExecution(request);
        return this.executeUpdateResponsePlan(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateResponsePlanResult executeUpdateResponsePlan(UpdateResponsePlanRequest updateResponsePlanRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateResponsePlanRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateResponsePlanRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateResponsePlanRequestProtocolMarshaller(protocolFactory).marshall((UpdateResponsePlanRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateResponsePlanRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Incidents");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateResponsePlan");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateResponsePlanResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateResponsePlanResult updateResponsePlanResult = (UpdateResponsePlanResult)response.getAwsResponse();
            return updateResponsePlanResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateTimelineEventResult updateTimelineEvent(UpdateTimelineEventRequest request) {
        request = (UpdateTimelineEventRequest)this.beforeClientExecution(request);
        return this.executeUpdateTimelineEvent(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateTimelineEventResult executeUpdateTimelineEvent(UpdateTimelineEventRequest updateTimelineEventRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateTimelineEventRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateTimelineEventRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateTimelineEventRequestProtocolMarshaller(protocolFactory).marshall((UpdateTimelineEventRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateTimelineEventRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SSM Incidents");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateTimelineEvent");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateTimelineEventResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateTimelineEventResult updateTimelineEventResult = (UpdateTimelineEventResult)response.getAwsResponse();
            return updateTimelineEventResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AWSSSMIncidentsWaiters waiters() {
        if (this.waiters == null) {
            AWSSSMIncidentsClient aWSSSMIncidentsClient = this;
            synchronized (aWSSSMIncidentsClient) {
                if (this.waiters == null) {
                    this.waiters = new AWSSSMIncidentsWaiters(this);
                }
            }
        }
        return this.waiters;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this.waiters != null) {
            this.waiters.shutdown();
        }
    }
}

