/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ssmcontacts.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ssmcontacts.model.transform.DependentEntityMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DependentEntity
implements Serializable,
Cloneable,
StructuredPojo {
    private String relationType;
    private List<String> dependentResourceIds;

    public void setRelationType(String relationType) {
        this.relationType = relationType;
    }

    public String getRelationType() {
        return this.relationType;
    }

    public DependentEntity withRelationType(String relationType) {
        this.setRelationType(relationType);
        return this;
    }

    public List<String> getDependentResourceIds() {
        return this.dependentResourceIds;
    }

    public void setDependentResourceIds(Collection<String> dependentResourceIds) {
        if (dependentResourceIds == null) {
            this.dependentResourceIds = null;
            return;
        }
        this.dependentResourceIds = new ArrayList<String>(dependentResourceIds);
    }

    public DependentEntity withDependentResourceIds(String ... dependentResourceIds) {
        if (this.dependentResourceIds == null) {
            this.setDependentResourceIds(new ArrayList<String>(dependentResourceIds.length));
        }
        for (String ele : dependentResourceIds) {
            this.dependentResourceIds.add(ele);
        }
        return this;
    }

    public DependentEntity withDependentResourceIds(Collection<String> dependentResourceIds) {
        this.setDependentResourceIds(dependentResourceIds);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRelationType() != null) {
            sb.append("RelationType: ").append(this.getRelationType()).append(",");
        }
        if (this.getDependentResourceIds() != null) {
            sb.append("DependentResourceIds: ").append(this.getDependentResourceIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DependentEntity)) {
            return false;
        }
        DependentEntity other = (DependentEntity)obj;
        if (other.getRelationType() == null ^ this.getRelationType() == null) {
            return false;
        }
        if (other.getRelationType() != null && !other.getRelationType().equals(this.getRelationType())) {
            return false;
        }
        if (other.getDependentResourceIds() == null ^ this.getDependentResourceIds() == null) {
            return false;
        }
        return other.getDependentResourceIds() == null || other.getDependentResourceIds().equals(this.getDependentResourceIds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRelationType() == null ? 0 : this.getRelationType().hashCode());
        hashCode = 31 * hashCode + (this.getDependentResourceIds() == null ? 0 : this.getDependentResourceIds().hashCode());
        return hashCode;
    }

    public DependentEntity clone() {
        try {
            return (DependentEntity)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DependentEntityMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

