/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.simplesystemsmanagement.model.InventoryFilter;
import com.amazonaws.services.simplesystemsmanagement.model.transform.InventoryGroupMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class InventoryGroup
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private SdkInternalList<InventoryFilter> filters;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public InventoryGroup withName(String name) {
        this.setName(name);
        return this;
    }

    public List<InventoryFilter> getFilters() {
        if (this.filters == null) {
            this.filters = new SdkInternalList();
        }
        return this.filters;
    }

    public void setFilters(Collection<InventoryFilter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new SdkInternalList(filters);
    }

    public InventoryGroup withFilters(InventoryFilter ... filters) {
        if (this.filters == null) {
            this.setFilters((Collection<InventoryFilter>)new SdkInternalList(filters.length));
        }
        for (InventoryFilter ele : filters) {
            this.filters.add((Object)ele);
        }
        return this;
    }

    public InventoryGroup withFilters(Collection<InventoryFilter> filters) {
        this.setFilters(filters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryGroup)) {
            return false;
        }
        InventoryGroup other = (InventoryGroup)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        return other.getFilters() == null || other.getFilters().equals(this.getFilters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        return hashCode;
    }

    public InventoryGroup clone() {
        try {
            return (InventoryGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InventoryGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

