/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.OpsItemDataValue;
import com.amazonaws.services.simplesystemsmanagement.model.OpsItemNotification;
import com.amazonaws.services.simplesystemsmanagement.model.RelatedOpsItem;
import com.amazonaws.services.simplesystemsmanagement.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateOpsItemRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String description;
    private String opsItemType;
    private Map<String, OpsItemDataValue> operationalData;
    private SdkInternalList<OpsItemNotification> notifications;
    private Integer priority;
    private SdkInternalList<RelatedOpsItem> relatedOpsItems;
    private String source;
    private String title;
    private SdkInternalList<Tag> tags;
    private String category;
    private String severity;
    private Date actualStartTime;
    private Date actualEndTime;
    private Date plannedStartTime;
    private Date plannedEndTime;
    private String accountId;

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateOpsItemRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setOpsItemType(String opsItemType) {
        this.opsItemType = opsItemType;
    }

    public String getOpsItemType() {
        return this.opsItemType;
    }

    public CreateOpsItemRequest withOpsItemType(String opsItemType) {
        this.setOpsItemType(opsItemType);
        return this;
    }

    public Map<String, OpsItemDataValue> getOperationalData() {
        return this.operationalData;
    }

    public void setOperationalData(Map<String, OpsItemDataValue> operationalData) {
        this.operationalData = operationalData;
    }

    public CreateOpsItemRequest withOperationalData(Map<String, OpsItemDataValue> operationalData) {
        this.setOperationalData(operationalData);
        return this;
    }

    public CreateOpsItemRequest addOperationalDataEntry(String key, OpsItemDataValue value) {
        if (null == this.operationalData) {
            this.operationalData = new HashMap<String, OpsItemDataValue>();
        }
        if (this.operationalData.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.operationalData.put(key, value);
        return this;
    }

    public CreateOpsItemRequest clearOperationalDataEntries() {
        this.operationalData = null;
        return this;
    }

    public List<OpsItemNotification> getNotifications() {
        if (this.notifications == null) {
            this.notifications = new SdkInternalList();
        }
        return this.notifications;
    }

    public void setNotifications(Collection<OpsItemNotification> notifications) {
        if (notifications == null) {
            this.notifications = null;
            return;
        }
        this.notifications = new SdkInternalList(notifications);
    }

    public CreateOpsItemRequest withNotifications(OpsItemNotification ... notifications) {
        if (this.notifications == null) {
            this.setNotifications((Collection<OpsItemNotification>)new SdkInternalList(notifications.length));
        }
        for (OpsItemNotification ele : notifications) {
            this.notifications.add((Object)ele);
        }
        return this;
    }

    public CreateOpsItemRequest withNotifications(Collection<OpsItemNotification> notifications) {
        this.setNotifications(notifications);
        return this;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public CreateOpsItemRequest withPriority(Integer priority) {
        this.setPriority(priority);
        return this;
    }

    public List<RelatedOpsItem> getRelatedOpsItems() {
        if (this.relatedOpsItems == null) {
            this.relatedOpsItems = new SdkInternalList();
        }
        return this.relatedOpsItems;
    }

    public void setRelatedOpsItems(Collection<RelatedOpsItem> relatedOpsItems) {
        if (relatedOpsItems == null) {
            this.relatedOpsItems = null;
            return;
        }
        this.relatedOpsItems = new SdkInternalList(relatedOpsItems);
    }

    public CreateOpsItemRequest withRelatedOpsItems(RelatedOpsItem ... relatedOpsItems) {
        if (this.relatedOpsItems == null) {
            this.setRelatedOpsItems((Collection<RelatedOpsItem>)new SdkInternalList(relatedOpsItems.length));
        }
        for (RelatedOpsItem ele : relatedOpsItems) {
            this.relatedOpsItems.add((Object)ele);
        }
        return this;
    }

    public CreateOpsItemRequest withRelatedOpsItems(Collection<RelatedOpsItem> relatedOpsItems) {
        this.setRelatedOpsItems(relatedOpsItems);
        return this;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public CreateOpsItemRequest withSource(String source) {
        this.setSource(source);
        return this;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public CreateOpsItemRequest withTitle(String title) {
        this.setTitle(title);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public CreateOpsItemRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public CreateOpsItemRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getCategory() {
        return this.category;
    }

    public CreateOpsItemRequest withCategory(String category) {
        this.setCategory(category);
        return this;
    }

    public void setSeverity(String severity) {
        this.severity = severity;
    }

    public String getSeverity() {
        return this.severity;
    }

    public CreateOpsItemRequest withSeverity(String severity) {
        this.setSeverity(severity);
        return this;
    }

    public void setActualStartTime(Date actualStartTime) {
        this.actualStartTime = actualStartTime;
    }

    public Date getActualStartTime() {
        return this.actualStartTime;
    }

    public CreateOpsItemRequest withActualStartTime(Date actualStartTime) {
        this.setActualStartTime(actualStartTime);
        return this;
    }

    public void setActualEndTime(Date actualEndTime) {
        this.actualEndTime = actualEndTime;
    }

    public Date getActualEndTime() {
        return this.actualEndTime;
    }

    public CreateOpsItemRequest withActualEndTime(Date actualEndTime) {
        this.setActualEndTime(actualEndTime);
        return this;
    }

    public void setPlannedStartTime(Date plannedStartTime) {
        this.plannedStartTime = plannedStartTime;
    }

    public Date getPlannedStartTime() {
        return this.plannedStartTime;
    }

    public CreateOpsItemRequest withPlannedStartTime(Date plannedStartTime) {
        this.setPlannedStartTime(plannedStartTime);
        return this;
    }

    public void setPlannedEndTime(Date plannedEndTime) {
        this.plannedEndTime = plannedEndTime;
    }

    public Date getPlannedEndTime() {
        return this.plannedEndTime;
    }

    public CreateOpsItemRequest withPlannedEndTime(Date plannedEndTime) {
        this.setPlannedEndTime(plannedEndTime);
        return this;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public CreateOpsItemRequest withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getOpsItemType() != null) {
            sb.append("OpsItemType: ").append(this.getOpsItemType()).append(",");
        }
        if (this.getOperationalData() != null) {
            sb.append("OperationalData: ").append(this.getOperationalData()).append(",");
        }
        if (this.getNotifications() != null) {
            sb.append("Notifications: ").append(this.getNotifications()).append(",");
        }
        if (this.getPriority() != null) {
            sb.append("Priority: ").append(this.getPriority()).append(",");
        }
        if (this.getRelatedOpsItems() != null) {
            sb.append("RelatedOpsItems: ").append(this.getRelatedOpsItems()).append(",");
        }
        if (this.getSource() != null) {
            sb.append("Source: ").append(this.getSource()).append(",");
        }
        if (this.getTitle() != null) {
            sb.append("Title: ").append(this.getTitle()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getCategory() != null) {
            sb.append("Category: ").append(this.getCategory()).append(",");
        }
        if (this.getSeverity() != null) {
            sb.append("Severity: ").append(this.getSeverity()).append(",");
        }
        if (this.getActualStartTime() != null) {
            sb.append("ActualStartTime: ").append(this.getActualStartTime()).append(",");
        }
        if (this.getActualEndTime() != null) {
            sb.append("ActualEndTime: ").append(this.getActualEndTime()).append(",");
        }
        if (this.getPlannedStartTime() != null) {
            sb.append("PlannedStartTime: ").append(this.getPlannedStartTime()).append(",");
        }
        if (this.getPlannedEndTime() != null) {
            sb.append("PlannedEndTime: ").append(this.getPlannedEndTime()).append(",");
        }
        if (this.getAccountId() != null) {
            sb.append("AccountId: ").append(this.getAccountId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOpsItemRequest)) {
            return false;
        }
        CreateOpsItemRequest other = (CreateOpsItemRequest)obj;
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getOpsItemType() == null ^ this.getOpsItemType() == null) {
            return false;
        }
        if (other.getOpsItemType() != null && !other.getOpsItemType().equals(this.getOpsItemType())) {
            return false;
        }
        if (other.getOperationalData() == null ^ this.getOperationalData() == null) {
            return false;
        }
        if (other.getOperationalData() != null && !other.getOperationalData().equals(this.getOperationalData())) {
            return false;
        }
        if (other.getNotifications() == null ^ this.getNotifications() == null) {
            return false;
        }
        if (other.getNotifications() != null && !other.getNotifications().equals(this.getNotifications())) {
            return false;
        }
        if (other.getPriority() == null ^ this.getPriority() == null) {
            return false;
        }
        if (other.getPriority() != null && !other.getPriority().equals(this.getPriority())) {
            return false;
        }
        if (other.getRelatedOpsItems() == null ^ this.getRelatedOpsItems() == null) {
            return false;
        }
        if (other.getRelatedOpsItems() != null && !other.getRelatedOpsItems().equals(this.getRelatedOpsItems())) {
            return false;
        }
        if (other.getSource() == null ^ this.getSource() == null) {
            return false;
        }
        if (other.getSource() != null && !other.getSource().equals(this.getSource())) {
            return false;
        }
        if (other.getTitle() == null ^ this.getTitle() == null) {
            return false;
        }
        if (other.getTitle() != null && !other.getTitle().equals(this.getTitle())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getCategory() == null ^ this.getCategory() == null) {
            return false;
        }
        if (other.getCategory() != null && !other.getCategory().equals(this.getCategory())) {
            return false;
        }
        if (other.getSeverity() == null ^ this.getSeverity() == null) {
            return false;
        }
        if (other.getSeverity() != null && !other.getSeverity().equals(this.getSeverity())) {
            return false;
        }
        if (other.getActualStartTime() == null ^ this.getActualStartTime() == null) {
            return false;
        }
        if (other.getActualStartTime() != null && !other.getActualStartTime().equals(this.getActualStartTime())) {
            return false;
        }
        if (other.getActualEndTime() == null ^ this.getActualEndTime() == null) {
            return false;
        }
        if (other.getActualEndTime() != null && !other.getActualEndTime().equals(this.getActualEndTime())) {
            return false;
        }
        if (other.getPlannedStartTime() == null ^ this.getPlannedStartTime() == null) {
            return false;
        }
        if (other.getPlannedStartTime() != null && !other.getPlannedStartTime().equals(this.getPlannedStartTime())) {
            return false;
        }
        if (other.getPlannedEndTime() == null ^ this.getPlannedEndTime() == null) {
            return false;
        }
        if (other.getPlannedEndTime() != null && !other.getPlannedEndTime().equals(this.getPlannedEndTime())) {
            return false;
        }
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        return other.getAccountId() == null || other.getAccountId().equals(this.getAccountId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getOpsItemType() == null ? 0 : this.getOpsItemType().hashCode());
        hashCode = 31 * hashCode + (this.getOperationalData() == null ? 0 : this.getOperationalData().hashCode());
        hashCode = 31 * hashCode + (this.getNotifications() == null ? 0 : this.getNotifications().hashCode());
        hashCode = 31 * hashCode + (this.getPriority() == null ? 0 : this.getPriority().hashCode());
        hashCode = 31 * hashCode + (this.getRelatedOpsItems() == null ? 0 : this.getRelatedOpsItems().hashCode());
        hashCode = 31 * hashCode + (this.getSource() == null ? 0 : this.getSource().hashCode());
        hashCode = 31 * hashCode + (this.getTitle() == null ? 0 : this.getTitle().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getCategory() == null ? 0 : this.getCategory().hashCode());
        hashCode = 31 * hashCode + (this.getSeverity() == null ? 0 : this.getSeverity().hashCode());
        hashCode = 31 * hashCode + (this.getActualStartTime() == null ? 0 : this.getActualStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getActualEndTime() == null ? 0 : this.getActualEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getPlannedStartTime() == null ? 0 : this.getPlannedStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getPlannedEndTime() == null ? 0 : this.getPlannedEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        return hashCode;
    }

    public CreateOpsItemRequest clone() {
        return (CreateOpsItemRequest)super.clone();
    }
}

