/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.OpsAggregator;
import com.amazonaws.services.simplesystemsmanagement.model.OpsFilter;
import com.amazonaws.services.simplesystemsmanagement.model.OpsResultAttribute;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class GetOpsSummaryRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String syncName;
    private SdkInternalList<OpsFilter> filters;
    private SdkInternalList<OpsAggregator> aggregators;
    private SdkInternalList<OpsResultAttribute> resultAttributes;
    private String nextToken;
    private Integer maxResults;

    public void setSyncName(String syncName) {
        this.syncName = syncName;
    }

    public String getSyncName() {
        return this.syncName;
    }

    public GetOpsSummaryRequest withSyncName(String syncName) {
        this.setSyncName(syncName);
        return this;
    }

    public List<OpsFilter> getFilters() {
        if (this.filters == null) {
            this.filters = new SdkInternalList();
        }
        return this.filters;
    }

    public void setFilters(Collection<OpsFilter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new SdkInternalList(filters);
    }

    public GetOpsSummaryRequest withFilters(OpsFilter ... filters) {
        if (this.filters == null) {
            this.setFilters((Collection<OpsFilter>)new SdkInternalList(filters.length));
        }
        for (OpsFilter ele : filters) {
            this.filters.add((Object)ele);
        }
        return this;
    }

    public GetOpsSummaryRequest withFilters(Collection<OpsFilter> filters) {
        this.setFilters(filters);
        return this;
    }

    public List<OpsAggregator> getAggregators() {
        if (this.aggregators == null) {
            this.aggregators = new SdkInternalList();
        }
        return this.aggregators;
    }

    public void setAggregators(Collection<OpsAggregator> aggregators) {
        if (aggregators == null) {
            this.aggregators = null;
            return;
        }
        this.aggregators = new SdkInternalList(aggregators);
    }

    public GetOpsSummaryRequest withAggregators(OpsAggregator ... aggregators) {
        if (this.aggregators == null) {
            this.setAggregators((Collection<OpsAggregator>)new SdkInternalList(aggregators.length));
        }
        for (OpsAggregator ele : aggregators) {
            this.aggregators.add((Object)ele);
        }
        return this;
    }

    public GetOpsSummaryRequest withAggregators(Collection<OpsAggregator> aggregators) {
        this.setAggregators(aggregators);
        return this;
    }

    public List<OpsResultAttribute> getResultAttributes() {
        if (this.resultAttributes == null) {
            this.resultAttributes = new SdkInternalList();
        }
        return this.resultAttributes;
    }

    public void setResultAttributes(Collection<OpsResultAttribute> resultAttributes) {
        if (resultAttributes == null) {
            this.resultAttributes = null;
            return;
        }
        this.resultAttributes = new SdkInternalList(resultAttributes);
    }

    public GetOpsSummaryRequest withResultAttributes(OpsResultAttribute ... resultAttributes) {
        if (this.resultAttributes == null) {
            this.setResultAttributes((Collection<OpsResultAttribute>)new SdkInternalList(resultAttributes.length));
        }
        for (OpsResultAttribute ele : resultAttributes) {
            this.resultAttributes.add((Object)ele);
        }
        return this;
    }

    public GetOpsSummaryRequest withResultAttributes(Collection<OpsResultAttribute> resultAttributes) {
        this.setResultAttributes(resultAttributes);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public GetOpsSummaryRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public GetOpsSummaryRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSyncName() != null) {
            sb.append("SyncName: ").append(this.getSyncName()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getAggregators() != null) {
            sb.append("Aggregators: ").append(this.getAggregators()).append(",");
        }
        if (this.getResultAttributes() != null) {
            sb.append("ResultAttributes: ").append(this.getResultAttributes()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOpsSummaryRequest)) {
            return false;
        }
        GetOpsSummaryRequest other = (GetOpsSummaryRequest)obj;
        if (other.getSyncName() == null ^ this.getSyncName() == null) {
            return false;
        }
        if (other.getSyncName() != null && !other.getSyncName().equals(this.getSyncName())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getAggregators() == null ^ this.getAggregators() == null) {
            return false;
        }
        if (other.getAggregators() != null && !other.getAggregators().equals(this.getAggregators())) {
            return false;
        }
        if (other.getResultAttributes() == null ^ this.getResultAttributes() == null) {
            return false;
        }
        if (other.getResultAttributes() != null && !other.getResultAttributes().equals(this.getResultAttributes())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        return other.getMaxResults() == null || other.getMaxResults().equals(this.getMaxResults());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSyncName() == null ? 0 : this.getSyncName().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getAggregators() == null ? 0 : this.getAggregators().hashCode());
        hashCode = 31 * hashCode + (this.getResultAttributes() == null ? 0 : this.getResultAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        return hashCode;
    }

    public GetOpsSummaryRequest clone() {
        return (GetOpsSummaryRequest)super.clone();
    }
}

