/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import java.util.List;

@SdkInternalApi
public class ReceiveMessageRequestMarshaller {
    private static final MarshallingInfo<String> QUEUEURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QueueUrl").build();
    private static final MarshallingInfo<List> ATTRIBUTENAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttributeNames").build();
    private static final MarshallingInfo<List> MESSAGESYSTEMATTRIBUTENAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MessageSystemAttributeNames").build();
    private static final MarshallingInfo<List> MESSAGEATTRIBUTENAMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MessageAttributeNames").build();
    private static final MarshallingInfo<Integer> MAXNUMBEROFMESSAGES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxNumberOfMessages").build();
    private static final MarshallingInfo<Integer> VISIBILITYTIMEOUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VisibilityTimeout").build();
    private static final MarshallingInfo<Integer> WAITTIMESECONDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WaitTimeSeconds").build();
    private static final MarshallingInfo<String> RECEIVEREQUESTATTEMPTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReceiveRequestAttemptId").build();
    private static final ReceiveMessageRequestMarshaller instance = new ReceiveMessageRequestMarshaller();

    public static ReceiveMessageRequestMarshaller getInstance() {
        return instance;
    }

    public void marshall(ReceiveMessageRequest receiveMessageRequest, ProtocolMarshaller protocolMarshaller) {
        if (receiveMessageRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)receiveMessageRequest.getQueueUrl(), QUEUEURL_BINDING);
            protocolMarshaller.marshall(receiveMessageRequest.getAttributeNames(), ATTRIBUTENAMES_BINDING);
            protocolMarshaller.marshall(receiveMessageRequest.getMessageSystemAttributeNames(), MESSAGESYSTEMATTRIBUTENAMES_BINDING);
            protocolMarshaller.marshall(receiveMessageRequest.getMessageAttributeNames(), MESSAGEATTRIBUTENAMES_BINDING);
            protocolMarshaller.marshall((Object)receiveMessageRequest.getMaxNumberOfMessages(), MAXNUMBEROFMESSAGES_BINDING);
            protocolMarshaller.marshall((Object)receiveMessageRequest.getVisibilityTimeout(), VISIBILITYTIMEOUT_BINDING);
            protocolMarshaller.marshall((Object)receiveMessageRequest.getWaitTimeSeconds(), WAITTIMESECONDS_BINDING);
            protocolMarshaller.marshall((Object)receiveMessageRequest.getReceiveRequestAttemptId(), RECEIVEREQUESTATTEMPTID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

